/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines how the image is scaled
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetImageScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetImageScalingConfiguration.Builder, SheetImageScalingConfiguration> {
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingType").getter(getter(SheetImageScalingConfiguration::scalingTypeAsString))
            .setter(setter(Builder::scalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scalingType;

    private SheetImageScalingConfiguration(BuilderImpl builder) {
        this.scalingType = builder.scalingType;
    }

    /**
     * <p>
     * The scaling option to use when fitting the image inside the container.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect ratio is
     * preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect ratio is
     * preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The image
     * aspect ratio is not preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the container.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link SheetImageScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scaling option to use when fitting the image inside the container.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect ratio
     *         is preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect
     *         ratio is preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The
     *         image aspect ratio is not preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the container.
     *         </p>
     *         </li>
     * @see SheetImageScalingType
     */
    public final SheetImageScalingType scalingType() {
        return SheetImageScalingType.fromValue(scalingType);
    }

    /**
     * <p>
     * The scaling option to use when fitting the image inside the container.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect ratio is
     * preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect ratio is
     * preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The image
     * aspect ratio is not preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the container.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link SheetImageScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scaling option to use when fitting the image inside the container.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect ratio
     *         is preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect
     *         ratio is preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The
     *         image aspect ratio is not preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the container.
     *         </p>
     *         </li>
     * @see SheetImageScalingType
     */
    public final String scalingTypeAsString() {
        return scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImageScalingConfiguration)) {
            return false;
        }
        SheetImageScalingConfiguration other = (SheetImageScalingConfiguration) obj;
        return Objects.equals(scalingTypeAsString(), other.scalingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetImageScalingConfiguration").add("ScalingType", scalingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingType":
            return Optional.ofNullable(clazz.cast(scalingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScalingType", SCALING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetImageScalingConfiguration, T> g) {
        return obj -> g.apply((SheetImageScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetImageScalingConfiguration> {
        /**
         * <p>
         * The scaling option to use when fitting the image inside the container.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect ratio is
         * preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect ratio
         * is preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The image
         * aspect ratio is not preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the container.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingType
         *        The scaling option to use when fitting the image inside the container.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect
         *        ratio is preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect
         *        ratio is preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The
         *        image aspect ratio is not preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the
         *        container.
         *        </p>
         *        </li>
         * @see SheetImageScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetImageScalingType
         */
        Builder scalingType(String scalingType);

        /**
         * <p>
         * The scaling option to use when fitting the image inside the container.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect ratio is
         * preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect ratio
         * is preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The image
         * aspect ratio is not preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the container.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingType
         *        The scaling option to use when fitting the image inside the container.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SCALE_TO_WIDTH</code>: The image takes up the entire width of the container. The image aspect
         *        ratio is preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCALE_TO_HEIGHT</code>: The image takes up the entire height of the container. The image aspect
         *        ratio is preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCALE_TO_CONTAINER</code>: The image takes up the entire width and height of the container. The
         *        image aspect ratio is not preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCALE_NONE</code>: The image is displayed in its original size and is not scaled to the
         *        container.
         *        </p>
         *        </li>
         * @see SheetImageScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetImageScalingType
         */
        Builder scalingType(SheetImageScalingType scalingType);
    }

    static final class BuilderImpl implements Builder {
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImageScalingConfiguration model) {
            scalingType(model.scalingType);
        }

        public final String getScalingType() {
            return scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(SheetImageScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        @Override
        public SheetImageScalingConfiguration build() {
            return new SheetImageScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
