/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for the email alerts that are sent when a dataset refresh fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshFailureEmailAlert implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshFailureEmailAlert.Builder, RefreshFailureEmailAlert> {
    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertStatus").getter(getter(RefreshFailureEmailAlert::alertStatusAsString))
            .setter(setter(Builder::alertStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alertStatus;

    private RefreshFailureEmailAlert(BuilderImpl builder) {
        this.alertStatus = builder.alertStatus;
    }

    /**
     * <p>
     * The status value that determines if email alerts are sent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link RefreshFailureAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The status value that determines if email alerts are sent.
     * @see RefreshFailureAlertStatus
     */
    public final RefreshFailureAlertStatus alertStatus() {
        return RefreshFailureAlertStatus.fromValue(alertStatus);
    }

    /**
     * <p>
     * The status value that determines if email alerts are sent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link RefreshFailureAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The status value that determines if email alerts are sent.
     * @see RefreshFailureAlertStatus
     */
    public final String alertStatusAsString() {
        return alertStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alertStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshFailureEmailAlert)) {
            return false;
        }
        RefreshFailureEmailAlert other = (RefreshFailureEmailAlert) obj;
        return Objects.equals(alertStatusAsString(), other.alertStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshFailureEmailAlert").add("AlertStatus", alertStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlertStatus":
            return Optional.ofNullable(clazz.cast(alertStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlertStatus", ALERT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshFailureEmailAlert, T> g) {
        return obj -> g.apply((RefreshFailureEmailAlert) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshFailureEmailAlert> {
        /**
         * <p>
         * The status value that determines if email alerts are sent.
         * </p>
         * 
         * @param alertStatus
         *        The status value that determines if email alerts are sent.
         * @see RefreshFailureAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshFailureAlertStatus
         */
        Builder alertStatus(String alertStatus);

        /**
         * <p>
         * The status value that determines if email alerts are sent.
         * </p>
         * 
         * @param alertStatus
         *        The status value that determines if email alerts are sent.
         * @see RefreshFailureAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshFailureAlertStatus
         */
        Builder alertStatus(RefreshFailureAlertStatus alertStatus);
    }

    static final class BuilderImpl implements Builder {
        private String alertStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshFailureEmailAlert model) {
            alertStatus(model.alertStatus);
        }

        public final String getAlertStatus() {
            return alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(RefreshFailureAlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        @Override
        public RefreshFailureEmailAlert build() {
            return new RefreshFailureEmailAlert(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
