/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardDefinitionResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDashboardDefinitionResponse.Builder, DescribeDashboardDefinitionResponse> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DescribeDashboardDefinitionResponse::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<List<DashboardError>> ERRORS_FIELD = SdkField
            .<List<DashboardError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DescribeDashboardDefinitionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashboardError> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashboardError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeDashboardDefinitionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(DescribeDashboardDefinitionResponse::resourceStatusAsString))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(DescribeDashboardDefinitionResponse::themeArn))
            .setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final SdkField<DashboardVersionDefinition> DEFINITION_FIELD = SdkField
            .<DashboardVersionDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(DescribeDashboardDefinitionResponse::definition)).setter(setter(Builder::definition))
            .constructor(DashboardVersionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDashboardDefinitionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDashboardDefinitionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<DashboardPublishOptions> DASHBOARD_PUBLISH_OPTIONS_FIELD = SdkField
            .<DashboardPublishOptions> builder(MarshallingType.SDK_POJO).memberName("DashboardPublishOptions")
            .getter(getter(DescribeDashboardDefinitionResponse::dashboardPublishOptions))
            .setter(setter(Builder::dashboardPublishOptions)).constructor(DashboardPublishOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardPublishOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            ERRORS_FIELD, NAME_FIELD, RESOURCE_STATUS_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, STATUS_FIELD, REQUEST_ID_FIELD,
            DASHBOARD_PUBLISH_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardId;

    private final List<DashboardError> errors;

    private final String name;

    private final String resourceStatus;

    private final String themeArn;

    private final DashboardVersionDefinition definition;

    private final Integer status;

    private final String requestId;

    private final DashboardPublishOptions dashboardPublishOptions;

    private DescribeDashboardDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.errors = builder.errors;
        this.name = builder.name;
        this.resourceStatus = builder.resourceStatus;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.dashboardPublishOptions = builder.dashboardPublishOptions;
    }

    /**
     * <p>
     * The ID of the dashboard described.
     * </p>
     * 
     * @return The ID of the dashboard described.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with this dashboard version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Errors associated with this dashboard version.
     */
    public final List<DashboardError> errors() {
        return errors;
    }

    /**
     * <p>
     * The display name of the dashboard.
     * </p>
     * 
     * @return The display name of the dashboard.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Status associated with the dashboard version.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Status associated with the dashboard version.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     * @see ResourceStatus
     */
    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Status associated with the dashboard version.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Status associated with the dashboard version.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     * @see ResourceStatus
     */
    public final String resourceStatusAsString() {
        return resourceStatus;
    }

    /**
     * <p>
     * The ARN of the theme of the dashboard.
     * </p>
     * 
     * @return The ARN of the theme of the dashboard.
     */
    public final String themeArn() {
        return themeArn;
    }

    /**
     * <p>
     * The definition of a dashboard.
     * </p>
     * <p>
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     * </p>
     * 
     * @return The definition of a dashboard.</p>
     *         <p>
     *         A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public final DashboardVersionDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Options for publishing the dashboard:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables the
     * left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is
     * <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when
     * this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
     * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>ExecutiveSummaryOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. The option to build an executive summary is disabled when this is
     * set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>DataStoriesSharingOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. The option to share a data story is disabled when this is set to
     * <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Options for publishing the dashboard:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight
     *         disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time)
     *         filtering. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't
     *         enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
     *         <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>ExecutiveSummaryOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. The option to build an executive summary is disabled when
     *         this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>DataStoriesSharingOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. The option to share a data story is disabled when this is
     *         set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     */
    public final DashboardPublishOptions dashboardPublishOptions() {
        return dashboardPublishOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardPublishOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardDefinitionResponse)) {
            return false;
        }
        DescribeDashboardDefinitionResponse other = (DescribeDashboardDefinitionResponse) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && Objects.equals(name(), other.name())
                && Objects.equals(resourceStatusAsString(), other.resourceStatusAsString())
                && Objects.equals(themeArn(), other.themeArn()) && Objects.equals(definition(), other.definition())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(dashboardPublishOptions(), other.dashboardPublishOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardDefinitionResponse").add("DashboardId", dashboardId())
                .add("Errors", hasErrors() ? errors() : null).add("Name", name()).add("ResourceStatus", resourceStatusAsString())
                .add("ThemeArn", themeArn()).add("Definition", definition()).add("Status", status())
                .add("RequestId", requestId()).add("DashboardPublishOptions", dashboardPublishOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatusAsString()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "DashboardPublishOptions":
            return Optional.ofNullable(clazz.cast(dashboardPublishOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ResourceStatus", RESOURCE_STATUS_FIELD);
        map.put("ThemeArn", THEME_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("DashboardPublishOptions", DASHBOARD_PUBLISH_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeDashboardDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDashboardDefinitionResponse> {
        /**
         * <p>
         * The ID of the dashboard described.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * Errors associated with this dashboard version.
         * </p>
         * 
         * @param errors
         *        Errors associated with this dashboard version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<DashboardError> errors);

        /**
         * <p>
         * Errors associated with this dashboard version.
         * </p>
         * 
         * @param errors
         *        Errors associated with this dashboard version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(DashboardError... errors);

        /**
         * <p>
         * Errors associated with this dashboard version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DashboardError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DashboardError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DashboardError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<DashboardError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DashboardError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<DashboardError>)
         */
        Builder errors(Consumer<DashboardError.Builder>... errors);

        /**
         * <p>
         * The display name of the dashboard.
         * </p>
         * 
         * @param name
         *        The display name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status associated with the dashboard version.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceStatus
         *        Status associated with the dashboard version.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Status associated with the dashboard version.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceStatus
         *        Status associated with the dashboard version.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * The ARN of the theme of the dashboard.
         * </p>
         * 
         * @param themeArn
         *        The ARN of the theme of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        /**
         * <p>
         * The definition of a dashboard.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * 
         * @param definition
         *        The definition of a dashboard.</p>
         *        <p>
         *        A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DashboardVersionDefinition definition);

        /**
         * <p>
         * The definition of a dashboard.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardVersionDefinition.Builder}
         * avoiding the need to create one manually via {@link DashboardVersionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardVersionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(DashboardVersionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DashboardVersionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DashboardVersionDefinition)
         */
        default Builder definition(Consumer<DashboardVersionDefinition.Builder> definition) {
            return definition(DashboardVersionDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Options for publishing the dashboard:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables
         * the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This
         * option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled
         * when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
         * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExecutiveSummaryOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The option to build an executive summary is disabled when this
         * is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>DataStoriesSharingOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The option to share a data story is disabled when this is set
         * to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dashboardPublishOptions
         *        Options for publishing the dashboard:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight
         *        disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time)
         *        filtering. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't
         *        enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be
         *        either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by
         *        default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>ExecutiveSummaryOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. The option to build an executive summary is disabled
         *        when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>DataStoriesSharingOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. The option to share a data story is disabled when this
         *        is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions);

        /**
         * <p>
         * Options for publishing the dashboard:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables
         * the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This
         * option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled
         * when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
         * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExecutiveSummaryOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The option to build an executive summary is disabled when this
         * is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>DataStoriesSharingOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The option to share a data story is disabled when this is set
         * to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link DashboardPublishOptions.Builder} avoiding
         * the need to create one manually via {@link DashboardPublishOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardPublishOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #dashboardPublishOptions(DashboardPublishOptions)}.
         * 
         * @param dashboardPublishOptions
         *        a consumer that will call methods on {@link DashboardPublishOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardPublishOptions(DashboardPublishOptions)
         */
        default Builder dashboardPublishOptions(Consumer<DashboardPublishOptions.Builder> dashboardPublishOptions) {
            return dashboardPublishOptions(DashboardPublishOptions.builder().applyMutation(dashboardPublishOptions).build());
        }
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String dashboardId;

        private List<DashboardError> errors = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String resourceStatus;

        private String themeArn;

        private DashboardVersionDefinition definition;

        private Integer status;

        private String requestId;

        private DashboardPublishOptions dashboardPublishOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardDefinitionResponse model) {
            super(model);
            dashboardId(model.dashboardId);
            errors(model.errors);
            name(model.name);
            resourceStatus(model.resourceStatus);
            themeArn(model.themeArn);
            definition(model.definition);
            status(model.status);
            requestId(model.requestId);
            dashboardPublishOptions(model.dashboardPublishOptions);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<DashboardError.Builder> getErrors() {
            List<DashboardError.Builder> result = DashboardErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<DashboardError.BuilderImpl> errors) {
            this.errors = DashboardErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<DashboardError> errors) {
            this.errors = DashboardErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DashboardError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DashboardError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> DashboardError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final DashboardVersionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(DashboardVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(DashboardVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final DashboardPublishOptions.Builder getDashboardPublishOptions() {
            return dashboardPublishOptions != null ? dashboardPublishOptions.toBuilder() : null;
        }

        public final void setDashboardPublishOptions(DashboardPublishOptions.BuilderImpl dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions != null ? dashboardPublishOptions.build() : null;
        }

        @Override
        public final Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        @Override
        public DescribeDashboardDefinitionResponse build() {
            return new DescribeDashboardDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
