/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The formatting configuration for the icon.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingIcon implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingIcon.Builder, ConditionalFormattingIcon> {
    private static final SdkField<ConditionalFormattingIconSet> ICON_SET_FIELD = SdkField
            .<ConditionalFormattingIconSet> builder(MarshallingType.SDK_POJO).memberName("IconSet")
            .getter(getter(ConditionalFormattingIcon::iconSet)).setter(setter(Builder::iconSet))
            .constructor(ConditionalFormattingIconSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconSet").build()).build();

    private static final SdkField<ConditionalFormattingCustomIconCondition> CUSTOM_CONDITION_FIELD = SdkField
            .<ConditionalFormattingCustomIconCondition> builder(MarshallingType.SDK_POJO).memberName("CustomCondition")
            .getter(getter(ConditionalFormattingIcon::customCondition)).setter(setter(Builder::customCondition))
            .constructor(ConditionalFormattingCustomIconCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICON_SET_FIELD,
            CUSTOM_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConditionalFormattingIconSet iconSet;

    private final ConditionalFormattingCustomIconCondition customCondition;

    private ConditionalFormattingIcon(BuilderImpl builder) {
        this.iconSet = builder.iconSet;
        this.customCondition = builder.customCondition;
    }

    /**
     * <p>
     * Formatting configuration for icon set.
     * </p>
     * 
     * @return Formatting configuration for icon set.
     */
    public final ConditionalFormattingIconSet iconSet() {
        return iconSet;
    }

    /**
     * <p>
     * Determines the custom condition for an icon set.
     * </p>
     * 
     * @return Determines the custom condition for an icon set.
     */
    public final ConditionalFormattingCustomIconCondition customCondition() {
        return customCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iconSet());
        hashCode = 31 * hashCode + Objects.hashCode(customCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingIcon)) {
            return false;
        }
        ConditionalFormattingIcon other = (ConditionalFormattingIcon) obj;
        return Objects.equals(iconSet(), other.iconSet()) && Objects.equals(customCondition(), other.customCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingIcon").add("IconSet", iconSet()).add("CustomCondition", customCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IconSet":
            return Optional.ofNullable(clazz.cast(iconSet()));
        case "CustomCondition":
            return Optional.ofNullable(clazz.cast(customCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IconSet", ICON_SET_FIELD);
        map.put("CustomCondition", CUSTOM_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingIcon, T> g) {
        return obj -> g.apply((ConditionalFormattingIcon) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingIcon> {
        /**
         * <p>
         * Formatting configuration for icon set.
         * </p>
         * 
         * @param iconSet
         *        Formatting configuration for icon set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconSet(ConditionalFormattingIconSet iconSet);

        /**
         * <p>
         * Formatting configuration for icon set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingIconSet.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingIconSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingIconSet.Builder#build()} is called
         * immediately and its result is passed to {@link #iconSet(ConditionalFormattingIconSet)}.
         * 
         * @param iconSet
         *        a consumer that will call methods on {@link ConditionalFormattingIconSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iconSet(ConditionalFormattingIconSet)
         */
        default Builder iconSet(Consumer<ConditionalFormattingIconSet.Builder> iconSet) {
            return iconSet(ConditionalFormattingIconSet.builder().applyMutation(iconSet).build());
        }

        /**
         * <p>
         * Determines the custom condition for an icon set.
         * </p>
         * 
         * @param customCondition
         *        Determines the custom condition for an icon set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCondition(ConditionalFormattingCustomIconCondition customCondition);

        /**
         * <p>
         * Determines the custom condition for an icon set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConditionalFormattingCustomIconCondition.Builder} avoiding the need to create one manually via
         * {@link ConditionalFormattingCustomIconCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingCustomIconCondition.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #customCondition(ConditionalFormattingCustomIconCondition)}.
         * 
         * @param customCondition
         *        a consumer that will call methods on {@link ConditionalFormattingCustomIconCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customCondition(ConditionalFormattingCustomIconCondition)
         */
        default Builder customCondition(Consumer<ConditionalFormattingCustomIconCondition.Builder> customCondition) {
            return customCondition(ConditionalFormattingCustomIconCondition.builder().applyMutation(customCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionalFormattingIconSet iconSet;

        private ConditionalFormattingCustomIconCondition customCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingIcon model) {
            iconSet(model.iconSet);
            customCondition(model.customCondition);
        }

        public final ConditionalFormattingIconSet.Builder getIconSet() {
            return iconSet != null ? iconSet.toBuilder() : null;
        }

        public final void setIconSet(ConditionalFormattingIconSet.BuilderImpl iconSet) {
            this.iconSet = iconSet != null ? iconSet.build() : null;
        }

        @Override
        public final Builder iconSet(ConditionalFormattingIconSet iconSet) {
            this.iconSet = iconSet;
            return this;
        }

        public final ConditionalFormattingCustomIconCondition.Builder getCustomCondition() {
            return customCondition != null ? customCondition.toBuilder() : null;
        }

        public final void setCustomCondition(ConditionalFormattingCustomIconCondition.BuilderImpl customCondition) {
            this.customCondition = customCondition != null ? customCondition.build() : null;
        }

        @Override
        public final Builder customCondition(ConditionalFormattingCustomIconCondition customCondition) {
            this.customCondition = customCondition;
            return this;
        }

        @Override
        public ConditionalFormattingIcon build() {
            return new ConditionalFormattingIcon(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
