/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AggFunctionParamMapCopier;
import software.amazon.awssdk.services.quicksight.model.AggType;
import software.amazon.awssdk.services.quicksight.model.TopicTimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggFunction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggFunction> {
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(AggFunction.getter(AggFunction::aggregationAsString)).setter(AggFunction.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final SdkField<Map<String, String>> AGGREGATION_FUNCTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AggregationFunctionParameters").getter(AggFunction.getter(AggFunction::aggregationFunctionParameters)).setter(AggFunction.setter(Builder::aggregationFunctionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunctionParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Period").getter(AggFunction.getter(AggFunction::periodAsString)).setter(AggFunction.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> PERIOD_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeriodField").getter(AggFunction.getter(AggFunction::periodField)).setter(AggFunction.setter(Builder::periodField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FIELD, AGGREGATION_FUNCTION_PARAMETERS_FIELD, PERIOD_FIELD, PERIOD_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggFunction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String aggregation;
    private final Map<String, String> aggregationFunctionParameters;
    private final String period;
    private final String periodField;

    private AggFunction(BuilderImpl builder) {
        this.aggregation = builder.aggregation;
        this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
        this.period = builder.period;
        this.periodField = builder.periodField;
    }

    public final AggType aggregation() {
        return AggType.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final boolean hasAggregationFunctionParameters() {
        return this.aggregationFunctionParameters != null && !(this.aggregationFunctionParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> aggregationFunctionParameters() {
        return this.aggregationFunctionParameters;
    }

    public final TopicTimeGranularity period() {
        return TopicTimeGranularity.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final String periodField() {
        return this.periodField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationFunctionParameters() ? this.aggregationFunctionParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggFunction)) {
            return false;
        }
        AggFunction other = (AggFunction)obj;
        return Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && this.hasAggregationFunctionParameters() == other.hasAggregationFunctionParameters() && Objects.equals(this.aggregationFunctionParameters(), other.aggregationFunctionParameters()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.periodField(), other.periodField());
    }

    public final String toString() {
        return ToString.builder((String)"AggFunction").add("Aggregation", (Object)this.aggregationAsString()).add("AggregationFunctionParameters", this.hasAggregationFunctionParameters() ? this.aggregationFunctionParameters() : null).add("Period", (Object)this.periodAsString()).add("PeriodField", (Object)this.periodField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "AggregationFunctionParameters": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunctionParameters()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "PeriodField": {
                return Optional.ofNullable(clazz.cast(this.periodField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Aggregation", AGGREGATION_FIELD);
        map.put("AggregationFunctionParameters", AGGREGATION_FUNCTION_PARAMETERS_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("PeriodField", PERIOD_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggFunction, T> g) {
        return obj -> g.apply((AggFunction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregation;
        private Map<String, String> aggregationFunctionParameters = DefaultSdkAutoConstructMap.getInstance();
        private String period;
        private String periodField;

        private BuilderImpl() {
        }

        private BuilderImpl(AggFunction model) {
            this.aggregation(model.aggregation);
            this.aggregationFunctionParameters(model.aggregationFunctionParameters);
            this.period(model.period);
            this.periodField(model.periodField);
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(AggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Map<String, String> getAggregationFunctionParameters() {
            if (this.aggregationFunctionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.aggregationFunctionParameters;
        }

        public final void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
        }

        @Override
        public final Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(TopicTimeGranularity period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getPeriodField() {
            return this.periodField;
        }

        public final void setPeriodField(String periodField) {
            this.periodField = periodField;
        }

        @Override
        public final Builder periodField(String periodField) {
            this.periodField = periodField;
            return this;
        }

        public AggFunction build() {
            return new AggFunction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggFunction> {
        public Builder aggregation(String var1);

        public Builder aggregation(AggType var1);

        public Builder aggregationFunctionParameters(Map<String, String> var1);

        public Builder period(String var1);

        public Builder period(TopicTimeGranularity var1);

        public Builder periodField(String var1);
    }
}

