/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThemeRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateThemeRequest.Builder, UpdateThemeRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateThemeRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeId").getter(getter(UpdateThemeRequest::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThemeId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateThemeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> BASE_THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseThemeId").getter(getter(UpdateThemeRequest::baseThemeId)).setter(setter(Builder::baseThemeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseThemeId").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(UpdateThemeRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<ThemeConfiguration> CONFIGURATION_FIELD = SdkField
            .<ThemeConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(UpdateThemeRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ThemeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            THEME_ID_FIELD, NAME_FIELD, BASE_THEME_ID_FIELD, VERSION_DESCRIPTION_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String themeId;

    private final String name;

    private final String baseThemeId;

    private final String versionDescription;

    private final ThemeConfiguration configuration;

    private UpdateThemeRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.themeId = builder.themeId;
        this.name = builder.name;
        this.baseThemeId = builder.baseThemeId;
        this.versionDescription = builder.versionDescription;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the theme that you're updating.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the theme that you're updating.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the theme.
     * </p>
     * 
     * @return The ID for the theme.
     */
    public final String themeId() {
        return themeId;
    }

    /**
     * <p>
     * The name for the theme.
     * </p>
     * 
     * @return The name for the theme.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from
     * a default QuickSight theme.
     * </p>
     * 
     * @return The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially
     *         inherit from a default QuickSight theme.
     */
    public final String baseThemeId() {
        return baseThemeId;
    }

    /**
     * <p>
     * A description of the theme version that you're updating Every time that you call <code>UpdateTheme</code>, you
     * create a new version of the theme. Each version of the theme maintains a description of the version in
     * <code>VersionDescription</code>.
     * </p>
     * 
     * @return A description of the theme version that you're updating Every time that you call <code>UpdateTheme</code>
     *         , you create a new version of the theme. Each version of the theme maintains a description of the version
     *         in <code>VersionDescription</code>.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The theme configuration, which contains the theme display properties.
     * </p>
     * 
     * @return The theme configuration, which contains the theme display properties.
     */
    public final ThemeConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(baseThemeId());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeRequest)) {
            return false;
        }
        UpdateThemeRequest other = (UpdateThemeRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(themeId(), other.themeId())
                && Objects.equals(name(), other.name()) && Objects.equals(baseThemeId(), other.baseThemeId())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateThemeRequest").add("AwsAccountId", awsAccountId()).add("ThemeId", themeId())
                .add("Name", name()).add("BaseThemeId", baseThemeId()).add("VersionDescription", versionDescription())
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "BaseThemeId":
            return Optional.ofNullable(clazz.cast(baseThemeId()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ThemeId", THEME_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("BaseThemeId", BASE_THEME_ID_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeRequest, T> g) {
        return obj -> g.apply((UpdateThemeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateThemeRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the theme that you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the theme that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the theme.
         * </p>
         * 
         * @param themeId
         *        The ID for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * <p>
         * The name for the theme.
         * </p>
         * 
         * @param name
         *        The name for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit
         * from a default QuickSight theme.
         * </p>
         * 
         * @param baseThemeId
         *        The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially
         *        inherit from a default QuickSight theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseThemeId(String baseThemeId);

        /**
         * <p>
         * A description of the theme version that you're updating Every time that you call <code>UpdateTheme</code>,
         * you create a new version of the theme. Each version of the theme maintains a description of the version in
         * <code>VersionDescription</code>.
         * </p>
         * 
         * @param versionDescription
         *        A description of the theme version that you're updating Every time that you call
         *        <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a
         *        description of the version in <code>VersionDescription</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The theme configuration, which contains the theme display properties.
         * </p>
         * 
         * @param configuration
         *        The theme configuration, which contains the theme display properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ThemeConfiguration configuration);

        /**
         * <p>
         * The theme configuration, which contains the theme display properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThemeConfiguration.Builder} avoiding the
         * need to create one manually via {@link ThemeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThemeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ThemeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ThemeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ThemeConfiguration)
         */
        default Builder configuration(Consumer<ThemeConfiguration.Builder> configuration) {
            return configuration(ThemeConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String themeId;

        private String name;

        private String baseThemeId;

        private String versionDescription;

        private ThemeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            themeId(model.themeId);
            name(model.name);
            baseThemeId(model.baseThemeId);
            versionDescription(model.versionDescription);
            configuration(model.configuration);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getThemeId() {
            return themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBaseThemeId() {
            return baseThemeId;
        }

        public final void setBaseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
        }

        @Override
        public final Builder baseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final ThemeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ThemeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ThemeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThemeRequest build() {
            return new UpdateThemeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
