/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQPersonalizationConfigurationRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateQPersonalizationConfigurationRequest.Builder, UpdateQPersonalizationConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateQPersonalizationConfigurationRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> PERSONALIZATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalizationMode")
            .getter(getter(UpdateQPersonalizationConfigurationRequest::personalizationModeAsString))
            .setter(setter(Builder::personalizationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalizationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            PERSONALIZATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String personalizationMode;

    private UpdateQPersonalizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.personalizationMode = builder.personalizationMode;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account account that contains the personalization configuration that the user
     * wants to update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account account that contains the personalization configuration that
     *         the user wants to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An option to allow QuickSight to customize data stories with user specific metadata, specifically location and
     * job information, in your IAM Identity Center instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #personalizationMode} will return {@link PersonalizationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #personalizationModeAsString}.
     * </p>
     * 
     * @return An option to allow QuickSight to customize data stories with user specific metadata, specifically
     *         location and job information, in your IAM Identity Center instance.
     * @see PersonalizationMode
     */
    public final PersonalizationMode personalizationMode() {
        return PersonalizationMode.fromValue(personalizationMode);
    }

    /**
     * <p>
     * An option to allow QuickSight to customize data stories with user specific metadata, specifically location and
     * job information, in your IAM Identity Center instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #personalizationMode} will return {@link PersonalizationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #personalizationModeAsString}.
     * </p>
     * 
     * @return An option to allow QuickSight to customize data stories with user specific metadata, specifically
     *         location and job information, in your IAM Identity Center instance.
     * @see PersonalizationMode
     */
    public final String personalizationModeAsString() {
        return personalizationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(personalizationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQPersonalizationConfigurationRequest)) {
            return false;
        }
        UpdateQPersonalizationConfigurationRequest other = (UpdateQPersonalizationConfigurationRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(personalizationModeAsString(), other.personalizationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQPersonalizationConfigurationRequest").add("AwsAccountId", awsAccountId())
                .add("PersonalizationMode", personalizationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "PersonalizationMode":
            return Optional.ofNullable(clazz.cast(personalizationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("PersonalizationMode", PERSONALIZATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQPersonalizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateQPersonalizationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateQPersonalizationConfigurationRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account account that contains the personalization configuration that the
         * user wants to update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account account that contains the personalization configuration that
         *        the user wants to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An option to allow QuickSight to customize data stories with user specific metadata, specifically location
         * and job information, in your IAM Identity Center instance.
         * </p>
         * 
         * @param personalizationMode
         *        An option to allow QuickSight to customize data stories with user specific metadata, specifically
         *        location and job information, in your IAM Identity Center instance.
         * @see PersonalizationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonalizationMode
         */
        Builder personalizationMode(String personalizationMode);

        /**
         * <p>
         * An option to allow QuickSight to customize data stories with user specific metadata, specifically location
         * and job information, in your IAM Identity Center instance.
         * </p>
         * 
         * @param personalizationMode
         *        An option to allow QuickSight to customize data stories with user specific metadata, specifically
         *        location and job information, in your IAM Identity Center instance.
         * @see PersonalizationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonalizationMode
         */
        Builder personalizationMode(PersonalizationMode personalizationMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String personalizationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQPersonalizationConfigurationRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            personalizationMode(model.personalizationMode);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getPersonalizationMode() {
            return personalizationMode;
        }

        public final void setPersonalizationMode(String personalizationMode) {
            this.personalizationMode = personalizationMode;
        }

        @Override
        public final Builder personalizationMode(String personalizationMode) {
            this.personalizationMode = personalizationMode;
            return this;
        }

        @Override
        public final Builder personalizationMode(PersonalizationMode personalizationMode) {
            this.personalizationMode(personalizationMode == null ? null : personalizationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQPersonalizationConfigurationRequest build() {
            return new UpdateQPersonalizationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
