/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The table options for a table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableOptions implements SdkPojo, Serializable, ToCopyableBuilder<TableOptions.Builder, TableOptions> {
    private static final SdkField<String> ORIENTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Orientation").getter(getter(TableOptions::orientationAsString)).setter(setter(Builder::orientation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orientation").build()).build();

    private static final SdkField<TableCellStyle> HEADER_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("HeaderStyle")
            .getter(getter(TableOptions::headerStyle)).setter(setter(Builder::headerStyle)).constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderStyle").build()).build();

    private static final SdkField<TableCellStyle> CELL_STYLE_FIELD = SdkField.<TableCellStyle> builder(MarshallingType.SDK_POJO)
            .memberName("CellStyle").getter(getter(TableOptions::cellStyle)).setter(setter(Builder::cellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellStyle").build()).build();

    private static final SdkField<RowAlternateColorOptions> ROW_ALTERNATE_COLOR_OPTIONS_FIELD = SdkField
            .<RowAlternateColorOptions> builder(MarshallingType.SDK_POJO).memberName("RowAlternateColorOptions")
            .getter(getter(TableOptions::rowAlternateColorOptions)).setter(setter(Builder::rowAlternateColorOptions))
            .constructor(RowAlternateColorOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAlternateColorOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIENTATION_FIELD,
            HEADER_STYLE_FIELD, CELL_STYLE_FIELD, ROW_ALTERNATE_COLOR_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String orientation;

    private final TableCellStyle headerStyle;

    private final TableCellStyle cellStyle;

    private final RowAlternateColorOptions rowAlternateColorOptions;

    private TableOptions(BuilderImpl builder) {
        this.orientation = builder.orientation;
        this.headerStyle = builder.headerStyle;
        this.cellStyle = builder.cellStyle;
        this.rowAlternateColorOptions = builder.rowAlternateColorOptions;
    }

    /**
     * <p>
     * The orientation (vertical, horizontal) for a table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orientation} will
     * return {@link TableOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orientationAsString}.
     * </p>
     * 
     * @return The orientation (vertical, horizontal) for a table.
     * @see TableOrientation
     */
    public final TableOrientation orientation() {
        return TableOrientation.fromValue(orientation);
    }

    /**
     * <p>
     * The orientation (vertical, horizontal) for a table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orientation} will
     * return {@link TableOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orientationAsString}.
     * </p>
     * 
     * @return The orientation (vertical, horizontal) for a table.
     * @see TableOrientation
     */
    public final String orientationAsString() {
        return orientation;
    }

    /**
     * <p>
     * The table cell style of a table header.
     * </p>
     * 
     * @return The table cell style of a table header.
     */
    public final TableCellStyle headerStyle() {
        return headerStyle;
    }

    /**
     * <p>
     * The table cell style of table cells.
     * </p>
     * 
     * @return The table cell style of table cells.
     */
    public final TableCellStyle cellStyle() {
        return cellStyle;
    }

    /**
     * <p>
     * The row alternate color options (widget status, row alternate colors) for a table.
     * </p>
     * 
     * @return The row alternate color options (widget status, row alternate colors) for a table.
     */
    public final RowAlternateColorOptions rowAlternateColorOptions() {
        return rowAlternateColorOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(orientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(headerStyle());
        hashCode = 31 * hashCode + Objects.hashCode(cellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(rowAlternateColorOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptions)) {
            return false;
        }
        TableOptions other = (TableOptions) obj;
        return Objects.equals(orientationAsString(), other.orientationAsString())
                && Objects.equals(headerStyle(), other.headerStyle()) && Objects.equals(cellStyle(), other.cellStyle())
                && Objects.equals(rowAlternateColorOptions(), other.rowAlternateColorOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableOptions").add("Orientation", orientationAsString()).add("HeaderStyle", headerStyle())
                .add("CellStyle", cellStyle()).add("RowAlternateColorOptions", rowAlternateColorOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Orientation":
            return Optional.ofNullable(clazz.cast(orientationAsString()));
        case "HeaderStyle":
            return Optional.ofNullable(clazz.cast(headerStyle()));
        case "CellStyle":
            return Optional.ofNullable(clazz.cast(cellStyle()));
        case "RowAlternateColorOptions":
            return Optional.ofNullable(clazz.cast(rowAlternateColorOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Orientation", ORIENTATION_FIELD);
        map.put("HeaderStyle", HEADER_STYLE_FIELD);
        map.put("CellStyle", CELL_STYLE_FIELD);
        map.put("RowAlternateColorOptions", ROW_ALTERNATE_COLOR_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptions, T> g) {
        return obj -> g.apply((TableOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableOptions> {
        /**
         * <p>
         * The orientation (vertical, horizontal) for a table.
         * </p>
         * 
         * @param orientation
         *        The orientation (vertical, horizontal) for a table.
         * @see TableOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOrientation
         */
        Builder orientation(String orientation);

        /**
         * <p>
         * The orientation (vertical, horizontal) for a table.
         * </p>
         * 
         * @param orientation
         *        The orientation (vertical, horizontal) for a table.
         * @see TableOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOrientation
         */
        Builder orientation(TableOrientation orientation);

        /**
         * <p>
         * The table cell style of a table header.
         * </p>
         * 
         * @param headerStyle
         *        The table cell style of a table header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerStyle(TableCellStyle headerStyle);

        /**
         * <p>
         * The table cell style of a table header.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #headerStyle(TableCellStyle)}.
         * 
         * @param headerStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerStyle(TableCellStyle)
         */
        default Builder headerStyle(Consumer<TableCellStyle.Builder> headerStyle) {
            return headerStyle(TableCellStyle.builder().applyMutation(headerStyle).build());
        }

        /**
         * <p>
         * The table cell style of table cells.
         * </p>
         * 
         * @param cellStyle
         *        The table cell style of table cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellStyle(TableCellStyle cellStyle);

        /**
         * <p>
         * The table cell style of table cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #cellStyle(TableCellStyle)}.
         * 
         * @param cellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellStyle(TableCellStyle)
         */
        default Builder cellStyle(Consumer<TableCellStyle.Builder> cellStyle) {
            return cellStyle(TableCellStyle.builder().applyMutation(cellStyle).build());
        }

        /**
         * <p>
         * The row alternate color options (widget status, row alternate colors) for a table.
         * </p>
         * 
         * @param rowAlternateColorOptions
         *        The row alternate color options (widget status, row alternate colors) for a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions);

        /**
         * <p>
         * The row alternate color options (widget status, row alternate colors) for a table.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowAlternateColorOptions.Builder}
         * avoiding the need to create one manually via {@link RowAlternateColorOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowAlternateColorOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #rowAlternateColorOptions(RowAlternateColorOptions)}.
         * 
         * @param rowAlternateColorOptions
         *        a consumer that will call methods on {@link RowAlternateColorOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowAlternateColorOptions(RowAlternateColorOptions)
         */
        default Builder rowAlternateColorOptions(Consumer<RowAlternateColorOptions.Builder> rowAlternateColorOptions) {
            return rowAlternateColorOptions(RowAlternateColorOptions.builder().applyMutation(rowAlternateColorOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String orientation;

        private TableCellStyle headerStyle;

        private TableCellStyle cellStyle;

        private RowAlternateColorOptions rowAlternateColorOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptions model) {
            orientation(model.orientation);
            headerStyle(model.headerStyle);
            cellStyle(model.cellStyle);
            rowAlternateColorOptions(model.rowAlternateColorOptions);
        }

        public final String getOrientation() {
            return orientation;
        }

        public final void setOrientation(String orientation) {
            this.orientation = orientation;
        }

        @Override
        public final Builder orientation(String orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public final Builder orientation(TableOrientation orientation) {
            this.orientation(orientation == null ? null : orientation.toString());
            return this;
        }

        public final TableCellStyle.Builder getHeaderStyle() {
            return headerStyle != null ? headerStyle.toBuilder() : null;
        }

        public final void setHeaderStyle(TableCellStyle.BuilderImpl headerStyle) {
            this.headerStyle = headerStyle != null ? headerStyle.build() : null;
        }

        @Override
        public final Builder headerStyle(TableCellStyle headerStyle) {
            this.headerStyle = headerStyle;
            return this;
        }

        public final TableCellStyle.Builder getCellStyle() {
            return cellStyle != null ? cellStyle.toBuilder() : null;
        }

        public final void setCellStyle(TableCellStyle.BuilderImpl cellStyle) {
            this.cellStyle = cellStyle != null ? cellStyle.build() : null;
        }

        @Override
        public final Builder cellStyle(TableCellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public final RowAlternateColorOptions.Builder getRowAlternateColorOptions() {
            return rowAlternateColorOptions != null ? rowAlternateColorOptions.toBuilder() : null;
        }

        public final void setRowAlternateColorOptions(RowAlternateColorOptions.BuilderImpl rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions != null ? rowAlternateColorOptions.build() : null;
        }

        @Override
        public final Builder rowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions;
            return this;
        }

        @Override
        public TableOptions build() {
            return new TableOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
