/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the QuickSight console that you want to embed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserQuickSightConsoleEmbeddingConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder, RegisteredUserQuickSightConsoleEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialPath").getter(getter(RegisteredUserQuickSightConsoleEmbeddingConfiguration::initialPath))
            .setter(setter(Builder::initialPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialPath").build()).build();

    private static final SdkField<RegisteredUserConsoleFeatureConfigurations> FEATURE_CONFIGURATIONS_FIELD = SdkField
            .<RegisteredUserConsoleFeatureConfigurations> builder(MarshallingType.SDK_POJO).memberName("FeatureConfigurations")
            .getter(getter(RegisteredUserQuickSightConsoleEmbeddingConfiguration::featureConfigurations))
            .setter(setter(Builder::featureConfigurations)).constructor(RegisteredUserConsoleFeatureConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_PATH_FIELD,
            FEATURE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String initialPath;

    private final RegisteredUserConsoleFeatureConfigurations featureConfigurations;

    private RegisteredUserQuickSightConsoleEmbeddingConfiguration(BuilderImpl builder) {
        this.initialPath = builder.initialPath;
        this.featureConfigurations = builder.featureConfigurations;
    }

    /**
     * <p>
     * The initial URL path for the QuickSight console. <code>InitialPath</code> is required.
     * </p>
     * <p>
     * The entry point URL is constrained to the following paths:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>/start</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/analyses</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/dashboards</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/favorites</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the QuickSight console URL of
     * the dashboard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the QuickSight console URL of the
     * analysis.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The initial URL path for the QuickSight console. <code>InitialPath</code> is required.</p>
     *         <p>
     *         The entry point URL is constrained to the following paths:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>/start</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/analyses</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/dashboards</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/favorites</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the QuickSight console
     *         URL of the dashboard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the QuickSight console URL
     *         of the analysis.
     *         </p>
     *         </li>
     */
    public final String initialPath() {
        return initialPath;
    }

    /**
     * <p>
     * The embedding configuration of an embedded QuickSight console.
     * </p>
     * 
     * @return The embedding configuration of an embedded QuickSight console.
     */
    public final RegisteredUserConsoleFeatureConfigurations featureConfigurations() {
        return featureConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialPath());
        hashCode = 31 * hashCode + Objects.hashCode(featureConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserQuickSightConsoleEmbeddingConfiguration)) {
            return false;
        }
        RegisteredUserQuickSightConsoleEmbeddingConfiguration other = (RegisteredUserQuickSightConsoleEmbeddingConfiguration) obj;
        return Objects.equals(initialPath(), other.initialPath())
                && Objects.equals(featureConfigurations(), other.featureConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserQuickSightConsoleEmbeddingConfiguration").add("InitialPath", initialPath())
                .add("FeatureConfigurations", featureConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialPath":
            return Optional.ofNullable(clazz.cast(initialPath()));
        case "FeatureConfigurations":
            return Optional.ofNullable(clazz.cast(featureConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InitialPath", INITIAL_PATH_FIELD);
        map.put("FeatureConfigurations", FEATURE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserQuickSightConsoleEmbeddingConfiguration, T> g) {
        return obj -> g.apply((RegisteredUserQuickSightConsoleEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserQuickSightConsoleEmbeddingConfiguration> {
        /**
         * <p>
         * The initial URL path for the QuickSight console. <code>InitialPath</code> is required.
         * </p>
         * <p>
         * The entry point URL is constrained to the following paths:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>/start</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/analyses</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/dashboards</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/favorites</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the QuickSight console URL
         * of the dashboard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the QuickSight console URL of
         * the analysis.
         * </p>
         * </li>
         * </ul>
         * 
         * @param initialPath
         *        The initial URL path for the QuickSight console. <code>InitialPath</code> is required.</p>
         *        <p>
         *        The entry point URL is constrained to the following paths:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>/start</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/analyses</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/dashboards</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/favorites</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the QuickSight
         *        console URL of the dashboard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the QuickSight console
         *        URL of the analysis.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialPath(String initialPath);

        /**
         * <p>
         * The embedding configuration of an embedded QuickSight console.
         * </p>
         * 
         * @param featureConfigurations
         *        The embedding configuration of an embedded QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureConfigurations(RegisteredUserConsoleFeatureConfigurations featureConfigurations);

        /**
         * <p>
         * The embedding configuration of an embedded QuickSight console.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RegisteredUserConsoleFeatureConfigurations.Builder} avoiding the need to create one manually via
         * {@link RegisteredUserConsoleFeatureConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegisteredUserConsoleFeatureConfigurations.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #featureConfigurations(RegisteredUserConsoleFeatureConfigurations)}.
         * 
         * @param featureConfigurations
         *        a consumer that will call methods on {@link RegisteredUserConsoleFeatureConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureConfigurations(RegisteredUserConsoleFeatureConfigurations)
         */
        default Builder featureConfigurations(Consumer<RegisteredUserConsoleFeatureConfigurations.Builder> featureConfigurations) {
            return featureConfigurations(RegisteredUserConsoleFeatureConfigurations.builder()
                    .applyMutation(featureConfigurations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String initialPath;

        private RegisteredUserConsoleFeatureConfigurations featureConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserQuickSightConsoleEmbeddingConfiguration model) {
            initialPath(model.initialPath);
            featureConfigurations(model.featureConfigurations);
        }

        public final String getInitialPath() {
            return initialPath;
        }

        public final void setInitialPath(String initialPath) {
            this.initialPath = initialPath;
        }

        @Override
        public final Builder initialPath(String initialPath) {
            this.initialPath = initialPath;
            return this;
        }

        public final RegisteredUserConsoleFeatureConfigurations.Builder getFeatureConfigurations() {
            return featureConfigurations != null ? featureConfigurations.toBuilder() : null;
        }

        public final void setFeatureConfigurations(RegisteredUserConsoleFeatureConfigurations.BuilderImpl featureConfigurations) {
            this.featureConfigurations = featureConfigurations != null ? featureConfigurations.build() : null;
        }

        @Override
        public final Builder featureConfigurations(RegisteredUserConsoleFeatureConfigurations featureConfigurations) {
            this.featureConfigurations = featureConfigurations;
            return this;
        }

        @Override
        public RegisteredUserQuickSightConsoleEmbeddingConfiguration build() {
            return new RegisteredUserQuickSightConsoleEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
