/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The symbol style for a line layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLineSymbolStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLineSymbolStyle.Builder, GeospatialLineSymbolStyle> {
    private static final SdkField<GeospatialColor> FILL_COLOR_FIELD = SdkField
            .<GeospatialColor> builder(MarshallingType.SDK_POJO).memberName("FillColor")
            .getter(getter(GeospatialLineSymbolStyle::fillColor)).setter(setter(Builder::fillColor))
            .constructor(GeospatialColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillColor").build()).build();

    private static final SdkField<GeospatialLineWidth> LINE_WIDTH_FIELD = SdkField
            .<GeospatialLineWidth> builder(MarshallingType.SDK_POJO).memberName("LineWidth")
            .getter(getter(GeospatialLineSymbolStyle::lineWidth)).setter(setter(Builder::lineWidth))
            .constructor(GeospatialLineWidth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILL_COLOR_FIELD,
            LINE_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialColor fillColor;

    private final GeospatialLineWidth lineWidth;

    private GeospatialLineSymbolStyle(BuilderImpl builder) {
        this.fillColor = builder.fillColor;
        this.lineWidth = builder.lineWidth;
    }

    /**
     * <p>
     * The color and opacity values for the fill color.
     * </p>
     * 
     * @return The color and opacity values for the fill color.
     */
    public final GeospatialColor fillColor() {
        return fillColor;
    }

    /**
     * <p>
     * The width value for a line.
     * </p>
     * 
     * @return The width value for a line.
     */
    public final GeospatialLineWidth lineWidth() {
        return lineWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fillColor());
        hashCode = 31 * hashCode + Objects.hashCode(lineWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLineSymbolStyle)) {
            return false;
        }
        GeospatialLineSymbolStyle other = (GeospatialLineSymbolStyle) obj;
        return Objects.equals(fillColor(), other.fillColor()) && Objects.equals(lineWidth(), other.lineWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLineSymbolStyle").add("FillColor", fillColor()).add("LineWidth", lineWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FillColor":
            return Optional.ofNullable(clazz.cast(fillColor()));
        case "LineWidth":
            return Optional.ofNullable(clazz.cast(lineWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FillColor", FILL_COLOR_FIELD);
        map.put("LineWidth", LINE_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLineSymbolStyle, T> g) {
        return obj -> g.apply((GeospatialLineSymbolStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLineSymbolStyle> {
        /**
         * <p>
         * The color and opacity values for the fill color.
         * </p>
         * 
         * @param fillColor
         *        The color and opacity values for the fill color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillColor(GeospatialColor fillColor);

        /**
         * <p>
         * The color and opacity values for the fill color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialColor.Builder} avoiding the
         * need to create one manually via {@link GeospatialColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialColor.Builder#build()} is called immediately and its
         * result is passed to {@link #fillColor(GeospatialColor)}.
         * 
         * @param fillColor
         *        a consumer that will call methods on {@link GeospatialColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fillColor(GeospatialColor)
         */
        default Builder fillColor(Consumer<GeospatialColor.Builder> fillColor) {
            return fillColor(GeospatialColor.builder().applyMutation(fillColor).build());
        }

        /**
         * <p>
         * The width value for a line.
         * </p>
         * 
         * @param lineWidth
         *        The width value for a line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineWidth(GeospatialLineWidth lineWidth);

        /**
         * <p>
         * The width value for a line.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLineWidth.Builder} avoiding the
         * need to create one manually via {@link GeospatialLineWidth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLineWidth.Builder#build()} is called immediately and
         * its result is passed to {@link #lineWidth(GeospatialLineWidth)}.
         * 
         * @param lineWidth
         *        a consumer that will call methods on {@link GeospatialLineWidth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineWidth(GeospatialLineWidth)
         */
        default Builder lineWidth(Consumer<GeospatialLineWidth.Builder> lineWidth) {
            return lineWidth(GeospatialLineWidth.builder().applyMutation(lineWidth).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialColor fillColor;

        private GeospatialLineWidth lineWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLineSymbolStyle model) {
            fillColor(model.fillColor);
            lineWidth(model.lineWidth);
        }

        public final GeospatialColor.Builder getFillColor() {
            return fillColor != null ? fillColor.toBuilder() : null;
        }

        public final void setFillColor(GeospatialColor.BuilderImpl fillColor) {
            this.fillColor = fillColor != null ? fillColor.build() : null;
        }

        @Override
        public final Builder fillColor(GeospatialColor fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public final GeospatialLineWidth.Builder getLineWidth() {
            return lineWidth != null ? lineWidth.toBuilder() : null;
        }

        public final void setLineWidth(GeospatialLineWidth.BuilderImpl lineWidth) {
            this.lineWidth = lineWidth != null ? lineWidth.build() : null;
        }

        @Override
        public final Builder lineWidth(GeospatialLineWidth lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        @Override
        public GeospatialLineSymbolStyle build() {
            return new GeospatialLineSymbolStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
