/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * With a <code>Filter</code>, you can remove portions of data from a particular visual or view.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<CategoryFilter> CATEGORY_FILTER_FIELD = SdkField
            .<CategoryFilter> builder(MarshallingType.SDK_POJO).memberName("CategoryFilter")
            .getter(getter(Filter::categoryFilter)).setter(setter(Builder::categoryFilter)).constructor(CategoryFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilter").build()).build();

    private static final SdkField<NumericRangeFilter> NUMERIC_RANGE_FILTER_FIELD = SdkField
            .<NumericRangeFilter> builder(MarshallingType.SDK_POJO).memberName("NumericRangeFilter")
            .getter(getter(Filter::numericRangeFilter)).setter(setter(Builder::numericRangeFilter))
            .constructor(NumericRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericRangeFilter").build())
            .build();

    private static final SdkField<NumericEqualityFilter> NUMERIC_EQUALITY_FILTER_FIELD = SdkField
            .<NumericEqualityFilter> builder(MarshallingType.SDK_POJO).memberName("NumericEqualityFilter")
            .getter(getter(Filter::numericEqualityFilter)).setter(setter(Builder::numericEqualityFilter))
            .constructor(NumericEqualityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericEqualityFilter").build())
            .build();

    private static final SdkField<TimeEqualityFilter> TIME_EQUALITY_FILTER_FIELD = SdkField
            .<TimeEqualityFilter> builder(MarshallingType.SDK_POJO).memberName("TimeEqualityFilter")
            .getter(getter(Filter::timeEqualityFilter)).setter(setter(Builder::timeEqualityFilter))
            .constructor(TimeEqualityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeEqualityFilter").build())
            .build();

    private static final SdkField<TimeRangeFilter> TIME_RANGE_FILTER_FIELD = SdkField
            .<TimeRangeFilter> builder(MarshallingType.SDK_POJO).memberName("TimeRangeFilter")
            .getter(getter(Filter::timeRangeFilter)).setter(setter(Builder::timeRangeFilter))
            .constructor(TimeRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()).build();

    private static final SdkField<RelativeDatesFilter> RELATIVE_DATES_FILTER_FIELD = SdkField
            .<RelativeDatesFilter> builder(MarshallingType.SDK_POJO).memberName("RelativeDatesFilter")
            .getter(getter(Filter::relativeDatesFilter)).setter(setter(Builder::relativeDatesFilter))
            .constructor(RelativeDatesFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDatesFilter").build())
            .build();

    private static final SdkField<TopBottomFilter> TOP_BOTTOM_FILTER_FIELD = SdkField
            .<TopBottomFilter> builder(MarshallingType.SDK_POJO).memberName("TopBottomFilter")
            .getter(getter(Filter::topBottomFilter)).setter(setter(Builder::topBottomFilter))
            .constructor(TopBottomFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomFilter").build()).build();

    private static final SdkField<NestedFilter> NESTED_FILTER_FIELD = SdkField.<NestedFilter> builder(MarshallingType.SDK_POJO)
            .memberName("NestedFilter").getter(getter(Filter::nestedFilter)).setter(setter(Builder::nestedFilter))
            .constructor(NestedFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FILTER_FIELD,
            NUMERIC_RANGE_FILTER_FIELD, NUMERIC_EQUALITY_FILTER_FIELD, TIME_EQUALITY_FILTER_FIELD, TIME_RANGE_FILTER_FIELD,
            RELATIVE_DATES_FILTER_FIELD, TOP_BOTTOM_FILTER_FIELD, NESTED_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CategoryFilter categoryFilter;

    private final NumericRangeFilter numericRangeFilter;

    private final NumericEqualityFilter numericEqualityFilter;

    private final TimeEqualityFilter timeEqualityFilter;

    private final TimeRangeFilter timeRangeFilter;

    private final RelativeDatesFilter relativeDatesFilter;

    private final TopBottomFilter topBottomFilter;

    private final NestedFilter nestedFilter;

    private Filter(BuilderImpl builder) {
        this.categoryFilter = builder.categoryFilter;
        this.numericRangeFilter = builder.numericRangeFilter;
        this.numericEqualityFilter = builder.numericEqualityFilter;
        this.timeEqualityFilter = builder.timeEqualityFilter;
        this.timeRangeFilter = builder.timeRangeFilter;
        this.relativeDatesFilter = builder.relativeDatesFilter;
        this.topBottomFilter = builder.topBottomFilter;
        this.nestedFilter = builder.nestedFilter;
    }

    /**
     * <p>
     * A <code>CategoryFilter</code> filters text values.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text
     * filters</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * 
     * @return A <code>CategoryFilter</code> filters text values.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text
     *         filters</a> in the <i>Amazon QuickSight User Guide</i>.
     */
    public final CategoryFilter categoryFilter() {
        return categoryFilter;
    }

    /**
     * <p>
     * A <code>NumericRangeFilter</code> filters numeric values that are either inside or outside a given numeric range.
     * </p>
     * 
     * @return A <code>NumericRangeFilter</code> filters numeric values that are either inside or outside a given
     *         numeric range.
     */
    public final NumericRangeFilter numericRangeFilter() {
        return numericRangeFilter;
    }

    /**
     * <p>
     * A <code>NumericEqualityFilter</code> filters numeric values that equal or do not equal a given numeric value.
     * </p>
     * 
     * @return A <code>NumericEqualityFilter</code> filters numeric values that equal or do not equal a given numeric
     *         value.
     */
    public final NumericEqualityFilter numericEqualityFilter() {
        return numericEqualityFilter;
    }

    /**
     * <p>
     * A <code>TimeEqualityFilter</code> filters date-time values that equal or do not equal a given date/time value.
     * </p>
     * 
     * @return A <code>TimeEqualityFilter</code> filters date-time values that equal or do not equal a given date/time
     *         value.
     */
    public final TimeEqualityFilter timeEqualityFilter() {
        return timeEqualityFilter;
    }

    /**
     * <p>
     * A <code>TimeRangeFilter</code> filters date-time values that are either inside or outside a given date/time
     * range.
     * </p>
     * 
     * @return A <code>TimeRangeFilter</code> filters date-time values that are either inside or outside a given
     *         date/time range.
     */
    public final TimeRangeFilter timeRangeFilter() {
        return timeRangeFilter;
    }

    /**
     * <p>
     * A <code>RelativeDatesFilter</code> filters date values that are relative to a given date.
     * </p>
     * 
     * @return A <code>RelativeDatesFilter</code> filters date values that are relative to a given date.
     */
    public final RelativeDatesFilter relativeDatesFilter() {
        return relativeDatesFilter;
    }

    /**
     * <p>
     * A <code>TopBottomFilter</code> filters data to the top or bottom values for a given column.
     * </p>
     * 
     * @return A <code>TopBottomFilter</code> filters data to the top or bottom values for a given column.
     */
    public final TopBottomFilter topBottomFilter() {
        return topBottomFilter;
    }

    /**
     * <p>
     * A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner filter.
     * </p>
     * 
     * @return A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner
     *         filter.
     */
    public final NestedFilter nestedFilter() {
        return nestedFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(numericRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(numericEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(timeEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(relativeDatesFilter());
        hashCode = 31 * hashCode + Objects.hashCode(topBottomFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nestedFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(categoryFilter(), other.categoryFilter())
                && Objects.equals(numericRangeFilter(), other.numericRangeFilter())
                && Objects.equals(numericEqualityFilter(), other.numericEqualityFilter())
                && Objects.equals(timeEqualityFilter(), other.timeEqualityFilter())
                && Objects.equals(timeRangeFilter(), other.timeRangeFilter())
                && Objects.equals(relativeDatesFilter(), other.relativeDatesFilter())
                && Objects.equals(topBottomFilter(), other.topBottomFilter())
                && Objects.equals(nestedFilter(), other.nestedFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("CategoryFilter", categoryFilter()).add("NumericRangeFilter", numericRangeFilter())
                .add("NumericEqualityFilter", numericEqualityFilter()).add("TimeEqualityFilter", timeEqualityFilter())
                .add("TimeRangeFilter", timeRangeFilter()).add("RelativeDatesFilter", relativeDatesFilter())
                .add("TopBottomFilter", topBottomFilter()).add("NestedFilter", nestedFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryFilter":
            return Optional.ofNullable(clazz.cast(categoryFilter()));
        case "NumericRangeFilter":
            return Optional.ofNullable(clazz.cast(numericRangeFilter()));
        case "NumericEqualityFilter":
            return Optional.ofNullable(clazz.cast(numericEqualityFilter()));
        case "TimeEqualityFilter":
            return Optional.ofNullable(clazz.cast(timeEqualityFilter()));
        case "TimeRangeFilter":
            return Optional.ofNullable(clazz.cast(timeRangeFilter()));
        case "RelativeDatesFilter":
            return Optional.ofNullable(clazz.cast(relativeDatesFilter()));
        case "TopBottomFilter":
            return Optional.ofNullable(clazz.cast(topBottomFilter()));
        case "NestedFilter":
            return Optional.ofNullable(clazz.cast(nestedFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CategoryFilter", CATEGORY_FILTER_FIELD);
        map.put("NumericRangeFilter", NUMERIC_RANGE_FILTER_FIELD);
        map.put("NumericEqualityFilter", NUMERIC_EQUALITY_FILTER_FIELD);
        map.put("TimeEqualityFilter", TIME_EQUALITY_FILTER_FIELD);
        map.put("TimeRangeFilter", TIME_RANGE_FILTER_FIELD);
        map.put("RelativeDatesFilter", RELATIVE_DATES_FILTER_FIELD);
        map.put("TopBottomFilter", TOP_BOTTOM_FILTER_FIELD);
        map.put("NestedFilter", NESTED_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * A <code>CategoryFilter</code> filters text values.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text
         * filters</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param categoryFilter
         *        A <code>CategoryFilter</code> filters text values.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text
         *        filters</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryFilter(CategoryFilter categoryFilter);

        /**
         * <p>
         * A <code>CategoryFilter</code> filters text values.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text
         * filters</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoryFilter.Builder} avoiding the need
         * to create one manually via {@link CategoryFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoryFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryFilter(CategoryFilter)}.
         * 
         * @param categoryFilter
         *        a consumer that will call methods on {@link CategoryFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryFilter(CategoryFilter)
         */
        default Builder categoryFilter(Consumer<CategoryFilter.Builder> categoryFilter) {
            return categoryFilter(CategoryFilter.builder().applyMutation(categoryFilter).build());
        }

        /**
         * <p>
         * A <code>NumericRangeFilter</code> filters numeric values that are either inside or outside a given numeric
         * range.
         * </p>
         * 
         * @param numericRangeFilter
         *        A <code>NumericRangeFilter</code> filters numeric values that are either inside or outside a given
         *        numeric range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericRangeFilter(NumericRangeFilter numericRangeFilter);

        /**
         * <p>
         * A <code>NumericRangeFilter</code> filters numeric values that are either inside or outside a given numeric
         * range.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericRangeFilter.Builder} avoiding the
         * need to create one manually via {@link NumericRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericRangeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #numericRangeFilter(NumericRangeFilter)}.
         * 
         * @param numericRangeFilter
         *        a consumer that will call methods on {@link NumericRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericRangeFilter(NumericRangeFilter)
         */
        default Builder numericRangeFilter(Consumer<NumericRangeFilter.Builder> numericRangeFilter) {
            return numericRangeFilter(NumericRangeFilter.builder().applyMutation(numericRangeFilter).build());
        }

        /**
         * <p>
         * A <code>NumericEqualityFilter</code> filters numeric values that equal or do not equal a given numeric value.
         * </p>
         * 
         * @param numericEqualityFilter
         *        A <code>NumericEqualityFilter</code> filters numeric values that equal or do not equal a given numeric
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericEqualityFilter(NumericEqualityFilter numericEqualityFilter);

        /**
         * <p>
         * A <code>NumericEqualityFilter</code> filters numeric values that equal or do not equal a given numeric value.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericEqualityFilter.Builder} avoiding
         * the need to create one manually via {@link NumericEqualityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericEqualityFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #numericEqualityFilter(NumericEqualityFilter)}.
         * 
         * @param numericEqualityFilter
         *        a consumer that will call methods on {@link NumericEqualityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericEqualityFilter(NumericEqualityFilter)
         */
        default Builder numericEqualityFilter(Consumer<NumericEqualityFilter.Builder> numericEqualityFilter) {
            return numericEqualityFilter(NumericEqualityFilter.builder().applyMutation(numericEqualityFilter).build());
        }

        /**
         * <p>
         * A <code>TimeEqualityFilter</code> filters date-time values that equal or do not equal a given date/time
         * value.
         * </p>
         * 
         * @param timeEqualityFilter
         *        A <code>TimeEqualityFilter</code> filters date-time values that equal or do not equal a given
         *        date/time value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeEqualityFilter(TimeEqualityFilter timeEqualityFilter);

        /**
         * <p>
         * A <code>TimeEqualityFilter</code> filters date-time values that equal or do not equal a given date/time
         * value.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeEqualityFilter.Builder} avoiding the
         * need to create one manually via {@link TimeEqualityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeEqualityFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #timeEqualityFilter(TimeEqualityFilter)}.
         * 
         * @param timeEqualityFilter
         *        a consumer that will call methods on {@link TimeEqualityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeEqualityFilter(TimeEqualityFilter)
         */
        default Builder timeEqualityFilter(Consumer<TimeEqualityFilter.Builder> timeEqualityFilter) {
            return timeEqualityFilter(TimeEqualityFilter.builder().applyMutation(timeEqualityFilter).build());
        }

        /**
         * <p>
         * A <code>TimeRangeFilter</code> filters date-time values that are either inside or outside a given date/time
         * range.
         * </p>
         * 
         * @param timeRangeFilter
         *        A <code>TimeRangeFilter</code> filters date-time values that are either inside or outside a given
         *        date/time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeFilter(TimeRangeFilter timeRangeFilter);

        /**
         * <p>
         * A <code>TimeRangeFilter</code> filters date-time values that are either inside or outside a given date/time
         * range.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRangeFilter.Builder} avoiding the
         * need to create one manually via {@link TimeRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #timeRangeFilter(TimeRangeFilter)}.
         * 
         * @param timeRangeFilter
         *        a consumer that will call methods on {@link TimeRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRangeFilter(TimeRangeFilter)
         */
        default Builder timeRangeFilter(Consumer<TimeRangeFilter.Builder> timeRangeFilter) {
            return timeRangeFilter(TimeRangeFilter.builder().applyMutation(timeRangeFilter).build());
        }

        /**
         * <p>
         * A <code>RelativeDatesFilter</code> filters date values that are relative to a given date.
         * </p>
         * 
         * @param relativeDatesFilter
         *        A <code>RelativeDatesFilter</code> filters date values that are relative to a given date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeDatesFilter(RelativeDatesFilter relativeDatesFilter);

        /**
         * <p>
         * A <code>RelativeDatesFilter</code> filters date values that are relative to a given date.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelativeDatesFilter.Builder} avoiding the
         * need to create one manually via {@link RelativeDatesFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelativeDatesFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #relativeDatesFilter(RelativeDatesFilter)}.
         * 
         * @param relativeDatesFilter
         *        a consumer that will call methods on {@link RelativeDatesFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeDatesFilter(RelativeDatesFilter)
         */
        default Builder relativeDatesFilter(Consumer<RelativeDatesFilter.Builder> relativeDatesFilter) {
            return relativeDatesFilter(RelativeDatesFilter.builder().applyMutation(relativeDatesFilter).build());
        }

        /**
         * <p>
         * A <code>TopBottomFilter</code> filters data to the top or bottom values for a given column.
         * </p>
         * 
         * @param topBottomFilter
         *        A <code>TopBottomFilter</code> filters data to the top or bottom values for a given column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topBottomFilter(TopBottomFilter topBottomFilter);

        /**
         * <p>
         * A <code>TopBottomFilter</code> filters data to the top or bottom values for a given column.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopBottomFilter.Builder} avoiding the
         * need to create one manually via {@link TopBottomFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopBottomFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #topBottomFilter(TopBottomFilter)}.
         * 
         * @param topBottomFilter
         *        a consumer that will call methods on {@link TopBottomFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topBottomFilter(TopBottomFilter)
         */
        default Builder topBottomFilter(Consumer<TopBottomFilter.Builder> topBottomFilter) {
            return topBottomFilter(TopBottomFilter.builder().applyMutation(topBottomFilter).build());
        }

        /**
         * <p>
         * A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner filter.
         * </p>
         * 
         * @param nestedFilter
         *        A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner
         *        filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedFilter(NestedFilter nestedFilter);

        /**
         * <p>
         * A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link NestedFilter.Builder} avoiding the need
         * to create one manually via {@link NestedFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NestedFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #nestedFilter(NestedFilter)}.
         * 
         * @param nestedFilter
         *        a consumer that will call methods on {@link NestedFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nestedFilter(NestedFilter)
         */
        default Builder nestedFilter(Consumer<NestedFilter.Builder> nestedFilter) {
            return nestedFilter(NestedFilter.builder().applyMutation(nestedFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CategoryFilter categoryFilter;

        private NumericRangeFilter numericRangeFilter;

        private NumericEqualityFilter numericEqualityFilter;

        private TimeEqualityFilter timeEqualityFilter;

        private TimeRangeFilter timeRangeFilter;

        private RelativeDatesFilter relativeDatesFilter;

        private TopBottomFilter topBottomFilter;

        private NestedFilter nestedFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            categoryFilter(model.categoryFilter);
            numericRangeFilter(model.numericRangeFilter);
            numericEqualityFilter(model.numericEqualityFilter);
            timeEqualityFilter(model.timeEqualityFilter);
            timeRangeFilter(model.timeRangeFilter);
            relativeDatesFilter(model.relativeDatesFilter);
            topBottomFilter(model.topBottomFilter);
            nestedFilter(model.nestedFilter);
        }

        public final CategoryFilter.Builder getCategoryFilter() {
            return categoryFilter != null ? categoryFilter.toBuilder() : null;
        }

        public final void setCategoryFilter(CategoryFilter.BuilderImpl categoryFilter) {
            this.categoryFilter = categoryFilter != null ? categoryFilter.build() : null;
        }

        @Override
        public final Builder categoryFilter(CategoryFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
            return this;
        }

        public final NumericRangeFilter.Builder getNumericRangeFilter() {
            return numericRangeFilter != null ? numericRangeFilter.toBuilder() : null;
        }

        public final void setNumericRangeFilter(NumericRangeFilter.BuilderImpl numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter != null ? numericRangeFilter.build() : null;
        }

        @Override
        public final Builder numericRangeFilter(NumericRangeFilter numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter;
            return this;
        }

        public final NumericEqualityFilter.Builder getNumericEqualityFilter() {
            return numericEqualityFilter != null ? numericEqualityFilter.toBuilder() : null;
        }

        public final void setNumericEqualityFilter(NumericEqualityFilter.BuilderImpl numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter != null ? numericEqualityFilter.build() : null;
        }

        @Override
        public final Builder numericEqualityFilter(NumericEqualityFilter numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter;
            return this;
        }

        public final TimeEqualityFilter.Builder getTimeEqualityFilter() {
            return timeEqualityFilter != null ? timeEqualityFilter.toBuilder() : null;
        }

        public final void setTimeEqualityFilter(TimeEqualityFilter.BuilderImpl timeEqualityFilter) {
            this.timeEqualityFilter = timeEqualityFilter != null ? timeEqualityFilter.build() : null;
        }

        @Override
        public final Builder timeEqualityFilter(TimeEqualityFilter timeEqualityFilter) {
            this.timeEqualityFilter = timeEqualityFilter;
            return this;
        }

        public final TimeRangeFilter.Builder getTimeRangeFilter() {
            return timeRangeFilter != null ? timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilter.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilter timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public final RelativeDatesFilter.Builder getRelativeDatesFilter() {
            return relativeDatesFilter != null ? relativeDatesFilter.toBuilder() : null;
        }

        public final void setRelativeDatesFilter(RelativeDatesFilter.BuilderImpl relativeDatesFilter) {
            this.relativeDatesFilter = relativeDatesFilter != null ? relativeDatesFilter.build() : null;
        }

        @Override
        public final Builder relativeDatesFilter(RelativeDatesFilter relativeDatesFilter) {
            this.relativeDatesFilter = relativeDatesFilter;
            return this;
        }

        public final TopBottomFilter.Builder getTopBottomFilter() {
            return topBottomFilter != null ? topBottomFilter.toBuilder() : null;
        }

        public final void setTopBottomFilter(TopBottomFilter.BuilderImpl topBottomFilter) {
            this.topBottomFilter = topBottomFilter != null ? topBottomFilter.build() : null;
        }

        @Override
        public final Builder topBottomFilter(TopBottomFilter topBottomFilter) {
            this.topBottomFilter = topBottomFilter;
            return this;
        }

        public final NestedFilter.Builder getNestedFilter() {
            return nestedFilter != null ? nestedFilter.toBuilder() : null;
        }

        public final void setNestedFilter(NestedFilter.BuilderImpl nestedFilter) {
            this.nestedFilter = nestedFilter != null ? nestedFilter.build() : null;
        }

        @Override
        public final Builder nestedFilter(NestedFilter nestedFilter) {
            this.nestedFilter = nestedFilter;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
