/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label options of the label that is displayed in the center of a donut chart. This option isn't available for pie
 * charts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DonutCenterOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DonutCenterOptions.Builder, DonutCenterOptions> {
    private static final SdkField<String> LABEL_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelVisibility").getter(getter(DonutCenterOptions::labelVisibilityAsString))
            .setter(setter(Builder::labelVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelVisibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String labelVisibility;

    private DonutCenterOptions(BuilderImpl builder) {
        this.labelVisibility = builder.labelVisibility;
    }

    /**
     * <p>
     * Determines the visibility of the label in a donut chart. In the QuickSight console, this option is called
     * <code>'Show total'</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the label in a donut chart. In the QuickSight console, this option is called
     *         <code>'Show total'</code>.
     * @see Visibility
     */
    public final Visibility labelVisibility() {
        return Visibility.fromValue(labelVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the label in a donut chart. In the QuickSight console, this option is called
     * <code>'Show total'</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the label in a donut chart. In the QuickSight console, this option is called
     *         <code>'Show total'</code>.
     * @see Visibility
     */
    public final String labelVisibilityAsString() {
        return labelVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DonutCenterOptions)) {
            return false;
        }
        DonutCenterOptions other = (DonutCenterOptions) obj;
        return Objects.equals(labelVisibilityAsString(), other.labelVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DonutCenterOptions").add("LabelVisibility", labelVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelVisibility":
            return Optional.ofNullable(clazz.cast(labelVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelVisibility", LABEL_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DonutCenterOptions, T> g) {
        return obj -> g.apply((DonutCenterOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DonutCenterOptions> {
        /**
         * <p>
         * Determines the visibility of the label in a donut chart. In the QuickSight console, this option is called
         * <code>'Show total'</code>.
         * </p>
         * 
         * @param labelVisibility
         *        Determines the visibility of the label in a donut chart. In the QuickSight console, this option is
         *        called <code>'Show total'</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder labelVisibility(String labelVisibility);

        /**
         * <p>
         * Determines the visibility of the label in a donut chart. In the QuickSight console, this option is called
         * <code>'Show total'</code>.
         * </p>
         * 
         * @param labelVisibility
         *        Determines the visibility of the label in a donut chart. In the QuickSight console, this option is
         *        called <code>'Show total'</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder labelVisibility(Visibility labelVisibility);
    }

    static final class BuilderImpl implements Builder {
        private String labelVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(DonutCenterOptions model) {
            labelVisibility(model.labelVisibility);
        }

        public final String getLabelVisibility() {
            return labelVisibility;
        }

        public final void setLabelVisibility(String labelVisibility) {
            this.labelVisibility = labelVisibility;
        }

        @Override
        public final Builder labelVisibility(String labelVisibility) {
            this.labelVisibility = labelVisibility;
            return this;
        }

        @Override
        public final Builder labelVisibility(Visibility labelVisibility) {
            this.labelVisibility(labelVisibility == null ? null : labelVisibility.toString());
            return this;
        }

        @Override
        public DonutCenterOptions build() {
            return new DonutCenterOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
