/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnalysisResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateAnalysisResponse.Builder, CreateAnalysisResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateAnalysisResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(CreateAnalysisResponse::analysisId)).setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationStatus").getter(getter(CreateAnalysisResponse::creationStatusAsString))
            .setter(setter(Builder::creationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateAnalysisResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateAnalysisResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ANALYSIS_ID_FIELD,
            CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String analysisId;

    private final String creationStatus;

    private final Integer status;

    private final String requestId;

    private CreateAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.analysisId = builder.analysisId;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ARN for the analysis.
     * </p>
     * 
     * @return The ARN for the analysis.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the analysis.
     * </p>
     * 
     * @return The ID of the analysis.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The status of the creation of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The status of the creation of the analysis.
     * @see ResourceStatus
     */
    public final ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(creationStatus);
    }

    /**
     * <p>
     * The status of the creation of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The status of the creation of the analysis.
     * @see ResourceStatus
     */
    public final String creationStatusAsString() {
        return creationStatus;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisResponse)) {
            return false;
        }
        CreateAnalysisResponse other = (CreateAnalysisResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(analysisId(), other.analysisId())
                && Objects.equals(creationStatusAsString(), other.creationStatusAsString())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnalysisResponse").add("Arn", arn()).add("AnalysisId", analysisId())
                .add("CreationStatus", creationStatusAsString()).add("Status", status()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "CreationStatus":
            return Optional.ofNullable(clazz.cast(creationStatusAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("CreationStatus", CREATION_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalysisResponse, T> g) {
        return obj -> g.apply((CreateAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnalysisResponse> {
        /**
         * <p>
         * The ARN for the analysis.
         * </p>
         * 
         * @param arn
         *        The ARN for the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the analysis.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The status of the creation of the analysis.
         * </p>
         * 
         * @param creationStatus
         *        The status of the creation of the analysis.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(String creationStatus);

        /**
         * <p>
         * The status of the creation of the analysis.
         * </p>
         * 
         * @param creationStatus
         *        The status of the creation of the analysis.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(ResourceStatus creationStatus);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String analysisId;

        private String creationStatus;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalysisResponse model) {
            super(model);
            arn(model.arn);
            analysisId(model.analysisId);
            creationStatus(model.creationStatus);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getCreationStatus() {
            return creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public CreateAnalysisResponse build() {
            return new CreateAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
