/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source controls that are used in a <code>CascadingControlConfiguration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CascadingControlSource implements SdkPojo, Serializable,
        ToCopyableBuilder<CascadingControlSource.Builder, CascadingControlSource> {
    private static final SdkField<String> SOURCE_SHEET_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceSheetControlId").getter(getter(CascadingControlSource::sourceSheetControlId))
            .setter(setter(Builder::sourceSheetControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSheetControlId").build())
            .build();

    private static final SdkField<ColumnIdentifier> COLUMN_TO_MATCH_FIELD = SdkField
            .<ColumnIdentifier> builder(MarshallingType.SDK_POJO).memberName("ColumnToMatch")
            .getter(getter(CascadingControlSource::columnToMatch)).setter(setter(Builder::columnToMatch))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnToMatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SHEET_CONTROL_ID_FIELD,
            COLUMN_TO_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceSheetControlId;

    private final ColumnIdentifier columnToMatch;

    private CascadingControlSource(BuilderImpl builder) {
        this.sourceSheetControlId = builder.sourceSheetControlId;
        this.columnToMatch = builder.columnToMatch;
    }

    /**
     * <p>
     * The source sheet control ID of a <code>CascadingControlSource</code>.
     * </p>
     * 
     * @return The source sheet control ID of a <code>CascadingControlSource</code>.
     */
    public final String sourceSheetControlId() {
        return sourceSheetControlId;
    }

    /**
     * <p>
     * The column identifier that determines which column to look up for the source sheet control.
     * </p>
     * 
     * @return The column identifier that determines which column to look up for the source sheet control.
     */
    public final ColumnIdentifier columnToMatch() {
        return columnToMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceSheetControlId());
        hashCode = 31 * hashCode + Objects.hashCode(columnToMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CascadingControlSource)) {
            return false;
        }
        CascadingControlSource other = (CascadingControlSource) obj;
        return Objects.equals(sourceSheetControlId(), other.sourceSheetControlId())
                && Objects.equals(columnToMatch(), other.columnToMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CascadingControlSource").add("SourceSheetControlId", sourceSheetControlId())
                .add("ColumnToMatch", columnToMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceSheetControlId":
            return Optional.ofNullable(clazz.cast(sourceSheetControlId()));
        case "ColumnToMatch":
            return Optional.ofNullable(clazz.cast(columnToMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceSheetControlId", SOURCE_SHEET_CONTROL_ID_FIELD);
        map.put("ColumnToMatch", COLUMN_TO_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CascadingControlSource, T> g) {
        return obj -> g.apply((CascadingControlSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CascadingControlSource> {
        /**
         * <p>
         * The source sheet control ID of a <code>CascadingControlSource</code>.
         * </p>
         * 
         * @param sourceSheetControlId
         *        The source sheet control ID of a <code>CascadingControlSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSheetControlId(String sourceSheetControlId);

        /**
         * <p>
         * The column identifier that determines which column to look up for the source sheet control.
         * </p>
         * 
         * @param columnToMatch
         *        The column identifier that determines which column to look up for the source sheet control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnToMatch(ColumnIdentifier columnToMatch);

        /**
         * <p>
         * The column identifier that determines which column to look up for the source sheet control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #columnToMatch(ColumnIdentifier)}.
         * 
         * @param columnToMatch
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnToMatch(ColumnIdentifier)
         */
        default Builder columnToMatch(Consumer<ColumnIdentifier.Builder> columnToMatch) {
            return columnToMatch(ColumnIdentifier.builder().applyMutation(columnToMatch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceSheetControlId;

        private ColumnIdentifier columnToMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CascadingControlSource model) {
            sourceSheetControlId(model.sourceSheetControlId);
            columnToMatch(model.columnToMatch);
        }

        public final String getSourceSheetControlId() {
            return sourceSheetControlId;
        }

        public final void setSourceSheetControlId(String sourceSheetControlId) {
            this.sourceSheetControlId = sourceSheetControlId;
        }

        @Override
        public final Builder sourceSheetControlId(String sourceSheetControlId) {
            this.sourceSheetControlId = sourceSheetControlId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumnToMatch() {
            return columnToMatch != null ? columnToMatch.toBuilder() : null;
        }

        public final void setColumnToMatch(ColumnIdentifier.BuilderImpl columnToMatch) {
            this.columnToMatch = columnToMatch != null ? columnToMatch.build() : null;
        }

        @Override
        public final Builder columnToMatch(ColumnIdentifier columnToMatch) {
            this.columnToMatch = columnToMatch;
            return this;
        }

        @Override
        public CascadingControlSource build() {
            return new CascadingControlSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
