/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of an Agg function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggFunction implements SdkPojo, Serializable, ToCopyableBuilder<AggFunction.Builder, AggFunction> {
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(AggFunction::aggregationAsString)).setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final SdkField<Map<String, String>> AGGREGATION_FUNCTION_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AggregationFunctionParameters")
            .getter(getter(AggFunction::aggregationFunctionParameters))
            .setter(setter(Builder::aggregationFunctionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunctionParameters")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Period")
            .getter(getter(AggFunction::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> PERIOD_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeriodField").getter(getter(AggFunction::periodField)).setter(setter(Builder::periodField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FIELD,
            AGGREGATION_FUNCTION_PARAMETERS_FIELD, PERIOD_FIELD, PERIOD_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aggregation;

    private final Map<String, String> aggregationFunctionParameters;

    private final String period;

    private final String periodField;

    private AggFunction(BuilderImpl builder) {
        this.aggregation = builder.aggregation;
        this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
        this.period = builder.period;
        this.periodField = builder.periodField;
    }

    /**
     * <p>
     * The aggregation of an Agg function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link AggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The aggregation of an Agg function.
     * @see AggType
     */
    public final AggType aggregation() {
        return AggType.fromValue(aggregation);
    }

    /**
     * <p>
     * The aggregation of an Agg function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link AggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The aggregation of an Agg function.
     * @see AggType
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregationFunctionParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregationFunctionParameters() {
        return aggregationFunctionParameters != null && !(aggregationFunctionParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The aggregation parameters for an Agg function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregationFunctionParameters} method.
     * </p>
     * 
     * @return The aggregation parameters for an Agg function.
     */
    public final Map<String, String> aggregationFunctionParameters() {
        return aggregationFunctionParameters;
    }

    /**
     * <p>
     * The period of an Agg function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAsString}.
     * </p>
     * 
     * @return The period of an Agg function.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity period() {
        return TopicTimeGranularity.fromValue(period);
    }

    /**
     * <p>
     * The period of an Agg function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAsString}.
     * </p>
     * 
     * @return The period of an Agg function.
     * @see TopicTimeGranularity
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The period field for an Agg function.
     * </p>
     * 
     * @return The period field for an Agg function.
     */
    public final String periodField() {
        return periodField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregationFunctionParameters() ? aggregationFunctionParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggFunction)) {
            return false;
        }
        AggFunction other = (AggFunction) obj;
        return Objects.equals(aggregationAsString(), other.aggregationAsString())
                && hasAggregationFunctionParameters() == other.hasAggregationFunctionParameters()
                && Objects.equals(aggregationFunctionParameters(), other.aggregationFunctionParameters())
                && Objects.equals(periodAsString(), other.periodAsString()) && Objects.equals(periodField(), other.periodField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AggFunction")
                .add("Aggregation", aggregationAsString())
                .add("AggregationFunctionParameters", hasAggregationFunctionParameters() ? aggregationFunctionParameters() : null)
                .add("Period", periodAsString()).add("PeriodField", periodField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "AggregationFunctionParameters":
            return Optional.ofNullable(clazz.cast(aggregationFunctionParameters()));
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "PeriodField":
            return Optional.ofNullable(clazz.cast(periodField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Aggregation", AGGREGATION_FIELD);
        map.put("AggregationFunctionParameters", AGGREGATION_FUNCTION_PARAMETERS_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("PeriodField", PERIOD_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggFunction, T> g) {
        return obj -> g.apply((AggFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggFunction> {
        /**
         * <p>
         * The aggregation of an Agg function.
         * </p>
         * 
         * @param aggregation
         *        The aggregation of an Agg function.
         * @see AggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggType
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * The aggregation of an Agg function.
         * </p>
         * 
         * @param aggregation
         *        The aggregation of an Agg function.
         * @see AggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggType
         */
        Builder aggregation(AggType aggregation);

        /**
         * <p>
         * The aggregation parameters for an Agg function.
         * </p>
         * 
         * @param aggregationFunctionParameters
         *        The aggregation parameters for an Agg function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters);

        /**
         * <p>
         * The period of an Agg function.
         * </p>
         * 
         * @param period
         *        The period of an Agg function.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder period(String period);

        /**
         * <p>
         * The period of an Agg function.
         * </p>
         * 
         * @param period
         *        The period of an Agg function.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder period(TopicTimeGranularity period);

        /**
         * <p>
         * The period field for an Agg function.
         * </p>
         * 
         * @param periodField
         *        The period field for an Agg function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodField(String periodField);
    }

    static final class BuilderImpl implements Builder {
        private String aggregation;

        private Map<String, String> aggregationFunctionParameters = DefaultSdkAutoConstructMap.getInstance();

        private String period;

        private String periodField;

        private BuilderImpl() {
        }

        private BuilderImpl(AggFunction model) {
            aggregation(model.aggregation);
            aggregationFunctionParameters(model.aggregationFunctionParameters);
            period(model.period);
            periodField(model.periodField);
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(AggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Map<String, String> getAggregationFunctionParameters() {
            if (aggregationFunctionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return aggregationFunctionParameters;
        }

        public final void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
        }

        @Override
        public final Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(TopicTimeGranularity period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getPeriodField() {
            return periodField;
        }

        public final void setPeriodField(String periodField) {
            this.periodField = periodField;
        }

        @Override
        public final Builder periodField(String periodField) {
            this.periodField = periodField;
            return this;
        }

        @Override
        public AggFunction build() {
            return new AggFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
