/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The static file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticFile implements SdkPojo, Serializable, ToCopyableBuilder<StaticFile.Builder, StaticFile> {
    private static final SdkField<ImageStaticFile> IMAGE_STATIC_FILE_FIELD = SdkField
            .<ImageStaticFile> builder(MarshallingType.SDK_POJO).memberName("ImageStaticFile")
            .getter(getter(StaticFile::imageStaticFile)).setter(setter(Builder::imageStaticFile))
            .constructor(ImageStaticFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageStaticFile").build()).build();

    private static final SdkField<SpatialStaticFile> SPATIAL_STATIC_FILE_FIELD = SdkField
            .<SpatialStaticFile> builder(MarshallingType.SDK_POJO).memberName("SpatialStaticFile")
            .getter(getter(StaticFile::spatialStaticFile)).setter(setter(Builder::spatialStaticFile))
            .constructor(SpatialStaticFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpatialStaticFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_STATIC_FILE_FIELD,
            SPATIAL_STATIC_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageStaticFile imageStaticFile;

    private final SpatialStaticFile spatialStaticFile;

    private StaticFile(BuilderImpl builder) {
        this.imageStaticFile = builder.imageStaticFile;
        this.spatialStaticFile = builder.spatialStaticFile;
    }

    /**
     * <p>
     * The image static file.
     * </p>
     * 
     * @return The image static file.
     */
    public final ImageStaticFile imageStaticFile() {
        return imageStaticFile;
    }

    /**
     * <p>
     * The spacial static file.
     * </p>
     * 
     * @return The spacial static file.
     */
    public final SpatialStaticFile spatialStaticFile() {
        return spatialStaticFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageStaticFile());
        hashCode = 31 * hashCode + Objects.hashCode(spatialStaticFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticFile)) {
            return false;
        }
        StaticFile other = (StaticFile) obj;
        return Objects.equals(imageStaticFile(), other.imageStaticFile())
                && Objects.equals(spatialStaticFile(), other.spatialStaticFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticFile").add("ImageStaticFile", imageStaticFile())
                .add("SpatialStaticFile", spatialStaticFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageStaticFile":
            return Optional.ofNullable(clazz.cast(imageStaticFile()));
        case "SpatialStaticFile":
            return Optional.ofNullable(clazz.cast(spatialStaticFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageStaticFile", IMAGE_STATIC_FILE_FIELD);
        map.put("SpatialStaticFile", SPATIAL_STATIC_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticFile, T> g) {
        return obj -> g.apply((StaticFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticFile> {
        /**
         * <p>
         * The image static file.
         * </p>
         * 
         * @param imageStaticFile
         *        The image static file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageStaticFile(ImageStaticFile imageStaticFile);

        /**
         * <p>
         * The image static file.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageStaticFile.Builder} avoiding the
         * need to create one manually via {@link ImageStaticFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageStaticFile.Builder#build()} is called immediately and its
         * result is passed to {@link #imageStaticFile(ImageStaticFile)}.
         * 
         * @param imageStaticFile
         *        a consumer that will call methods on {@link ImageStaticFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageStaticFile(ImageStaticFile)
         */
        default Builder imageStaticFile(Consumer<ImageStaticFile.Builder> imageStaticFile) {
            return imageStaticFile(ImageStaticFile.builder().applyMutation(imageStaticFile).build());
        }

        /**
         * <p>
         * The spacial static file.
         * </p>
         * 
         * @param spatialStaticFile
         *        The spacial static file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spatialStaticFile(SpatialStaticFile spatialStaticFile);

        /**
         * <p>
         * The spacial static file.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpatialStaticFile.Builder} avoiding the
         * need to create one manually via {@link SpatialStaticFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpatialStaticFile.Builder#build()} is called immediately and its
         * result is passed to {@link #spatialStaticFile(SpatialStaticFile)}.
         * 
         * @param spatialStaticFile
         *        a consumer that will call methods on {@link SpatialStaticFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spatialStaticFile(SpatialStaticFile)
         */
        default Builder spatialStaticFile(Consumer<SpatialStaticFile.Builder> spatialStaticFile) {
            return spatialStaticFile(SpatialStaticFile.builder().applyMutation(spatialStaticFile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageStaticFile imageStaticFile;

        private SpatialStaticFile spatialStaticFile;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticFile model) {
            imageStaticFile(model.imageStaticFile);
            spatialStaticFile(model.spatialStaticFile);
        }

        public final ImageStaticFile.Builder getImageStaticFile() {
            return imageStaticFile != null ? imageStaticFile.toBuilder() : null;
        }

        public final void setImageStaticFile(ImageStaticFile.BuilderImpl imageStaticFile) {
            this.imageStaticFile = imageStaticFile != null ? imageStaticFile.build() : null;
        }

        @Override
        public final Builder imageStaticFile(ImageStaticFile imageStaticFile) {
            this.imageStaticFile = imageStaticFile;
            return this;
        }

        public final SpatialStaticFile.Builder getSpatialStaticFile() {
            return spatialStaticFile != null ? spatialStaticFile.toBuilder() : null;
        }

        public final void setSpatialStaticFile(SpatialStaticFile.BuilderImpl spatialStaticFile) {
            this.spatialStaticFile = spatialStaticFile != null ? spatialStaticFile.build() : null;
        }

        @Override
        public final Builder spatialStaticFile(SpatialStaticFile spatialStaticFile) {
            this.spatialStaticFile = spatialStaticFile;
            return this;
        }

        @Override
        public StaticFile build() {
            return new StaticFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
