/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>SignupResponse</code> object that contains a summary of a newly created account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignupResponse implements SdkPojo, Serializable, ToCopyableBuilder<SignupResponse.Builder, SignupResponse> {
    private static final SdkField<Boolean> IAM_USER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IAMUser").getter(getter(SignupResponse::iamUser)).setter(setter(Builder::iamUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMUser").build()).build();

    private static final SdkField<String> USER_LOGIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userLoginName").getter(getter(SignupResponse::userLoginName)).setter(setter(Builder::userLoginName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userLoginName").build()).build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountName").getter(getter(SignupResponse::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()).build();

    private static final SdkField<String> DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directoryType").getter(getter(SignupResponse::directoryType)).setter(setter(Builder::directoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_FIELD,
            USER_LOGIN_NAME_FIELD, ACCOUNT_NAME_FIELD, DIRECTORY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean iamUser;

    private final String userLoginName;

    private final String accountName;

    private final String directoryType;

    private SignupResponse(BuilderImpl builder) {
        this.iamUser = builder.iamUser;
        this.userLoginName = builder.userLoginName;
        this.accountName = builder.accountName;
        this.directoryType = builder.directoryType;
    }

    /**
     * <p>
     * A Boolean that is <code>TRUE</code> if the QuickSight uses IAM as an authentication method.
     * </p>
     * 
     * @return A Boolean that is <code>TRUE</code> if the QuickSight uses IAM as an authentication method.
     */
    public final Boolean iamUser() {
        return iamUser;
    }

    /**
     * <p>
     * The user login name for your QuickSight account.
     * </p>
     * 
     * @return The user login name for your QuickSight account.
     */
    public final String userLoginName() {
        return userLoginName;
    }

    /**
     * <p>
     * The name of your QuickSight account.
     * </p>
     * 
     * @return The name of your QuickSight account.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The type of Active Directory that is being used to authenticate the QuickSight account. Valid values are
     * <code>SIMPLE_AD</code>, <code>AD_CONNECTOR</code>, and <code>MICROSOFT_AD</code>.
     * </p>
     * 
     * @return The type of Active Directory that is being used to authenticate the QuickSight account. Valid values are
     *         <code>SIMPLE_AD</code>, <code>AD_CONNECTOR</code>, and <code>MICROSOFT_AD</code>.
     */
    public final String directoryType() {
        return directoryType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamUser());
        hashCode = 31 * hashCode + Objects.hashCode(userLoginName());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(directoryType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignupResponse)) {
            return false;
        }
        SignupResponse other = (SignupResponse) obj;
        return Objects.equals(iamUser(), other.iamUser()) && Objects.equals(userLoginName(), other.userLoginName())
                && Objects.equals(accountName(), other.accountName()) && Objects.equals(directoryType(), other.directoryType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignupResponse").add("IAMUser", iamUser()).add("UserLoginName", userLoginName())
                .add("AccountName", accountName()).add("DirectoryType", directoryType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IAMUser":
            return Optional.ofNullable(clazz.cast(iamUser()));
        case "userLoginName":
            return Optional.ofNullable(clazz.cast(userLoginName()));
        case "accountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "directoryType":
            return Optional.ofNullable(clazz.cast(directoryType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IAMUser", IAM_USER_FIELD);
        map.put("userLoginName", USER_LOGIN_NAME_FIELD);
        map.put("accountName", ACCOUNT_NAME_FIELD);
        map.put("directoryType", DIRECTORY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignupResponse, T> g) {
        return obj -> g.apply((SignupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignupResponse> {
        /**
         * <p>
         * A Boolean that is <code>TRUE</code> if the QuickSight uses IAM as an authentication method.
         * </p>
         * 
         * @param iamUser
         *        A Boolean that is <code>TRUE</code> if the QuickSight uses IAM as an authentication method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUser(Boolean iamUser);

        /**
         * <p>
         * The user login name for your QuickSight account.
         * </p>
         * 
         * @param userLoginName
         *        The user login name for your QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userLoginName(String userLoginName);

        /**
         * <p>
         * The name of your QuickSight account.
         * </p>
         * 
         * @param accountName
         *        The name of your QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The type of Active Directory that is being used to authenticate the QuickSight account. Valid values are
         * <code>SIMPLE_AD</code>, <code>AD_CONNECTOR</code>, and <code>MICROSOFT_AD</code>.
         * </p>
         * 
         * @param directoryType
         *        The type of Active Directory that is being used to authenticate the QuickSight account. Valid values
         *        are <code>SIMPLE_AD</code>, <code>AD_CONNECTOR</code>, and <code>MICROSOFT_AD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryType(String directoryType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean iamUser;

        private String userLoginName;

        private String accountName;

        private String directoryType;

        private BuilderImpl() {
        }

        private BuilderImpl(SignupResponse model) {
            iamUser(model.iamUser);
            userLoginName(model.userLoginName);
            accountName(model.accountName);
            directoryType(model.directoryType);
        }

        public final Boolean getIamUser() {
            return iamUser;
        }

        public final void setIamUser(Boolean iamUser) {
            this.iamUser = iamUser;
        }

        @Override
        public final Builder iamUser(Boolean iamUser) {
            this.iamUser = iamUser;
            return this;
        }

        public final String getUserLoginName() {
            return userLoginName;
        }

        public final void setUserLoginName(String userLoginName) {
            this.userLoginName = userLoginName;
        }

        @Override
        public final Builder userLoginName(String userLoginName) {
            this.userLoginName = userLoginName;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getDirectoryType() {
            return directoryType;
        }

        public final void setDirectoryType(String directoryType) {
            this.directoryType = directoryType;
        }

        @Override
        public final Builder directoryType(String directoryType) {
            this.directoryType = directoryType;
            return this;
        }

        @Override
        public SignupResponse build() {
            return new SignupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
