/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The heatmap configuration of the geospatial point style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialHeatmapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialHeatmapConfiguration.Builder, GeospatialHeatmapConfiguration> {
    private static final SdkField<GeospatialHeatmapColorScale> HEATMAP_COLOR_FIELD = SdkField
            .<GeospatialHeatmapColorScale> builder(MarshallingType.SDK_POJO).memberName("HeatmapColor")
            .getter(getter(GeospatialHeatmapConfiguration::heatmapColor)).setter(setter(Builder::heatmapColor))
            .constructor(GeospatialHeatmapColorScale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatmapColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEATMAP_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialHeatmapColorScale heatmapColor;

    private GeospatialHeatmapConfiguration(BuilderImpl builder) {
        this.heatmapColor = builder.heatmapColor;
    }

    /**
     * <p>
     * The color scale specification for the heatmap point style.
     * </p>
     * 
     * @return The color scale specification for the heatmap point style.
     */
    public final GeospatialHeatmapColorScale heatmapColor() {
        return heatmapColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(heatmapColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialHeatmapConfiguration)) {
            return false;
        }
        GeospatialHeatmapConfiguration other = (GeospatialHeatmapConfiguration) obj;
        return Objects.equals(heatmapColor(), other.heatmapColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialHeatmapConfiguration").add("HeatmapColor", heatmapColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeatmapColor":
            return Optional.ofNullable(clazz.cast(heatmapColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HeatmapColor", HEATMAP_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialHeatmapConfiguration, T> g) {
        return obj -> g.apply((GeospatialHeatmapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialHeatmapConfiguration> {
        /**
         * <p>
         * The color scale specification for the heatmap point style.
         * </p>
         * 
         * @param heatmapColor
         *        The color scale specification for the heatmap point style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatmapColor(GeospatialHeatmapColorScale heatmapColor);

        /**
         * <p>
         * The color scale specification for the heatmap point style.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialHeatmapColorScale.Builder}
         * avoiding the need to create one manually via {@link GeospatialHeatmapColorScale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialHeatmapColorScale.Builder#build()} is called
         * immediately and its result is passed to {@link #heatmapColor(GeospatialHeatmapColorScale)}.
         * 
         * @param heatmapColor
         *        a consumer that will call methods on {@link GeospatialHeatmapColorScale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatmapColor(GeospatialHeatmapColorScale)
         */
        default Builder heatmapColor(Consumer<GeospatialHeatmapColorScale.Builder> heatmapColor) {
            return heatmapColor(GeospatialHeatmapColorScale.builder().applyMutation(heatmapColor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialHeatmapColorScale heatmapColor;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialHeatmapConfiguration model) {
            heatmapColor(model.heatmapColor);
        }

        public final GeospatialHeatmapColorScale.Builder getHeatmapColor() {
            return heatmapColor != null ? heatmapColor.toBuilder() : null;
        }

        public final void setHeatmapColor(GeospatialHeatmapColorScale.BuilderImpl heatmapColor) {
            this.heatmapColor = heatmapColor != null ? heatmapColor.build() : null;
        }

        @Override
        public final Builder heatmapColor(GeospatialHeatmapColorScale heatmapColor) {
            this.heatmapColor = heatmapColor;
            return this;
        }

        @Override
        public GeospatialHeatmapConfiguration build() {
            return new GeospatialHeatmapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
