/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The bound options (north, south, west, east) of the geospatial window options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialCoordinateBounds implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialCoordinateBounds.Builder, GeospatialCoordinateBounds> {
    private static final SdkField<Double> NORTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("North")
            .getter(getter(GeospatialCoordinateBounds::north)).setter(setter(Builder::north))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("North").build()).build();

    private static final SdkField<Double> SOUTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("South")
            .getter(getter(GeospatialCoordinateBounds::south)).setter(setter(Builder::south))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("South").build()).build();

    private static final SdkField<Double> WEST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("West")
            .getter(getter(GeospatialCoordinateBounds::west)).setter(setter(Builder::west))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("West").build()).build();

    private static final SdkField<Double> EAST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("East")
            .getter(getter(GeospatialCoordinateBounds::east)).setter(setter(Builder::east))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("East").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NORTH_FIELD, SOUTH_FIELD,
            WEST_FIELD, EAST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double north;

    private final Double south;

    private final Double west;

    private final Double east;

    private GeospatialCoordinateBounds(BuilderImpl builder) {
        this.north = builder.north;
        this.south = builder.south;
        this.west = builder.west;
        this.east = builder.east;
    }

    /**
     * <p>
     * The latitude of the north bound of the geospatial coordinate bounds.
     * </p>
     * 
     * @return The latitude of the north bound of the geospatial coordinate bounds.
     */
    public final Double north() {
        return north;
    }

    /**
     * <p>
     * The latitude of the south bound of the geospatial coordinate bounds.
     * </p>
     * 
     * @return The latitude of the south bound of the geospatial coordinate bounds.
     */
    public final Double south() {
        return south;
    }

    /**
     * <p>
     * The longitude of the west bound of the geospatial coordinate bounds.
     * </p>
     * 
     * @return The longitude of the west bound of the geospatial coordinate bounds.
     */
    public final Double west() {
        return west;
    }

    /**
     * <p>
     * The longitude of the east bound of the geospatial coordinate bounds.
     * </p>
     * 
     * @return The longitude of the east bound of the geospatial coordinate bounds.
     */
    public final Double east() {
        return east;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(north());
        hashCode = 31 * hashCode + Objects.hashCode(south());
        hashCode = 31 * hashCode + Objects.hashCode(west());
        hashCode = 31 * hashCode + Objects.hashCode(east());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialCoordinateBounds)) {
            return false;
        }
        GeospatialCoordinateBounds other = (GeospatialCoordinateBounds) obj;
        return Objects.equals(north(), other.north()) && Objects.equals(south(), other.south())
                && Objects.equals(west(), other.west()) && Objects.equals(east(), other.east());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialCoordinateBounds").add("North", north()).add("South", south()).add("West", west())
                .add("East", east()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "North":
            return Optional.ofNullable(clazz.cast(north()));
        case "South":
            return Optional.ofNullable(clazz.cast(south()));
        case "West":
            return Optional.ofNullable(clazz.cast(west()));
        case "East":
            return Optional.ofNullable(clazz.cast(east()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("North", NORTH_FIELD);
        map.put("South", SOUTH_FIELD);
        map.put("West", WEST_FIELD);
        map.put("East", EAST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialCoordinateBounds, T> g) {
        return obj -> g.apply((GeospatialCoordinateBounds) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialCoordinateBounds> {
        /**
         * <p>
         * The latitude of the north bound of the geospatial coordinate bounds.
         * </p>
         * 
         * @param north
         *        The latitude of the north bound of the geospatial coordinate bounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder north(Double north);

        /**
         * <p>
         * The latitude of the south bound of the geospatial coordinate bounds.
         * </p>
         * 
         * @param south
         *        The latitude of the south bound of the geospatial coordinate bounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder south(Double south);

        /**
         * <p>
         * The longitude of the west bound of the geospatial coordinate bounds.
         * </p>
         * 
         * @param west
         *        The longitude of the west bound of the geospatial coordinate bounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder west(Double west);

        /**
         * <p>
         * The longitude of the east bound of the geospatial coordinate bounds.
         * </p>
         * 
         * @param east
         *        The longitude of the east bound of the geospatial coordinate bounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder east(Double east);
    }

    static final class BuilderImpl implements Builder {
        private Double north;

        private Double south;

        private Double west;

        private Double east;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialCoordinateBounds model) {
            north(model.north);
            south(model.south);
            west(model.west);
            east(model.east);
        }

        public final Double getNorth() {
            return north;
        }

        public final void setNorth(Double north) {
            this.north = north;
        }

        @Override
        public final Builder north(Double north) {
            this.north = north;
            return this;
        }

        public final Double getSouth() {
            return south;
        }

        public final void setSouth(Double south) {
            this.south = south;
        }

        @Override
        public final Builder south(Double south) {
            this.south = south;
            return this;
        }

        public final Double getWest() {
            return west;
        }

        public final void setWest(Double west) {
            this.west = west;
        }

        @Override
        public final Builder west(Double west) {
            this.west = west;
            return this;
        }

        public final Double getEast() {
            return east;
        }

        public final void setEast(Double east) {
            this.east = east;
        }

        @Override
        public final Builder east(Double east) {
            this.east = east;
            return this;
        }

        @Override
        public GeospatialCoordinateBounds build() {
            return new GeospatialCoordinateBounds(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
