/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * sort-configuration-description
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BarChartSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BarChartSortConfiguration.Builder, BarChartSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("CategorySort")
            .getter(getter(BarChartSortConfiguration::categorySort))
            .setter(setter(Builder::categorySort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ItemsLimitConfiguration> CATEGORY_ITEMS_LIMIT_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO).memberName("CategoryItemsLimit")
            .getter(getter(BarChartSortConfiguration::categoryItemsLimit)).setter(setter(Builder::categoryItemsLimit))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryItemsLimit").build())
            .build();

    private static final SdkField<List<FieldSortOptions>> COLOR_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("ColorSort")
            .getter(getter(BarChartSortConfiguration::colorSort))
            .setter(setter(Builder::colorSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ItemsLimitConfiguration> COLOR_ITEMS_LIMIT_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO).memberName("ColorItemsLimit")
            .getter(getter(BarChartSortConfiguration::colorItemsLimit)).setter(setter(Builder::colorItemsLimit))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorItemsLimit").build()).build();

    private static final SdkField<List<FieldSortOptions>> SMALL_MULTIPLES_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("SmallMultiplesSort")
            .getter(getter(BarChartSortConfiguration::smallMultiplesSort))
            .setter(setter(Builder::smallMultiplesSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ItemsLimitConfiguration> SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SmallMultiplesLimitConfiguration")
            .getter(getter(BarChartSortConfiguration::smallMultiplesLimitConfiguration))
            .setter(setter(Builder::smallMultiplesLimitConfiguration))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesLimitConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD,
            CATEGORY_ITEMS_LIMIT_FIELD, COLOR_SORT_FIELD, COLOR_ITEMS_LIMIT_FIELD, SMALL_MULTIPLES_SORT_FIELD,
            SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> categorySort;

    private final ItemsLimitConfiguration categoryItemsLimit;

    private final List<FieldSortOptions> colorSort;

    private final ItemsLimitConfiguration colorItemsLimit;

    private final List<FieldSortOptions> smallMultiplesSort;

    private final ItemsLimitConfiguration smallMultiplesLimitConfiguration;

    private BarChartSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.categoryItemsLimit = builder.categoryItemsLimit;
        this.colorSort = builder.colorSort;
        this.colorItemsLimit = builder.colorItemsLimit;
        this.smallMultiplesSort = builder.smallMultiplesSort;
        this.smallMultiplesLimitConfiguration = builder.smallMultiplesLimitConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategorySort property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCategorySort() {
        return categorySort != null && !(categorySort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sort configuration of category fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategorySort} method.
     * </p>
     * 
     * @return The sort configuration of category fields.
     */
    public final List<FieldSortOptions> categorySort() {
        return categorySort;
    }

    /**
     * <p>
     * The limit on the number of categories displayed in a bar chart.
     * </p>
     * 
     * @return The limit on the number of categories displayed in a bar chart.
     */
    public final ItemsLimitConfiguration categoryItemsLimit() {
        return categoryItemsLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColorSort property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColorSort() {
        return colorSort != null && !(colorSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sort configuration of color fields in a bar chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColorSort} method.
     * </p>
     * 
     * @return The sort configuration of color fields in a bar chart.
     */
    public final List<FieldSortOptions> colorSort() {
        return colorSort;
    }

    /**
     * <p>
     * The limit on the number of values displayed in a bar chart.
     * </p>
     * 
     * @return The limit on the number of values displayed in a bar chart.
     */
    public final ItemsLimitConfiguration colorItemsLimit() {
        return colorItemsLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the SmallMultiplesSort property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSmallMultiplesSort() {
        return smallMultiplesSort != null && !(smallMultiplesSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sort configuration of the small multiples field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSmallMultiplesSort} method.
     * </p>
     * 
     * @return The sort configuration of the small multiples field.
     */
    public final List<FieldSortOptions> smallMultiplesSort() {
        return smallMultiplesSort;
    }

    /**
     * <p>
     * The limit on the number of small multiples panels that are displayed.
     * </p>
     * 
     * @return The limit on the number of small multiples panels that are displayed.
     */
    public final ItemsLimitConfiguration smallMultiplesLimitConfiguration() {
        return smallMultiplesLimitConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategorySort() ? categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(categoryItemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasColorSort() ? colorSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(colorItemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasSmallMultiplesSort() ? smallMultiplesSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(smallMultiplesLimitConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartSortConfiguration)) {
            return false;
        }
        BarChartSortConfiguration other = (BarChartSortConfiguration) obj;
        return hasCategorySort() == other.hasCategorySort() && Objects.equals(categorySort(), other.categorySort())
                && Objects.equals(categoryItemsLimit(), other.categoryItemsLimit()) && hasColorSort() == other.hasColorSort()
                && Objects.equals(colorSort(), other.colorSort()) && Objects.equals(colorItemsLimit(), other.colorItemsLimit())
                && hasSmallMultiplesSort() == other.hasSmallMultiplesSort()
                && Objects.equals(smallMultiplesSort(), other.smallMultiplesSort())
                && Objects.equals(smallMultiplesLimitConfiguration(), other.smallMultiplesLimitConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BarChartSortConfiguration").add("CategorySort", hasCategorySort() ? categorySort() : null)
                .add("CategoryItemsLimit", categoryItemsLimit()).add("ColorSort", hasColorSort() ? colorSort() : null)
                .add("ColorItemsLimit", colorItemsLimit())
                .add("SmallMultiplesSort", hasSmallMultiplesSort() ? smallMultiplesSort() : null)
                .add("SmallMultiplesLimitConfiguration", smallMultiplesLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategorySort":
            return Optional.ofNullable(clazz.cast(categorySort()));
        case "CategoryItemsLimit":
            return Optional.ofNullable(clazz.cast(categoryItemsLimit()));
        case "ColorSort":
            return Optional.ofNullable(clazz.cast(colorSort()));
        case "ColorItemsLimit":
            return Optional.ofNullable(clazz.cast(colorItemsLimit()));
        case "SmallMultiplesSort":
            return Optional.ofNullable(clazz.cast(smallMultiplesSort()));
        case "SmallMultiplesLimitConfiguration":
            return Optional.ofNullable(clazz.cast(smallMultiplesLimitConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CategorySort", CATEGORY_SORT_FIELD);
        map.put("CategoryItemsLimit", CATEGORY_ITEMS_LIMIT_FIELD);
        map.put("ColorSort", COLOR_SORT_FIELD);
        map.put("ColorItemsLimit", COLOR_ITEMS_LIMIT_FIELD);
        map.put("SmallMultiplesSort", SMALL_MULTIPLES_SORT_FIELD);
        map.put("SmallMultiplesLimitConfiguration", SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BarChartSortConfiguration, T> g) {
        return obj -> g.apply((BarChartSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BarChartSortConfiguration> {
        /**
         * <p>
         * The sort configuration of category fields.
         * </p>
         * 
         * @param categorySort
         *        The sort configuration of category fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySort(Collection<FieldSortOptions> categorySort);

        /**
         * <p>
         * The sort configuration of category fields.
         * </p>
         * 
         * @param categorySort
         *        The sort configuration of category fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySort(FieldSortOptions... categorySort);

        /**
         * <p>
         * The sort configuration of category fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #categorySort(List<FieldSortOptions>)}.
         * 
         * @param categorySort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categorySort(java.util.Collection<FieldSortOptions>)
         */
        Builder categorySort(Consumer<FieldSortOptions.Builder>... categorySort);

        /**
         * <p>
         * The limit on the number of categories displayed in a bar chart.
         * </p>
         * 
         * @param categoryItemsLimit
         *        The limit on the number of categories displayed in a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit);

        /**
         * <p>
         * The limit on the number of categories displayed in a bar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #categoryItemsLimit(ItemsLimitConfiguration)}.
         * 
         * @param categoryItemsLimit
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryItemsLimit(ItemsLimitConfiguration)
         */
        default Builder categoryItemsLimit(Consumer<ItemsLimitConfiguration.Builder> categoryItemsLimit) {
            return categoryItemsLimit(ItemsLimitConfiguration.builder().applyMutation(categoryItemsLimit).build());
        }

        /**
         * <p>
         * The sort configuration of color fields in a bar chart.
         * </p>
         * 
         * @param colorSort
         *        The sort configuration of color fields in a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSort(Collection<FieldSortOptions> colorSort);

        /**
         * <p>
         * The sort configuration of color fields in a bar chart.
         * </p>
         * 
         * @param colorSort
         *        The sort configuration of color fields in a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSort(FieldSortOptions... colorSort);

        /**
         * <p>
         * The sort configuration of color fields in a bar chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #colorSort(List<FieldSortOptions>)}.
         * 
         * @param colorSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSort(java.util.Collection<FieldSortOptions>)
         */
        Builder colorSort(Consumer<FieldSortOptions.Builder>... colorSort);

        /**
         * <p>
         * The limit on the number of values displayed in a bar chart.
         * </p>
         * 
         * @param colorItemsLimit
         *        The limit on the number of values displayed in a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorItemsLimit(ItemsLimitConfiguration colorItemsLimit);

        /**
         * <p>
         * The limit on the number of values displayed in a bar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #colorItemsLimit(ItemsLimitConfiguration)}.
         * 
         * @param colorItemsLimit
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorItemsLimit(ItemsLimitConfiguration)
         */
        default Builder colorItemsLimit(Consumer<ItemsLimitConfiguration.Builder> colorItemsLimit) {
            return colorItemsLimit(ItemsLimitConfiguration.builder().applyMutation(colorItemsLimit).build());
        }

        /**
         * <p>
         * The sort configuration of the small multiples field.
         * </p>
         * 
         * @param smallMultiplesSort
         *        The sort configuration of the small multiples field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallMultiplesSort(Collection<FieldSortOptions> smallMultiplesSort);

        /**
         * <p>
         * The sort configuration of the small multiples field.
         * </p>
         * 
         * @param smallMultiplesSort
         *        The sort configuration of the small multiples field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallMultiplesSort(FieldSortOptions... smallMultiplesSort);

        /**
         * <p>
         * The sort configuration of the small multiples field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #smallMultiplesSort(List<FieldSortOptions>)}.
         * 
         * @param smallMultiplesSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallMultiplesSort(java.util.Collection<FieldSortOptions>)
         */
        Builder smallMultiplesSort(Consumer<FieldSortOptions.Builder>... smallMultiplesSort);

        /**
         * <p>
         * The limit on the number of small multiples panels that are displayed.
         * </p>
         * 
         * @param smallMultiplesLimitConfiguration
         *        The limit on the number of small multiples panels that are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallMultiplesLimitConfiguration(ItemsLimitConfiguration smallMultiplesLimitConfiguration);

        /**
         * <p>
         * The limit on the number of small multiples panels that are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #smallMultiplesLimitConfiguration(ItemsLimitConfiguration)}.
         * 
         * @param smallMultiplesLimitConfiguration
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallMultiplesLimitConfiguration(ItemsLimitConfiguration)
         */
        default Builder smallMultiplesLimitConfiguration(
                Consumer<ItemsLimitConfiguration.Builder> smallMultiplesLimitConfiguration) {
            return smallMultiplesLimitConfiguration(ItemsLimitConfiguration.builder()
                    .applyMutation(smallMultiplesLimitConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();

        private ItemsLimitConfiguration categoryItemsLimit;

        private List<FieldSortOptions> colorSort = DefaultSdkAutoConstructList.getInstance();

        private ItemsLimitConfiguration colorItemsLimit;

        private List<FieldSortOptions> smallMultiplesSort = DefaultSdkAutoConstructList.getInstance();

        private ItemsLimitConfiguration smallMultiplesLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BarChartSortConfiguration model) {
            categorySort(model.categorySort);
            categoryItemsLimit(model.categoryItemsLimit);
            colorSort(model.colorSort);
            colorItemsLimit(model.colorItemsLimit);
            smallMultiplesSort(model.smallMultiplesSort);
            smallMultiplesLimitConfiguration(model.smallMultiplesLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions... categorySort) {
            categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder>... categorySort) {
            categorySort(Stream.of(categorySort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getCategoryItemsLimit() {
            return categoryItemsLimit != null ? categoryItemsLimit.toBuilder() : null;
        }

        public final void setCategoryItemsLimit(ItemsLimitConfiguration.BuilderImpl categoryItemsLimit) {
            this.categoryItemsLimit = categoryItemsLimit != null ? categoryItemsLimit.build() : null;
        }

        @Override
        public final Builder categoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
            this.categoryItemsLimit = categoryItemsLimit;
            return this;
        }

        public final List<FieldSortOptions.Builder> getColorSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.colorSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColorSort(Collection<FieldSortOptions.BuilderImpl> colorSort) {
            this.colorSort = FieldSortOptionsListCopier.copyFromBuilder(colorSort);
        }

        @Override
        public final Builder colorSort(Collection<FieldSortOptions> colorSort) {
            this.colorSort = FieldSortOptionsListCopier.copy(colorSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorSort(FieldSortOptions... colorSort) {
            colorSort(Arrays.asList(colorSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorSort(Consumer<FieldSortOptions.Builder>... colorSort) {
            colorSort(Stream.of(colorSort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getColorItemsLimit() {
            return colorItemsLimit != null ? colorItemsLimit.toBuilder() : null;
        }

        public final void setColorItemsLimit(ItemsLimitConfiguration.BuilderImpl colorItemsLimit) {
            this.colorItemsLimit = colorItemsLimit != null ? colorItemsLimit.build() : null;
        }

        @Override
        public final Builder colorItemsLimit(ItemsLimitConfiguration colorItemsLimit) {
            this.colorItemsLimit = colorItemsLimit;
            return this;
        }

        public final List<FieldSortOptions.Builder> getSmallMultiplesSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.smallMultiplesSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSmallMultiplesSort(Collection<FieldSortOptions.BuilderImpl> smallMultiplesSort) {
            this.smallMultiplesSort = FieldSortOptionsListCopier.copyFromBuilder(smallMultiplesSort);
        }

        @Override
        public final Builder smallMultiplesSort(Collection<FieldSortOptions> smallMultiplesSort) {
            this.smallMultiplesSort = FieldSortOptionsListCopier.copy(smallMultiplesSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smallMultiplesSort(FieldSortOptions... smallMultiplesSort) {
            smallMultiplesSort(Arrays.asList(smallMultiplesSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smallMultiplesSort(Consumer<FieldSortOptions.Builder>... smallMultiplesSort) {
            smallMultiplesSort(Stream.of(smallMultiplesSort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getSmallMultiplesLimitConfiguration() {
            return smallMultiplesLimitConfiguration != null ? smallMultiplesLimitConfiguration.toBuilder() : null;
        }

        public final void setSmallMultiplesLimitConfiguration(ItemsLimitConfiguration.BuilderImpl smallMultiplesLimitConfiguration) {
            this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration != null ? smallMultiplesLimitConfiguration
                    .build() : null;
        }

        @Override
        public final Builder smallMultiplesLimitConfiguration(ItemsLimitConfiguration smallMultiplesLimitConfiguration) {
            this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
            return this;
        }

        @Override
        public BarChartSortConfiguration build() {
            return new BarChartSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
