/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DrillDownFilter;
import software.amazon.awssdk.services.quicksight.model.DrillDownFilterListCopier;
import software.amazon.awssdk.services.quicksight.model.PredefinedHierarchyColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredefinedHierarchy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredefinedHierarchy> {
    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HierarchyId").getter(PredefinedHierarchy.getter(PredefinedHierarchy::hierarchyId)).setter(PredefinedHierarchy.setter(Builder::hierarchyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyId").build()}).build();
    private static final SdkField<List<ColumnIdentifier>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Columns").getter(PredefinedHierarchy.getter(PredefinedHierarchy::columns)).setter(PredefinedHierarchy.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DrillDownFilter>> DRILL_DOWN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DrillDownFilters").getter(PredefinedHierarchy.getter(PredefinedHierarchy::drillDownFilters)).setter(PredefinedHierarchy.setter(Builder::drillDownFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrillDownFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DrillDownFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_ID_FIELD, COLUMNS_FIELD, DRILL_DOWN_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PredefinedHierarchy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hierarchyId;
    private final List<ColumnIdentifier> columns;
    private final List<DrillDownFilter> drillDownFilters;

    private PredefinedHierarchy(BuilderImpl builder) {
        this.hierarchyId = builder.hierarchyId;
        this.columns = builder.columns;
        this.drillDownFilters = builder.drillDownFilters;
    }

    public final String hierarchyId() {
        return this.hierarchyId;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<ColumnIdentifier> columns() {
        return this.columns;
    }

    public final boolean hasDrillDownFilters() {
        return this.drillDownFilters != null && !(this.drillDownFilters instanceof SdkAutoConstructList);
    }

    public final List<DrillDownFilter> drillDownFilters() {
        return this.drillDownFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDrillDownFilters() ? this.drillDownFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedHierarchy)) {
            return false;
        }
        PredefinedHierarchy other = (PredefinedHierarchy)obj;
        return Objects.equals(this.hierarchyId(), other.hierarchyId()) && this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasDrillDownFilters() == other.hasDrillDownFilters() && Objects.equals(this.drillDownFilters(), other.drillDownFilters());
    }

    public final String toString() {
        return ToString.builder((String)"PredefinedHierarchy").add("HierarchyId", (Object)this.hierarchyId()).add("Columns", this.hasColumns() ? this.columns() : null).add("DrillDownFilters", this.hasDrillDownFilters() ? this.drillDownFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HierarchyId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyId()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "DrillDownFilters": {
                return Optional.ofNullable(clazz.cast(this.drillDownFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HierarchyId", HIERARCHY_ID_FIELD);
        map.put("Columns", COLUMNS_FIELD);
        map.put("DrillDownFilters", DRILL_DOWN_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedHierarchy, T> g) {
        return obj -> g.apply((PredefinedHierarchy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hierarchyId;
        private List<ColumnIdentifier> columns = DefaultSdkAutoConstructList.getInstance();
        private List<DrillDownFilter> drillDownFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedHierarchy model) {
            this.hierarchyId(model.hierarchyId);
            this.columns(model.columns);
            this.drillDownFilters(model.drillDownFilters);
        }

        public final String getHierarchyId() {
            return this.hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final List<ColumnIdentifier.Builder> getColumns() {
            List<ColumnIdentifier.Builder> result = PredefinedHierarchyColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<ColumnIdentifier.BuilderImpl> columns) {
            this.columns = PredefinedHierarchyColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<ColumnIdentifier> columns) {
            this.columns = PredefinedHierarchyColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(ColumnIdentifier ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<ColumnIdentifier.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DrillDownFilter.Builder> getDrillDownFilters() {
            List<DrillDownFilter.Builder> result = DrillDownFilterListCopier.copyToBuilder(this.drillDownFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDrillDownFilters(Collection<DrillDownFilter.BuilderImpl> drillDownFilters) {
            this.drillDownFilters = DrillDownFilterListCopier.copyFromBuilder(drillDownFilters);
        }

        @Override
        public final Builder drillDownFilters(Collection<DrillDownFilter> drillDownFilters) {
            this.drillDownFilters = DrillDownFilterListCopier.copy(drillDownFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drillDownFilters(DrillDownFilter ... drillDownFilters) {
            this.drillDownFilters(Arrays.asList(drillDownFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drillDownFilters(Consumer<DrillDownFilter.Builder> ... drillDownFilters) {
            this.drillDownFilters(Stream.of(drillDownFilters).map(c -> (DrillDownFilter)((DrillDownFilter.Builder)DrillDownFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PredefinedHierarchy build() {
            return new PredefinedHierarchy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredefinedHierarchy> {
        public Builder hierarchyId(String var1);

        public Builder columns(Collection<ColumnIdentifier> var1);

        public Builder columns(ColumnIdentifier ... var1);

        public Builder columns(Consumer<ColumnIdentifier.Builder> ... var1);

        public Builder drillDownFilters(Collection<DrillDownFilter> var1);

        public Builder drillDownFilters(DrillDownFilter ... var1);

        public Builder drillDownFilters(Consumer<DrillDownFilter.Builder> ... var1);
    }
}

