/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.MemberType;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFolderMembershipRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateFolderMembershipRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateFolderMembershipRequest.getter(CreateFolderMembershipRequest::awsAccountId)).setter(CreateFolderMembershipRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FolderId").getter(CreateFolderMembershipRequest.getter(CreateFolderMembershipRequest::folderId)).setter(CreateFolderMembershipRequest.setter(Builder::folderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(CreateFolderMembershipRequest.getter(CreateFolderMembershipRequest::memberId)).setter(CreateFolderMembershipRequest.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberId").build()}).build();
    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberType").getter(CreateFolderMembershipRequest.getter(CreateFolderMembershipRequest::memberTypeAsString)).setter(CreateFolderMembershipRequest.setter(Builder::memberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, FOLDER_ID_FIELD, MEMBER_ID_FIELD, MEMBER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFolderMembershipRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String folderId;
    private final String memberId;
    private final String memberType;

    private CreateFolderMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.folderId = builder.folderId;
        this.memberId = builder.memberId;
        this.memberType = builder.memberType;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String folderId() {
        return this.folderId;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final MemberType memberType() {
        return MemberType.fromValue(this.memberType);
    }

    public final String memberTypeAsString() {
        return this.memberType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFolderMembershipRequest)) {
            return false;
        }
        CreateFolderMembershipRequest other = (CreateFolderMembershipRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.memberTypeAsString(), other.memberTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFolderMembershipRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("FolderId", (Object)this.folderId()).add("MemberId", (Object)this.memberId()).add("MemberType", (Object)this.memberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "FolderId": {
                return Optional.ofNullable(clazz.cast(this.folderId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "MemberType": {
                return Optional.ofNullable(clazz.cast(this.memberTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("FolderId", FOLDER_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("MemberType", MEMBER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFolderMembershipRequest, T> g) {
        return obj -> g.apply((CreateFolderMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String folderId;
        private String memberId;
        private String memberType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFolderMembershipRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.folderId(model.folderId);
            this.memberId(model.memberId);
            this.memberType(model.memberType);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getMemberType() {
            return this.memberType;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFolderMembershipRequest build() {
            return new CreateFolderMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFolderMembershipRequest> {
        public Builder awsAccountId(String var1);

        public Builder folderId(String var1);

        public Builder memberId(String var1);

        public Builder memberType(String var1);

        public Builder memberType(MemberType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

