/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ReviewedAnswerErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidTopicReviewedAnswer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvalidTopicReviewedAnswer> {
    private static final SdkField<String> ANSWER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnswerId").getter(InvalidTopicReviewedAnswer.getter(InvalidTopicReviewedAnswer::answerId)).setter(InvalidTopicReviewedAnswer.setter(Builder::answerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerId").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(InvalidTopicReviewedAnswer.getter(InvalidTopicReviewedAnswer::errorAsString)).setter(InvalidTopicReviewedAnswer.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANSWER_ID_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidTopicReviewedAnswer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String answerId;
    private final String error;

    private InvalidTopicReviewedAnswer(BuilderImpl builder) {
        this.answerId = builder.answerId;
        this.error = builder.error;
    }

    public final String answerId() {
        return this.answerId;
    }

    public final ReviewedAnswerErrorCode error() {
        return ReviewedAnswerErrorCode.fromValue(this.error);
    }

    public final String errorAsString() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.answerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidTopicReviewedAnswer)) {
            return false;
        }
        InvalidTopicReviewedAnswer other = (InvalidTopicReviewedAnswer)obj;
        return Objects.equals(this.answerId(), other.answerId()) && Objects.equals(this.errorAsString(), other.errorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InvalidTopicReviewedAnswer").add("AnswerId", (Object)this.answerId()).add("Error", (Object)this.errorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnswerId": {
                return Optional.ofNullable(clazz.cast(this.answerId()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.errorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AnswerId", ANSWER_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidTopicReviewedAnswer, T> g) {
        return obj -> g.apply((InvalidTopicReviewedAnswer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String answerId;
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidTopicReviewedAnswer model) {
            this.answerId(model.answerId);
            this.error(model.error);
        }

        public final String getAnswerId() {
            return this.answerId;
        }

        public final void setAnswerId(String answerId) {
            this.answerId = answerId;
        }

        @Override
        public final Builder answerId(String answerId) {
            this.answerId = answerId;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(ReviewedAnswerErrorCode error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public InvalidTopicReviewedAnswer build() {
            return new InvalidTopicReviewedAnswer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidTopicReviewedAnswer> {
        public Builder answerId(String var1);

        public Builder error(String var1);

        public Builder error(ReviewedAnswerErrorCode var1);
    }
}

