/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QAResultType {
    DASHBOARD_VISUAL("DASHBOARD_VISUAL"),
    GENERATED_ANSWER("GENERATED_ANSWER"),
    NO_ANSWER("NO_ANSWER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QAResultType> VALUE_MAP;
    private final String value;

    private QAResultType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QAResultType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QAResultType> knownValues() {
        EnumSet<QAResultType> knownValues = EnumSet.allOf(QAResultType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QAResultType.class, QAResultType::toString);
    }
}

