/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAnalysisRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, DeleteAnalysisRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DeleteAnalysisRequest.getter(DeleteAnalysisRequest::awsAccountId)).setter(DeleteAnalysisRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(DeleteAnalysisRequest.getter(DeleteAnalysisRequest::analysisId)).setter(DeleteAnalysisRequest.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AnalysisId").build()}).build();
    private static final SdkField<Long> RECOVERY_WINDOW_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecoveryWindowInDays").getter(DeleteAnalysisRequest.getter(DeleteAnalysisRequest::recoveryWindowInDays)).setter(DeleteAnalysisRequest.setter(Builder::recoveryWindowInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recovery-window-in-days").build()}).build();
    private static final SdkField<Boolean> FORCE_DELETE_WITHOUT_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceDeleteWithoutRecovery").getter(DeleteAnalysisRequest.getter(DeleteAnalysisRequest::forceDeleteWithoutRecovery)).setter(DeleteAnalysisRequest.setter(Builder::forceDeleteWithoutRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force-delete-without-recovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ANALYSIS_ID_FIELD, RECOVERY_WINDOW_IN_DAYS_FIELD, FORCE_DELETE_WITHOUT_RECOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAnalysisRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String analysisId;
    private final Long recoveryWindowInDays;
    private final Boolean forceDeleteWithoutRecovery;

    private DeleteAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.analysisId = builder.analysisId;
        this.recoveryWindowInDays = builder.recoveryWindowInDays;
        this.forceDeleteWithoutRecovery = builder.forceDeleteWithoutRecovery;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final Long recoveryWindowInDays() {
        return this.recoveryWindowInDays;
    }

    public final Boolean forceDeleteWithoutRecovery() {
        return this.forceDeleteWithoutRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDeleteWithoutRecovery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalysisRequest)) {
            return false;
        }
        DeleteAnalysisRequest other = (DeleteAnalysisRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.recoveryWindowInDays(), other.recoveryWindowInDays()) && Objects.equals(this.forceDeleteWithoutRecovery(), other.forceDeleteWithoutRecovery());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAnalysisRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AnalysisId", (Object)this.analysisId()).add("RecoveryWindowInDays", (Object)this.recoveryWindowInDays()).add("ForceDeleteWithoutRecovery", (Object)this.forceDeleteWithoutRecovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "RecoveryWindowInDays": {
                return Optional.ofNullable(clazz.cast(this.recoveryWindowInDays()));
            }
            case "ForceDeleteWithoutRecovery": {
                return Optional.ofNullable(clazz.cast(this.forceDeleteWithoutRecovery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("recovery-window-in-days", RECOVERY_WINDOW_IN_DAYS_FIELD);
        map.put("force-delete-without-recovery", FORCE_DELETE_WITHOUT_RECOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnalysisRequest, T> g) {
        return obj -> g.apply((DeleteAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String analysisId;
        private Long recoveryWindowInDays;
        private Boolean forceDeleteWithoutRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalysisRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.analysisId(model.analysisId);
            this.recoveryWindowInDays(model.recoveryWindowInDays);
            this.forceDeleteWithoutRecovery(model.forceDeleteWithoutRecovery);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final Long getRecoveryWindowInDays() {
            return this.recoveryWindowInDays;
        }

        public final void setRecoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
        }

        @Override
        public final Builder recoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            return this;
        }

        public final Boolean getForceDeleteWithoutRecovery() {
            return this.forceDeleteWithoutRecovery;
        }

        public final void setForceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery) {
            this.forceDeleteWithoutRecovery = forceDeleteWithoutRecovery;
        }

        @Override
        public final Builder forceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery) {
            this.forceDeleteWithoutRecovery = forceDeleteWithoutRecovery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAnalysisRequest build() {
            return new DeleteAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAnalysisRequest> {
        public Builder awsAccountId(String var1);

        public Builder analysisId(String var1);

        public Builder recoveryWindowInDays(Long var1);

        public Builder forceDeleteWithoutRecovery(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

