/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.LineChartLineStyle;
import software.amazon.awssdk.services.quicksight.model.LineInterpolation;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineChartLineStyleSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineChartLineStyleSettings> {
    private static final SdkField<String> LINE_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineVisibility").getter(LineChartLineStyleSettings.getter(LineChartLineStyleSettings::lineVisibilityAsString)).setter(LineChartLineStyleSettings.setter(Builder::lineVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineVisibility").build()}).build();
    private static final SdkField<String> LINE_INTERPOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineInterpolation").getter(LineChartLineStyleSettings.getter(LineChartLineStyleSettings::lineInterpolationAsString)).setter(LineChartLineStyleSettings.setter(Builder::lineInterpolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineInterpolation").build()}).build();
    private static final SdkField<String> LINE_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineStyle").getter(LineChartLineStyleSettings.getter(LineChartLineStyleSettings::lineStyleAsString)).setter(LineChartLineStyleSettings.setter(Builder::lineStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineStyle").build()}).build();
    private static final SdkField<String> LINE_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineWidth").getter(LineChartLineStyleSettings.getter(LineChartLineStyleSettings::lineWidth)).setter(LineChartLineStyleSettings.setter(Builder::lineWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineWidth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_VISIBILITY_FIELD, LINE_INTERPOLATION_FIELD, LINE_STYLE_FIELD, LINE_WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineChartLineStyleSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lineVisibility;
    private final String lineInterpolation;
    private final String lineStyle;
    private final String lineWidth;

    private LineChartLineStyleSettings(BuilderImpl builder) {
        this.lineVisibility = builder.lineVisibility;
        this.lineInterpolation = builder.lineInterpolation;
        this.lineStyle = builder.lineStyle;
        this.lineWidth = builder.lineWidth;
    }

    public final Visibility lineVisibility() {
        return Visibility.fromValue(this.lineVisibility);
    }

    public final String lineVisibilityAsString() {
        return this.lineVisibility;
    }

    public final LineInterpolation lineInterpolation() {
        return LineInterpolation.fromValue(this.lineInterpolation);
    }

    public final String lineInterpolationAsString() {
        return this.lineInterpolation;
    }

    public final LineChartLineStyle lineStyle() {
        return LineChartLineStyle.fromValue(this.lineStyle);
    }

    public final String lineStyleAsString() {
        return this.lineStyle;
    }

    public final String lineWidth() {
        return this.lineWidth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lineVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineInterpolationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineWidth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartLineStyleSettings)) {
            return false;
        }
        LineChartLineStyleSettings other = (LineChartLineStyleSettings)obj;
        return Objects.equals(this.lineVisibilityAsString(), other.lineVisibilityAsString()) && Objects.equals(this.lineInterpolationAsString(), other.lineInterpolationAsString()) && Objects.equals(this.lineStyleAsString(), other.lineStyleAsString()) && Objects.equals(this.lineWidth(), other.lineWidth());
    }

    public final String toString() {
        return ToString.builder((String)"LineChartLineStyleSettings").add("LineVisibility", (Object)this.lineVisibilityAsString()).add("LineInterpolation", (Object)this.lineInterpolationAsString()).add("LineStyle", (Object)this.lineStyleAsString()).add("LineWidth", (Object)this.lineWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineVisibility": {
                return Optional.ofNullable(clazz.cast(this.lineVisibilityAsString()));
            }
            case "LineInterpolation": {
                return Optional.ofNullable(clazz.cast(this.lineInterpolationAsString()));
            }
            case "LineStyle": {
                return Optional.ofNullable(clazz.cast(this.lineStyleAsString()));
            }
            case "LineWidth": {
                return Optional.ofNullable(clazz.cast(this.lineWidth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LineVisibility", LINE_VISIBILITY_FIELD);
        map.put("LineInterpolation", LINE_INTERPOLATION_FIELD);
        map.put("LineStyle", LINE_STYLE_FIELD);
        map.put("LineWidth", LINE_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartLineStyleSettings, T> g) {
        return obj -> g.apply((LineChartLineStyleSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lineVisibility;
        private String lineInterpolation;
        private String lineStyle;
        private String lineWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartLineStyleSettings model) {
            this.lineVisibility(model.lineVisibility);
            this.lineInterpolation(model.lineInterpolation);
            this.lineStyle(model.lineStyle);
            this.lineWidth(model.lineWidth);
        }

        public final String getLineVisibility() {
            return this.lineVisibility;
        }

        public final void setLineVisibility(String lineVisibility) {
            this.lineVisibility = lineVisibility;
        }

        @Override
        public final Builder lineVisibility(String lineVisibility) {
            this.lineVisibility = lineVisibility;
            return this;
        }

        @Override
        public final Builder lineVisibility(Visibility lineVisibility) {
            this.lineVisibility(lineVisibility == null ? null : lineVisibility.toString());
            return this;
        }

        public final String getLineInterpolation() {
            return this.lineInterpolation;
        }

        public final void setLineInterpolation(String lineInterpolation) {
            this.lineInterpolation = lineInterpolation;
        }

        @Override
        public final Builder lineInterpolation(String lineInterpolation) {
            this.lineInterpolation = lineInterpolation;
            return this;
        }

        @Override
        public final Builder lineInterpolation(LineInterpolation lineInterpolation) {
            this.lineInterpolation(lineInterpolation == null ? null : lineInterpolation.toString());
            return this;
        }

        public final String getLineStyle() {
            return this.lineStyle;
        }

        public final void setLineStyle(String lineStyle) {
            this.lineStyle = lineStyle;
        }

        @Override
        public final Builder lineStyle(String lineStyle) {
            this.lineStyle = lineStyle;
            return this;
        }

        @Override
        public final Builder lineStyle(LineChartLineStyle lineStyle) {
            this.lineStyle(lineStyle == null ? null : lineStyle.toString());
            return this;
        }

        public final String getLineWidth() {
            return this.lineWidth;
        }

        public final void setLineWidth(String lineWidth) {
            this.lineWidth = lineWidth;
        }

        @Override
        public final Builder lineWidth(String lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public LineChartLineStyleSettings build() {
            return new LineChartLineStyleSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineChartLineStyleSettings> {
        public Builder lineVisibility(String var1);

        public Builder lineVisibility(Visibility var1);

        public Builder lineInterpolation(String var1);

        public Builder lineInterpolation(LineInterpolation var1);

        public Builder lineStyle(String var1);

        public Builder lineStyle(LineChartLineStyle var1);

        public Builder lineWidth(String var1);
    }
}

