/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AssignmentStatus;
import software.amazon.awssdk.services.quicksight.model.IdentityMapCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIamPolicyAssignmentRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateIamPolicyAssignmentRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateIamPolicyAssignmentRequest.getter(UpdateIamPolicyAssignmentRequest::awsAccountId)).setter(UpdateIamPolicyAssignmentRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentName").getter(UpdateIamPolicyAssignmentRequest.getter(UpdateIamPolicyAssignmentRequest::assignmentName)).setter(UpdateIamPolicyAssignmentRequest.setter(Builder::assignmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AssignmentName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(UpdateIamPolicyAssignmentRequest.getter(UpdateIamPolicyAssignmentRequest::namespace)).setter(UpdateIamPolicyAssignmentRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentStatus").getter(UpdateIamPolicyAssignmentRequest.getter(UpdateIamPolicyAssignmentRequest::assignmentStatusAsString)).setter(UpdateIamPolicyAssignmentRequest.setter(Builder::assignmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(UpdateIamPolicyAssignmentRequest.getter(UpdateIamPolicyAssignmentRequest::policyArn)).setter(UpdateIamPolicyAssignmentRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Identities").getter(UpdateIamPolicyAssignmentRequest.getter(UpdateIamPolicyAssignmentRequest::identities)).setter(UpdateIamPolicyAssignmentRequest.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ASSIGNMENT_NAME_FIELD, NAMESPACE_FIELD, ASSIGNMENT_STATUS_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIamPolicyAssignmentRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String assignmentName;
    private final String namespace;
    private final String assignmentStatus;
    private final String policyArn;
    private final Map<String, List<String>> identities;

    private UpdateIamPolicyAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assignmentName = builder.assignmentName;
        this.namespace = builder.namespace;
        this.assignmentStatus = builder.assignmentStatus;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String assignmentName() {
        return this.assignmentName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public final String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> identities() {
        return this.identities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIamPolicyAssignmentRequest)) {
            return false;
        }
        UpdateIamPolicyAssignmentRequest other = (UpdateIamPolicyAssignmentRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.assignmentName(), other.assignmentName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString()) && Objects.equals(this.policyArn(), other.policyArn()) && this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIamPolicyAssignmentRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AssignmentName", (Object)this.assignmentName()).add("Namespace", (Object)this.namespace()).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).add("PolicyArn", (Object)this.policyArn()).add("Identities", this.hasIdentities() ? this.identities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AssignmentName": {
                return Optional.ofNullable(clazz.cast(this.assignmentName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AssignmentName", ASSIGNMENT_NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("AssignmentStatus", ASSIGNMENT_STATUS_FIELD);
        map.put("PolicyArn", POLICY_ARN_FIELD);
        map.put("Identities", IDENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIamPolicyAssignmentRequest, T> g) {
        return obj -> g.apply((UpdateIamPolicyAssignmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String assignmentName;
        private String namespace;
        private String assignmentStatus;
        private String policyArn;
        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIamPolicyAssignmentRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.assignmentName(model.assignmentName);
            this.namespace(model.namespace);
            this.assignmentStatus(model.assignmentStatus);
            this.policyArn(model.policyArn);
            this.identities(model.identities);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssignmentName() {
            return this.assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (this.identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIamPolicyAssignmentRequest build() {
            return new UpdateIamPolicyAssignmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIamPolicyAssignmentRequest> {
        public Builder awsAccountId(String var1);

        public Builder assignmentName(String var1);

        public Builder namespace(String var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);

        public Builder policyArn(String var1);

        public Builder identities(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

