/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AssignmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IAMPolicyAssignmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IAMPolicyAssignmentSummary> {
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentName").getter(IAMPolicyAssignmentSummary.getter(IAMPolicyAssignmentSummary::assignmentName)).setter(IAMPolicyAssignmentSummary.setter(Builder::assignmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()}).build();
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentStatus").getter(IAMPolicyAssignmentSummary.getter(IAMPolicyAssignmentSummary::assignmentStatusAsString)).setter(IAMPolicyAssignmentSummary.setter(Builder::assignmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_NAME_FIELD, ASSIGNMENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssignmentName", ASSIGNMENT_NAME_FIELD);
            this.put("AssignmentStatus", ASSIGNMENT_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String assignmentName;
    private final String assignmentStatus;

    private IAMPolicyAssignmentSummary(BuilderImpl builder) {
        this.assignmentName = builder.assignmentName;
        this.assignmentStatus = builder.assignmentStatus;
    }

    public final String assignmentName() {
        return this.assignmentName;
    }

    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public final String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAMPolicyAssignmentSummary)) {
            return false;
        }
        IAMPolicyAssignmentSummary other = (IAMPolicyAssignmentSummary)obj;
        return Objects.equals(this.assignmentName(), other.assignmentName()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IAMPolicyAssignmentSummary").add("AssignmentName", (Object)this.assignmentName()).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentName": {
                return Optional.ofNullable(clazz.cast(this.assignmentName()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IAMPolicyAssignmentSummary, T> g) {
        return obj -> g.apply((IAMPolicyAssignmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assignmentName;
        private String assignmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(IAMPolicyAssignmentSummary model) {
            this.assignmentName(model.assignmentName);
            this.assignmentStatus(model.assignmentStatus);
        }

        public final String getAssignmentName() {
            return this.assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public IAMPolicyAssignmentSummary build() {
            return new IAMPolicyAssignmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IAMPolicyAssignmentSummary> {
        public Builder assignmentName(String var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);
    }
}

