/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineCustomLabelConfiguration;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineLabelHorizontalPosition;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineLabelVerticalPosition;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineValueLabelConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceLineLabelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceLineLabelConfiguration> {
    private static final SdkField<ReferenceLineValueLabelConfiguration> VALUE_LABEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueLabelConfiguration").getter(ReferenceLineLabelConfiguration.getter(ReferenceLineLabelConfiguration::valueLabelConfiguration)).setter(ReferenceLineLabelConfiguration.setter(Builder::valueLabelConfiguration)).constructor(ReferenceLineValueLabelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelConfiguration").build()}).build();
    private static final SdkField<ReferenceLineCustomLabelConfiguration> CUSTOM_LABEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomLabelConfiguration").getter(ReferenceLineLabelConfiguration.getter(ReferenceLineLabelConfiguration::customLabelConfiguration)).setter(ReferenceLineLabelConfiguration.setter(Builder::customLabelConfiguration)).constructor(ReferenceLineCustomLabelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabelConfiguration").build()}).build();
    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontConfiguration").getter(ReferenceLineLabelConfiguration.getter(ReferenceLineLabelConfiguration::fontConfiguration)).setter(ReferenceLineLabelConfiguration.setter(Builder::fontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()}).build();
    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontColor").getter(ReferenceLineLabelConfiguration.getter(ReferenceLineLabelConfiguration::fontColor)).setter(ReferenceLineLabelConfiguration.setter(Builder::fontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontColor").build()}).build();
    private static final SdkField<String> HORIZONTAL_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HorizontalPosition").getter(ReferenceLineLabelConfiguration.getter(ReferenceLineLabelConfiguration::horizontalPositionAsString)).setter(ReferenceLineLabelConfiguration.setter(Builder::horizontalPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalPosition").build()}).build();
    private static final SdkField<String> VERTICAL_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerticalPosition").getter(ReferenceLineLabelConfiguration.getter(ReferenceLineLabelConfiguration::verticalPositionAsString)).setter(ReferenceLineLabelConfiguration.setter(Builder::verticalPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_LABEL_CONFIGURATION_FIELD, CUSTOM_LABEL_CONFIGURATION_FIELD, FONT_CONFIGURATION_FIELD, FONT_COLOR_FIELD, HORIZONTAL_POSITION_FIELD, VERTICAL_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ValueLabelConfiguration", VALUE_LABEL_CONFIGURATION_FIELD);
            this.put("CustomLabelConfiguration", CUSTOM_LABEL_CONFIGURATION_FIELD);
            this.put("FontConfiguration", FONT_CONFIGURATION_FIELD);
            this.put("FontColor", FONT_COLOR_FIELD);
            this.put("HorizontalPosition", HORIZONTAL_POSITION_FIELD);
            this.put("VerticalPosition", VERTICAL_POSITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ReferenceLineValueLabelConfiguration valueLabelConfiguration;
    private final ReferenceLineCustomLabelConfiguration customLabelConfiguration;
    private final FontConfiguration fontConfiguration;
    private final String fontColor;
    private final String horizontalPosition;
    private final String verticalPosition;

    private ReferenceLineLabelConfiguration(BuilderImpl builder) {
        this.valueLabelConfiguration = builder.valueLabelConfiguration;
        this.customLabelConfiguration = builder.customLabelConfiguration;
        this.fontConfiguration = builder.fontConfiguration;
        this.fontColor = builder.fontColor;
        this.horizontalPosition = builder.horizontalPosition;
        this.verticalPosition = builder.verticalPosition;
    }

    public final ReferenceLineValueLabelConfiguration valueLabelConfiguration() {
        return this.valueLabelConfiguration;
    }

    public final ReferenceLineCustomLabelConfiguration customLabelConfiguration() {
        return this.customLabelConfiguration;
    }

    public final FontConfiguration fontConfiguration() {
        return this.fontConfiguration;
    }

    public final String fontColor() {
        return this.fontColor;
    }

    public final ReferenceLineLabelHorizontalPosition horizontalPosition() {
        return ReferenceLineLabelHorizontalPosition.fromValue(this.horizontalPosition);
    }

    public final String horizontalPositionAsString() {
        return this.horizontalPosition;
    }

    public final ReferenceLineLabelVerticalPosition verticalPosition() {
        return ReferenceLineLabelVerticalPosition.fromValue(this.verticalPosition);
    }

    public final String verticalPositionAsString() {
        return this.verticalPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valueLabelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLabelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.horizontalPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verticalPositionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineLabelConfiguration)) {
            return false;
        }
        ReferenceLineLabelConfiguration other = (ReferenceLineLabelConfiguration)obj;
        return Objects.equals(this.valueLabelConfiguration(), other.valueLabelConfiguration()) && Objects.equals(this.customLabelConfiguration(), other.customLabelConfiguration()) && Objects.equals(this.fontConfiguration(), other.fontConfiguration()) && Objects.equals(this.fontColor(), other.fontColor()) && Objects.equals(this.horizontalPositionAsString(), other.horizontalPositionAsString()) && Objects.equals(this.verticalPositionAsString(), other.verticalPositionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceLineLabelConfiguration").add("ValueLabelConfiguration", (Object)this.valueLabelConfiguration()).add("CustomLabelConfiguration", (Object)this.customLabelConfiguration()).add("FontConfiguration", (Object)this.fontConfiguration()).add("FontColor", (Object)this.fontColor()).add("HorizontalPosition", (Object)this.horizontalPositionAsString()).add("VerticalPosition", (Object)this.verticalPositionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueLabelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.valueLabelConfiguration()));
            }
            case "CustomLabelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customLabelConfiguration()));
            }
            case "FontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fontConfiguration()));
            }
            case "FontColor": {
                return Optional.ofNullable(clazz.cast(this.fontColor()));
            }
            case "HorizontalPosition": {
                return Optional.ofNullable(clazz.cast(this.horizontalPositionAsString()));
            }
            case "VerticalPosition": {
                return Optional.ofNullable(clazz.cast(this.verticalPositionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineLabelConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineLabelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReferenceLineValueLabelConfiguration valueLabelConfiguration;
        private ReferenceLineCustomLabelConfiguration customLabelConfiguration;
        private FontConfiguration fontConfiguration;
        private String fontColor;
        private String horizontalPosition;
        private String verticalPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineLabelConfiguration model) {
            this.valueLabelConfiguration(model.valueLabelConfiguration);
            this.customLabelConfiguration(model.customLabelConfiguration);
            this.fontConfiguration(model.fontConfiguration);
            this.fontColor(model.fontColor);
            this.horizontalPosition(model.horizontalPosition);
            this.verticalPosition(model.verticalPosition);
        }

        public final ReferenceLineValueLabelConfiguration.Builder getValueLabelConfiguration() {
            return this.valueLabelConfiguration != null ? this.valueLabelConfiguration.toBuilder() : null;
        }

        public final void setValueLabelConfiguration(ReferenceLineValueLabelConfiguration.BuilderImpl valueLabelConfiguration) {
            this.valueLabelConfiguration = valueLabelConfiguration != null ? valueLabelConfiguration.build() : null;
        }

        @Override
        public final Builder valueLabelConfiguration(ReferenceLineValueLabelConfiguration valueLabelConfiguration) {
            this.valueLabelConfiguration = valueLabelConfiguration;
            return this;
        }

        public final ReferenceLineCustomLabelConfiguration.Builder getCustomLabelConfiguration() {
            return this.customLabelConfiguration != null ? this.customLabelConfiguration.toBuilder() : null;
        }

        public final void setCustomLabelConfiguration(ReferenceLineCustomLabelConfiguration.BuilderImpl customLabelConfiguration) {
            this.customLabelConfiguration = customLabelConfiguration != null ? customLabelConfiguration.build() : null;
        }

        @Override
        public final Builder customLabelConfiguration(ReferenceLineCustomLabelConfiguration customLabelConfiguration) {
            this.customLabelConfiguration = customLabelConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return this.fontConfiguration != null ? this.fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getFontColor() {
            return this.fontColor;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        public final String getHorizontalPosition() {
            return this.horizontalPosition;
        }

        public final void setHorizontalPosition(String horizontalPosition) {
            this.horizontalPosition = horizontalPosition;
        }

        @Override
        public final Builder horizontalPosition(String horizontalPosition) {
            this.horizontalPosition = horizontalPosition;
            return this;
        }

        @Override
        public final Builder horizontalPosition(ReferenceLineLabelHorizontalPosition horizontalPosition) {
            this.horizontalPosition(horizontalPosition == null ? null : horizontalPosition.toString());
            return this;
        }

        public final String getVerticalPosition() {
            return this.verticalPosition;
        }

        public final void setVerticalPosition(String verticalPosition) {
            this.verticalPosition = verticalPosition;
        }

        @Override
        public final Builder verticalPosition(String verticalPosition) {
            this.verticalPosition = verticalPosition;
            return this;
        }

        @Override
        public final Builder verticalPosition(ReferenceLineLabelVerticalPosition verticalPosition) {
            this.verticalPosition(verticalPosition == null ? null : verticalPosition.toString());
            return this;
        }

        public ReferenceLineLabelConfiguration build() {
            return new ReferenceLineLabelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceLineLabelConfiguration> {
        public Builder valueLabelConfiguration(ReferenceLineValueLabelConfiguration var1);

        default public Builder valueLabelConfiguration(Consumer<ReferenceLineValueLabelConfiguration.Builder> valueLabelConfiguration) {
            return this.valueLabelConfiguration((ReferenceLineValueLabelConfiguration)((ReferenceLineValueLabelConfiguration.Builder)ReferenceLineValueLabelConfiguration.builder().applyMutation(valueLabelConfiguration)).build());
        }

        public Builder customLabelConfiguration(ReferenceLineCustomLabelConfiguration var1);

        default public Builder customLabelConfiguration(Consumer<ReferenceLineCustomLabelConfiguration.Builder> customLabelConfiguration) {
            return this.customLabelConfiguration((ReferenceLineCustomLabelConfiguration)((ReferenceLineCustomLabelConfiguration.Builder)ReferenceLineCustomLabelConfiguration.builder().applyMutation(customLabelConfiguration)).build());
        }

        public Builder fontConfiguration(FontConfiguration var1);

        default public Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return this.fontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(fontConfiguration)).build());
        }

        public Builder fontColor(String var1);

        public Builder horizontalPosition(String var1);

        public Builder horizontalPosition(ReferenceLineLabelHorizontalPosition var1);

        public Builder verticalPosition(String var1);

        public Builder verticalPosition(ReferenceLineLabelVerticalPosition var1);
    }
}

