/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a word cloud visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WordCloudChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WordCloudChartConfiguration.Builder, WordCloudChartConfiguration> {
    private static final SdkField<WordCloudFieldWells> FIELD_WELLS_FIELD = SdkField
            .<WordCloudFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(WordCloudChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(WordCloudFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<WordCloudSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<WordCloudSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(WordCloudChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(WordCloudSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(WordCloudChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<WordCloudOptions> WORD_CLOUD_OPTIONS_FIELD = SdkField
            .<WordCloudOptions> builder(MarshallingType.SDK_POJO).memberName("WordCloudOptions")
            .getter(getter(WordCloudChartConfiguration::wordCloudOptions)).setter(setter(Builder::wordCloudOptions))
            .constructor(WordCloudOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCloudOptions").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(WordCloudChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, WORD_CLOUD_OPTIONS_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WordCloudFieldWells fieldWells;

    private final WordCloudSortConfiguration sortConfiguration;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final WordCloudOptions wordCloudOptions;

    private final VisualInteractionOptions interactions;

    private WordCloudChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.wordCloudOptions = builder.wordCloudOptions;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final WordCloudFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a word cloud visual.
     * </p>
     * 
     * @return The sort configuration of a word cloud visual.
     */
    public final WordCloudSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) for the word cloud category.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) for the word cloud category.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The options for a word cloud visual.
     * </p>
     * 
     * @return The options for a word cloud visual.
     */
    public final WordCloudOptions wordCloudOptions() {
        return wordCloudOptions;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(wordCloudOptions());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudChartConfiguration)) {
            return false;
        }
        WordCloudChartConfiguration other = (WordCloudChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(wordCloudOptions(), other.wordCloudOptions())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WordCloudChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("CategoryLabelOptions", categoryLabelOptions())
                .add("WordCloudOptions", wordCloudOptions()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "WordCloudOptions":
            return Optional.ofNullable(clazz.cast(wordCloudOptions()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("WordCloudOptions", WORD_CLOUD_OPTIONS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WordCloudChartConfiguration, T> g) {
        return obj -> g.apply((WordCloudChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WordCloudChartConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(WordCloudFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WordCloudFieldWells.Builder} avoiding the
         * need to create one manually via {@link WordCloudFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WordCloudFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(WordCloudFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link WordCloudFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(WordCloudFieldWells)
         */
        default Builder fieldWells(Consumer<WordCloudFieldWells.Builder> fieldWells) {
            return fieldWells(WordCloudFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a word cloud visual.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a word cloud visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(WordCloudSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a word cloud visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WordCloudSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link WordCloudSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WordCloudSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(WordCloudSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link WordCloudSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(WordCloudSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<WordCloudSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(WordCloudSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) for the word cloud category.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) for the word cloud
         *        category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) for the word cloud category.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The options for a word cloud visual.
         * </p>
         * 
         * @param wordCloudOptions
         *        The options for a word cloud visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordCloudOptions(WordCloudOptions wordCloudOptions);

        /**
         * <p>
         * The options for a word cloud visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WordCloudOptions.Builder} avoiding the
         * need to create one manually via {@link WordCloudOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WordCloudOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #wordCloudOptions(WordCloudOptions)}.
         * 
         * @param wordCloudOptions
         *        a consumer that will call methods on {@link WordCloudOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordCloudOptions(WordCloudOptions)
         */
        default Builder wordCloudOptions(Consumer<WordCloudOptions.Builder> wordCloudOptions) {
            return wordCloudOptions(WordCloudOptions.builder().applyMutation(wordCloudOptions).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WordCloudFieldWells fieldWells;

        private WordCloudSortConfiguration sortConfiguration;

        private ChartAxisLabelOptions categoryLabelOptions;

        private WordCloudOptions wordCloudOptions;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(WordCloudChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            categoryLabelOptions(model.categoryLabelOptions);
            wordCloudOptions(model.wordCloudOptions);
            interactions(model.interactions);
        }

        public final WordCloudFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(WordCloudFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(WordCloudFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final WordCloudSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(WordCloudSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(WordCloudSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final WordCloudOptions.Builder getWordCloudOptions() {
            return wordCloudOptions != null ? wordCloudOptions.toBuilder() : null;
        }

        public final void setWordCloudOptions(WordCloudOptions.BuilderImpl wordCloudOptions) {
            this.wordCloudOptions = wordCloudOptions != null ? wordCloudOptions.build() : null;
        }

        @Override
        public final Builder wordCloudOptions(WordCloudOptions wordCloudOptions) {
            this.wordCloudOptions = wordCloudOptions;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public WordCloudChartConfiguration build() {
            return new WordCloudChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
