/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSpiceCapacityConfigurationRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateSpiceCapacityConfigurationRequest.Builder, UpdateSpiceCapacityConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateSpiceCapacityConfigurationRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> PURCHASE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PurchaseMode").getter(getter(UpdateSpiceCapacityConfigurationRequest::purchaseModeAsString))
            .setter(setter(Builder::purchaseMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            PURCHASE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String purchaseMode;

    private UpdateSpiceCapacityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.purchaseMode = builder.purchaseMode;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the SPICE configuration that you want to update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the SPICE configuration that you want to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * Determines how SPICE capacity can be purchased. The following options are available.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MANUAL</code>: SPICE capacity can only be purchased manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed. SPICE
     * capacity can also be purchased manually with this option.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseMode} will
     * return {@link PurchaseMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #purchaseModeAsString}.
     * </p>
     * 
     * @return Determines how SPICE capacity can be purchased. The following options are available. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MANUAL</code>: SPICE capacity can only be purchased manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed.
     *         SPICE capacity can also be purchased manually with this option.
     *         </p>
     *         </li>
     * @see PurchaseMode
     */
    public final PurchaseMode purchaseMode() {
        return PurchaseMode.fromValue(purchaseMode);
    }

    /**
     * <p>
     * Determines how SPICE capacity can be purchased. The following options are available.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MANUAL</code>: SPICE capacity can only be purchased manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed. SPICE
     * capacity can also be purchased manually with this option.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseMode} will
     * return {@link PurchaseMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #purchaseModeAsString}.
     * </p>
     * 
     * @return Determines how SPICE capacity can be purchased. The following options are available. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MANUAL</code>: SPICE capacity can only be purchased manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed.
     *         SPICE capacity can also be purchased manually with this option.
     *         </p>
     *         </li>
     * @see PurchaseMode
     */
    public final String purchaseModeAsString() {
        return purchaseMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpiceCapacityConfigurationRequest)) {
            return false;
        }
        UpdateSpiceCapacityConfigurationRequest other = (UpdateSpiceCapacityConfigurationRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(purchaseModeAsString(), other.purchaseModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSpiceCapacityConfigurationRequest").add("AwsAccountId", awsAccountId())
                .add("PurchaseMode", purchaseModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "PurchaseMode":
            return Optional.ofNullable(clazz.cast(purchaseModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("PurchaseMode", PURCHASE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpiceCapacityConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSpiceCapacityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSpiceCapacityConfigurationRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the SPICE configuration that you want to update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the SPICE configuration that you want to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * Determines how SPICE capacity can be purchased. The following options are available.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MANUAL</code>: SPICE capacity can only be purchased manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed. SPICE
         * capacity can also be purchased manually with this option.
         * </p>
         * </li>
         * </ul>
         * 
         * @param purchaseMode
         *        Determines how SPICE capacity can be purchased. The following options are available. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MANUAL</code>: SPICE capacity can only be purchased manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed.
         *        SPICE capacity can also be purchased manually with this option.
         *        </p>
         *        </li>
         * @see PurchaseMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseMode
         */
        Builder purchaseMode(String purchaseMode);

        /**
         * <p>
         * Determines how SPICE capacity can be purchased. The following options are available.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MANUAL</code>: SPICE capacity can only be purchased manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed. SPICE
         * capacity can also be purchased manually with this option.
         * </p>
         * </li>
         * </ul>
         * 
         * @param purchaseMode
         *        Determines how SPICE capacity can be purchased. The following options are available. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MANUAL</code>: SPICE capacity can only be purchased manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed.
         *        SPICE capacity can also be purchased manually with this option.
         *        </p>
         *        </li>
         * @see PurchaseMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseMode
         */
        Builder purchaseMode(PurchaseMode purchaseMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String purchaseMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpiceCapacityConfigurationRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            purchaseMode(model.purchaseMode);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getPurchaseMode() {
            return purchaseMode;
        }

        public final void setPurchaseMode(String purchaseMode) {
            this.purchaseMode = purchaseMode;
        }

        @Override
        public final Builder purchaseMode(String purchaseMode) {
            this.purchaseMode = purchaseMode;
            return this;
        }

        @Override
        public final Builder purchaseMode(PurchaseMode purchaseMode) {
            this.purchaseMode(purchaseMode == null ? null : purchaseMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpiceCapacityConfigurationRequest build() {
            return new UpdateSpiceCapacityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
