/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIpRestrictionRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateIpRestrictionRequest.Builder, UpdateIpRestrictionRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateIpRestrictionRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<Map<String, String>> IP_RESTRICTION_RULE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("IpRestrictionRuleMap")
            .getter(getter(UpdateIpRestrictionRequest::ipRestrictionRuleMap))
            .setter(setter(Builder::ipRestrictionRuleMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRestrictionRuleMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VPC_ID_RESTRICTION_RULE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("VpcIdRestrictionRuleMap")
            .getter(getter(UpdateIpRestrictionRequest::vpcIdRestrictionRuleMap))
            .setter(setter(Builder::vpcIdRestrictionRuleMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIdRestrictionRuleMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VPC_ENDPOINT_ID_RESTRICTION_RULE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("VpcEndpointIdRestrictionRuleMap")
            .getter(getter(UpdateIpRestrictionRequest::vpcEndpointIdRestrictionRuleMap))
            .setter(setter(Builder::vpcEndpointIdRestrictionRuleMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointIdRestrictionRuleMap")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UpdateIpRestrictionRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            IP_RESTRICTION_RULE_MAP_FIELD, VPC_ID_RESTRICTION_RULE_MAP_FIELD, VPC_ENDPOINT_ID_RESTRICTION_RULE_MAP_FIELD,
            ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final Map<String, String> ipRestrictionRuleMap;

    private final Map<String, String> vpcIdRestrictionRuleMap;

    private final Map<String, String> vpcEndpointIdRestrictionRuleMap;

    private final Boolean enabled;

    private UpdateIpRestrictionRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.ipRestrictionRuleMap = builder.ipRestrictionRuleMap;
        this.vpcIdRestrictionRuleMap = builder.vpcIdRestrictionRuleMap;
        this.vpcEndpointIdRestrictionRuleMap = builder.vpcEndpointIdRestrictionRuleMap;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the IP rules.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the IP rules.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpRestrictionRuleMap property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpRestrictionRuleMap() {
        return ipRestrictionRuleMap != null && !(ipRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that describes the updated IP rules with CIDR ranges and descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpRestrictionRuleMap} method.
     * </p>
     * 
     * @return A map that describes the updated IP rules with CIDR ranges and descriptions.
     */
    public final Map<String, String> ipRestrictionRuleMap() {
        return ipRestrictionRuleMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcIdRestrictionRuleMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcIdRestrictionRuleMap() {
        return vpcIdRestrictionRuleMap != null && !(vpcIdRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of VPC IDs and their corresponding rules. When you configure this parameter, traffic from all VPC endpoints
     * that are present in the specified VPC is allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcIdRestrictionRuleMap} method.
     * </p>
     * 
     * @return A map of VPC IDs and their corresponding rules. When you configure this parameter, traffic from all VPC
     *         endpoints that are present in the specified VPC is allowed.
     */
    public final Map<String, String> vpcIdRestrictionRuleMap() {
        return vpcIdRestrictionRuleMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointIdRestrictionRuleMap
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasVpcEndpointIdRestrictionRuleMap() {
        return vpcEndpointIdRestrictionRuleMap != null && !(vpcEndpointIdRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of allowed VPC endpoint IDs and their corresponding rule descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointIdRestrictionRuleMap}
     * method.
     * </p>
     * 
     * @return A map of allowed VPC endpoint IDs and their corresponding rule descriptions.
     */
    public final Map<String, String> vpcEndpointIdRestrictionRuleMap() {
        return vpcEndpointIdRestrictionRuleMap;
    }

    /**
     * <p>
     * A value that specifies whether IP rules are turned on.
     * </p>
     * 
     * @return A value that specifies whether IP rules are turned on.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRestrictionRuleMap() ? ipRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcIdRestrictionRuleMap() ? vpcIdRestrictionRuleMap() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasVpcEndpointIdRestrictionRuleMap() ? vpcEndpointIdRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpRestrictionRequest)) {
            return false;
        }
        UpdateIpRestrictionRequest other = (UpdateIpRestrictionRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && hasIpRestrictionRuleMap() == other.hasIpRestrictionRuleMap()
                && Objects.equals(ipRestrictionRuleMap(), other.ipRestrictionRuleMap())
                && hasVpcIdRestrictionRuleMap() == other.hasVpcIdRestrictionRuleMap()
                && Objects.equals(vpcIdRestrictionRuleMap(), other.vpcIdRestrictionRuleMap())
                && hasVpcEndpointIdRestrictionRuleMap() == other.hasVpcEndpointIdRestrictionRuleMap()
                && Objects.equals(vpcEndpointIdRestrictionRuleMap(), other.vpcEndpointIdRestrictionRuleMap())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateIpRestrictionRequest")
                .add("AwsAccountId", awsAccountId())
                .add("IpRestrictionRuleMap", hasIpRestrictionRuleMap() ? ipRestrictionRuleMap() : null)
                .add("VpcIdRestrictionRuleMap", hasVpcIdRestrictionRuleMap() ? vpcIdRestrictionRuleMap() : null)
                .add("VpcEndpointIdRestrictionRuleMap",
                        hasVpcEndpointIdRestrictionRuleMap() ? vpcEndpointIdRestrictionRuleMap() : null)
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "IpRestrictionRuleMap":
            return Optional.ofNullable(clazz.cast(ipRestrictionRuleMap()));
        case "VpcIdRestrictionRuleMap":
            return Optional.ofNullable(clazz.cast(vpcIdRestrictionRuleMap()));
        case "VpcEndpointIdRestrictionRuleMap":
            return Optional.ofNullable(clazz.cast(vpcEndpointIdRestrictionRuleMap()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("IpRestrictionRuleMap", IP_RESTRICTION_RULE_MAP_FIELD);
        map.put("VpcIdRestrictionRuleMap", VPC_ID_RESTRICTION_RULE_MAP_FIELD);
        map.put("VpcEndpointIdRestrictionRuleMap", VPC_ENDPOINT_ID_RESTRICTION_RULE_MAP_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpRestrictionRequest, T> g) {
        return obj -> g.apply((UpdateIpRestrictionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIpRestrictionRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the IP rules.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the IP rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A map that describes the updated IP rules with CIDR ranges and descriptions.
         * </p>
         * 
         * @param ipRestrictionRuleMap
         *        A map that describes the updated IP rules with CIDR ranges and descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap);

        /**
         * <p>
         * A map of VPC IDs and their corresponding rules. When you configure this parameter, traffic from all VPC
         * endpoints that are present in the specified VPC is allowed.
         * </p>
         * 
         * @param vpcIdRestrictionRuleMap
         *        A map of VPC IDs and their corresponding rules. When you configure this parameter, traffic from all
         *        VPC endpoints that are present in the specified VPC is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIdRestrictionRuleMap(Map<String, String> vpcIdRestrictionRuleMap);

        /**
         * <p>
         * A map of allowed VPC endpoint IDs and their corresponding rule descriptions.
         * </p>
         * 
         * @param vpcEndpointIdRestrictionRuleMap
         *        A map of allowed VPC endpoint IDs and their corresponding rule descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIdRestrictionRuleMap(Map<String, String> vpcEndpointIdRestrictionRuleMap);

        /**
         * <p>
         * A value that specifies whether IP rules are turned on.
         * </p>
         * 
         * @param enabled
         *        A value that specifies whether IP rules are turned on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private Map<String, String> ipRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> vpcIdRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> vpcEndpointIdRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpRestrictionRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            ipRestrictionRuleMap(model.ipRestrictionRuleMap);
            vpcIdRestrictionRuleMap(model.vpcIdRestrictionRuleMap);
            vpcEndpointIdRestrictionRuleMap(model.vpcEndpointIdRestrictionRuleMap);
            enabled(model.enabled);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Map<String, String> getIpRestrictionRuleMap() {
            if (ipRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return ipRestrictionRuleMap;
        }

        public final void setIpRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
        }

        @Override
        public final Builder ipRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
            return this;
        }

        public final Map<String, String> getVpcIdRestrictionRuleMap() {
            if (vpcIdRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return vpcIdRestrictionRuleMap;
        }

        public final void setVpcIdRestrictionRuleMap(Map<String, String> vpcIdRestrictionRuleMap) {
            this.vpcIdRestrictionRuleMap = VpcIdRestrictionRuleMapCopier.copy(vpcIdRestrictionRuleMap);
        }

        @Override
        public final Builder vpcIdRestrictionRuleMap(Map<String, String> vpcIdRestrictionRuleMap) {
            this.vpcIdRestrictionRuleMap = VpcIdRestrictionRuleMapCopier.copy(vpcIdRestrictionRuleMap);
            return this;
        }

        public final Map<String, String> getVpcEndpointIdRestrictionRuleMap() {
            if (vpcEndpointIdRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return vpcEndpointIdRestrictionRuleMap;
        }

        public final void setVpcEndpointIdRestrictionRuleMap(Map<String, String> vpcEndpointIdRestrictionRuleMap) {
            this.vpcEndpointIdRestrictionRuleMap = VpcEndpointIdRestrictionRuleMapCopier.copy(vpcEndpointIdRestrictionRuleMap);
        }

        @Override
        public final Builder vpcEndpointIdRestrictionRuleMap(Map<String, String> vpcEndpointIdRestrictionRuleMap) {
            this.vpcEndpointIdRestrictionRuleMap = VpcEndpointIdRestrictionRuleMapCopier.copy(vpcEndpointIdRestrictionRuleMap);
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpRestrictionRequest build() {
            return new UpdateIpRestrictionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
