/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration of a tree map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TreeMapSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TreeMapSortConfiguration.Builder, TreeMapSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> TREE_MAP_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("TreeMapSort")
            .getter(getter(TreeMapSortConfiguration::treeMapSort))
            .setter(setter(Builder::treeMapSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreeMapSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ItemsLimitConfiguration> TREE_MAP_GROUP_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TreeMapGroupItemsLimitConfiguration")
            .getter(getter(TreeMapSortConfiguration::treeMapGroupItemsLimitConfiguration))
            .setter(setter(Builder::treeMapGroupItemsLimitConfiguration))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TreeMapGroupItemsLimitConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TREE_MAP_SORT_FIELD,
            TREE_MAP_GROUP_ITEMS_LIMIT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> treeMapSort;

    private final ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration;

    private TreeMapSortConfiguration(BuilderImpl builder) {
        this.treeMapSort = builder.treeMapSort;
        this.treeMapGroupItemsLimitConfiguration = builder.treeMapGroupItemsLimitConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the TreeMapSort property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTreeMapSort() {
        return treeMapSort != null && !(treeMapSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sort configuration of group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTreeMapSort} method.
     * </p>
     * 
     * @return The sort configuration of group by fields.
     */
    public final List<FieldSortOptions> treeMapSort() {
        return treeMapSort;
    }

    /**
     * <p>
     * The limit on the number of groups that are displayed.
     * </p>
     * 
     * @return The limit on the number of groups that are displayed.
     */
    public final ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration() {
        return treeMapGroupItemsLimitConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTreeMapSort() ? treeMapSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(treeMapGroupItemsLimitConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreeMapSortConfiguration)) {
            return false;
        }
        TreeMapSortConfiguration other = (TreeMapSortConfiguration) obj;
        return hasTreeMapSort() == other.hasTreeMapSort() && Objects.equals(treeMapSort(), other.treeMapSort())
                && Objects.equals(treeMapGroupItemsLimitConfiguration(), other.treeMapGroupItemsLimitConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TreeMapSortConfiguration").add("TreeMapSort", hasTreeMapSort() ? treeMapSort() : null)
                .add("TreeMapGroupItemsLimitConfiguration", treeMapGroupItemsLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TreeMapSort":
            return Optional.ofNullable(clazz.cast(treeMapSort()));
        case "TreeMapGroupItemsLimitConfiguration":
            return Optional.ofNullable(clazz.cast(treeMapGroupItemsLimitConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TreeMapSort", TREE_MAP_SORT_FIELD);
        map.put("TreeMapGroupItemsLimitConfiguration", TREE_MAP_GROUP_ITEMS_LIMIT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TreeMapSortConfiguration, T> g) {
        return obj -> g.apply((TreeMapSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TreeMapSortConfiguration> {
        /**
         * <p>
         * The sort configuration of group by fields.
         * </p>
         * 
         * @param treeMapSort
         *        The sort configuration of group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeMapSort(Collection<FieldSortOptions> treeMapSort);

        /**
         * <p>
         * The sort configuration of group by fields.
         * </p>
         * 
         * @param treeMapSort
         *        The sort configuration of group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeMapSort(FieldSortOptions... treeMapSort);

        /**
         * <p>
         * The sort configuration of group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #treeMapSort(List<FieldSortOptions>)}.
         * 
         * @param treeMapSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #treeMapSort(java.util.Collection<FieldSortOptions>)
         */
        Builder treeMapSort(Consumer<FieldSortOptions.Builder>... treeMapSort);

        /**
         * <p>
         * The limit on the number of groups that are displayed.
         * </p>
         * 
         * @param treeMapGroupItemsLimitConfiguration
         *        The limit on the number of groups that are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration);

        /**
         * <p>
         * The limit on the number of groups that are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration)}.
         * 
         * @param treeMapGroupItemsLimitConfiguration
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration)
         */
        default Builder treeMapGroupItemsLimitConfiguration(
                Consumer<ItemsLimitConfiguration.Builder> treeMapGroupItemsLimitConfiguration) {
            return treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration.builder()
                    .applyMutation(treeMapGroupItemsLimitConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> treeMapSort = DefaultSdkAutoConstructList.getInstance();

        private ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TreeMapSortConfiguration model) {
            treeMapSort(model.treeMapSort);
            treeMapGroupItemsLimitConfiguration(model.treeMapGroupItemsLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getTreeMapSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.treeMapSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTreeMapSort(Collection<FieldSortOptions.BuilderImpl> treeMapSort) {
            this.treeMapSort = FieldSortOptionsListCopier.copyFromBuilder(treeMapSort);
        }

        @Override
        public final Builder treeMapSort(Collection<FieldSortOptions> treeMapSort) {
            this.treeMapSort = FieldSortOptionsListCopier.copy(treeMapSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treeMapSort(FieldSortOptions... treeMapSort) {
            treeMapSort(Arrays.asList(treeMapSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treeMapSort(Consumer<FieldSortOptions.Builder>... treeMapSort) {
            treeMapSort(Stream.of(treeMapSort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getTreeMapGroupItemsLimitConfiguration() {
            return treeMapGroupItemsLimitConfiguration != null ? treeMapGroupItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setTreeMapGroupItemsLimitConfiguration(
                ItemsLimitConfiguration.BuilderImpl treeMapGroupItemsLimitConfiguration) {
            this.treeMapGroupItemsLimitConfiguration = treeMapGroupItemsLimitConfiguration != null ? treeMapGroupItemsLimitConfiguration
                    .build() : null;
        }

        @Override
        public final Builder treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration) {
            this.treeMapGroupItemsLimitConfiguration = treeMapGroupItemsLimitConfiguration;
            return this;
        }

        @Override
        public TreeMapSortConfiguration build() {
            return new TreeMapSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
