/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deinition for a <code>TopicReviewedAnswer</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicReviewedAnswer implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicReviewedAnswer.Builder, TopicReviewedAnswer> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TopicReviewedAnswer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ANSWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnswerId").getter(getter(TopicReviewedAnswer::answerId)).setter(setter(Builder::answerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(TopicReviewedAnswer::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> QUESTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Question").getter(getter(TopicReviewedAnswer::question)).setter(setter(Builder::question))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()).build();

    private static final SdkField<TopicIR> MIR_FIELD = SdkField.<TopicIR> builder(MarshallingType.SDK_POJO).memberName("Mir")
            .getter(getter(TopicReviewedAnswer::mir)).setter(setter(Builder::mir)).constructor(TopicIR::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mir").build()).build();

    private static final SdkField<TopicVisual> PRIMARY_VISUAL_FIELD = SdkField.<TopicVisual> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryVisual").getter(getter(TopicReviewedAnswer::primaryVisual))
            .setter(setter(Builder::primaryVisual)).constructor(TopicVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryVisual").build()).build();

    private static final SdkField<TopicTemplate> TEMPLATE_FIELD = SdkField.<TopicTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("Template").getter(getter(TopicReviewedAnswer::template)).setter(setter(Builder::template))
            .constructor(TopicTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ANSWER_ID_FIELD,
            DATASET_ARN_FIELD, QUESTION_FIELD, MIR_FIELD, PRIMARY_VISUAL_FIELD, TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String answerId;

    private final String datasetArn;

    private final String question;

    private final TopicIR mir;

    private final TopicVisual primaryVisual;

    private final TopicTemplate template;

    private TopicReviewedAnswer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.answerId = builder.answerId;
        this.datasetArn = builder.datasetArn;
        this.question = builder.question;
        this.mir = builder.mir;
        this.primaryVisual = builder.primaryVisual;
        this.template = builder.template;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the reviewed answer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the reviewed answer.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The answer ID of the reviewed answer.
     * </p>
     * 
     * @return The answer ID of the reviewed answer.
     */
    public final String answerId() {
        return answerId;
    }

    /**
     * <p>
     * The Dataset ARN for the <code>TopicReviewedAnswer</code>.
     * </p>
     * 
     * @return The Dataset ARN for the <code>TopicReviewedAnswer</code>.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The question for the <code>TopicReviewedAnswer</code>.
     * </p>
     * 
     * @return The question for the <code>TopicReviewedAnswer</code>.
     */
    public final String question() {
        return question;
    }

    /**
     * <p>
     * The mir for the <code>TopicReviewedAnswer</code>.
     * </p>
     * 
     * @return The mir for the <code>TopicReviewedAnswer</code>.
     */
    public final TopicIR mir() {
        return mir;
    }

    /**
     * <p>
     * The primary visual for the <code>TopicReviewedAnswer</code>.
     * </p>
     * 
     * @return The primary visual for the <code>TopicReviewedAnswer</code>.
     */
    public final TopicVisual primaryVisual() {
        return primaryVisual;
    }

    /**
     * <p>
     * The template for the <code>TopicReviewedAnswer</code>.
     * </p>
     * 
     * @return The template for the <code>TopicReviewedAnswer</code>.
     */
    public final TopicTemplate template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(answerId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(question());
        hashCode = 31 * hashCode + Objects.hashCode(mir());
        hashCode = 31 * hashCode + Objects.hashCode(primaryVisual());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicReviewedAnswer)) {
            return false;
        }
        TopicReviewedAnswer other = (TopicReviewedAnswer) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(answerId(), other.answerId())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(question(), other.question())
                && Objects.equals(mir(), other.mir()) && Objects.equals(primaryVisual(), other.primaryVisual())
                && Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicReviewedAnswer").add("Arn", arn()).add("AnswerId", answerId())
                .add("DatasetArn", datasetArn()).add("Question", question()).add("Mir", mir())
                .add("PrimaryVisual", primaryVisual()).add("Template", template()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AnswerId":
            return Optional.ofNullable(clazz.cast(answerId()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "Question":
            return Optional.ofNullable(clazz.cast(question()));
        case "Mir":
            return Optional.ofNullable(clazz.cast(mir()));
        case "PrimaryVisual":
            return Optional.ofNullable(clazz.cast(primaryVisual()));
        case "Template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AnswerId", ANSWER_ID_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Question", QUESTION_FIELD);
        map.put("Mir", MIR_FIELD);
        map.put("PrimaryVisual", PRIMARY_VISUAL_FIELD);
        map.put("Template", TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicReviewedAnswer, T> g) {
        return obj -> g.apply((TopicReviewedAnswer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicReviewedAnswer> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the reviewed answer.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the reviewed answer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The answer ID of the reviewed answer.
         * </p>
         * 
         * @param answerId
         *        The answer ID of the reviewed answer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerId(String answerId);

        /**
         * <p>
         * The Dataset ARN for the <code>TopicReviewedAnswer</code>.
         * </p>
         * 
         * @param datasetArn
         *        The Dataset ARN for the <code>TopicReviewedAnswer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The question for the <code>TopicReviewedAnswer</code>.
         * </p>
         * 
         * @param question
         *        The question for the <code>TopicReviewedAnswer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder question(String question);

        /**
         * <p>
         * The mir for the <code>TopicReviewedAnswer</code>.
         * </p>
         * 
         * @param mir
         *        The mir for the <code>TopicReviewedAnswer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mir(TopicIR mir);

        /**
         * <p>
         * The mir for the <code>TopicReviewedAnswer</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicIR.Builder} avoiding the need to
         * create one manually via {@link TopicIR#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicIR.Builder#build()} is called immediately and its result is
         * passed to {@link #mir(TopicIR)}.
         * 
         * @param mir
         *        a consumer that will call methods on {@link TopicIR.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mir(TopicIR)
         */
        default Builder mir(Consumer<TopicIR.Builder> mir) {
            return mir(TopicIR.builder().applyMutation(mir).build());
        }

        /**
         * <p>
         * The primary visual for the <code>TopicReviewedAnswer</code>.
         * </p>
         * 
         * @param primaryVisual
         *        The primary visual for the <code>TopicReviewedAnswer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryVisual(TopicVisual primaryVisual);

        /**
         * <p>
         * The primary visual for the <code>TopicReviewedAnswer</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicVisual.Builder} avoiding the need to
         * create one manually via {@link TopicVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicVisual.Builder#build()} is called immediately and its result
         * is passed to {@link #primaryVisual(TopicVisual)}.
         * 
         * @param primaryVisual
         *        a consumer that will call methods on {@link TopicVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryVisual(TopicVisual)
         */
        default Builder primaryVisual(Consumer<TopicVisual.Builder> primaryVisual) {
            return primaryVisual(TopicVisual.builder().applyMutation(primaryVisual).build());
        }

        /**
         * <p>
         * The template for the <code>TopicReviewedAnswer</code>.
         * </p>
         * 
         * @param template
         *        The template for the <code>TopicReviewedAnswer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(TopicTemplate template);

        /**
         * <p>
         * The template for the <code>TopicReviewedAnswer</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicTemplate.Builder} avoiding the need
         * to create one manually via {@link TopicTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #template(TopicTemplate)}.
         * 
         * @param template
         *        a consumer that will call methods on {@link TopicTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #template(TopicTemplate)
         */
        default Builder template(Consumer<TopicTemplate.Builder> template) {
            return template(TopicTemplate.builder().applyMutation(template).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String answerId;

        private String datasetArn;

        private String question;

        private TopicIR mir;

        private TopicVisual primaryVisual;

        private TopicTemplate template;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicReviewedAnswer model) {
            arn(model.arn);
            answerId(model.answerId);
            datasetArn(model.datasetArn);
            question(model.question);
            mir(model.mir);
            primaryVisual(model.primaryVisual);
            template(model.template);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAnswerId() {
            return answerId;
        }

        public final void setAnswerId(String answerId) {
            this.answerId = answerId;
        }

        @Override
        public final Builder answerId(String answerId) {
            this.answerId = answerId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getQuestion() {
            return question;
        }

        public final void setQuestion(String question) {
            this.question = question;
        }

        @Override
        public final Builder question(String question) {
            this.question = question;
            return this;
        }

        public final TopicIR.Builder getMir() {
            return mir != null ? mir.toBuilder() : null;
        }

        public final void setMir(TopicIR.BuilderImpl mir) {
            this.mir = mir != null ? mir.build() : null;
        }

        @Override
        public final Builder mir(TopicIR mir) {
            this.mir = mir;
            return this;
        }

        public final TopicVisual.Builder getPrimaryVisual() {
            return primaryVisual != null ? primaryVisual.toBuilder() : null;
        }

        public final void setPrimaryVisual(TopicVisual.BuilderImpl primaryVisual) {
            this.primaryVisual = primaryVisual != null ? primaryVisual.build() : null;
        }

        @Override
        public final Builder primaryVisual(TopicVisual primaryVisual) {
            this.primaryVisual = primaryVisual;
            return this;
        }

        public final TopicTemplate.Builder getTemplate() {
            return template != null ? template.toBuilder() : null;
        }

        public final void setTemplate(TopicTemplate.BuilderImpl template) {
            this.template = template != null ? template.build() : null;
        }

        @Override
        public final Builder template(TopicTemplate template) {
            this.template = template;
            return this;
        }

        @Override
        public TopicReviewedAnswer build() {
            return new TopicReviewedAnswer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
