/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options for the visual tooltip.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TooltipOptions implements SdkPojo, Serializable, ToCopyableBuilder<TooltipOptions.Builder, TooltipOptions> {
    private static final SdkField<String> TOOLTIP_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TooltipVisibility").getter(getter(TooltipOptions::tooltipVisibilityAsString))
            .setter(setter(Builder::tooltipVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipVisibility").build()).build();

    private static final SdkField<String> SELECTED_TOOLTIP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectedTooltipType").getter(getter(TooltipOptions::selectedTooltipTypeAsString))
            .setter(setter(Builder::selectedTooltipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedTooltipType").build())
            .build();

    private static final SdkField<FieldBasedTooltip> FIELD_BASED_TOOLTIP_FIELD = SdkField
            .<FieldBasedTooltip> builder(MarshallingType.SDK_POJO).memberName("FieldBasedTooltip")
            .getter(getter(TooltipOptions::fieldBasedTooltip)).setter(setter(Builder::fieldBasedTooltip))
            .constructor(FieldBasedTooltip::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldBasedTooltip").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOLTIP_VISIBILITY_FIELD,
            SELECTED_TOOLTIP_TYPE_FIELD, FIELD_BASED_TOOLTIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tooltipVisibility;

    private final String selectedTooltipType;

    private final FieldBasedTooltip fieldBasedTooltip;

    private TooltipOptions(BuilderImpl builder) {
        this.tooltipVisibility = builder.tooltipVisibility;
        this.selectedTooltipType = builder.selectedTooltipType;
        this.fieldBasedTooltip = builder.fieldBasedTooltip;
    }

    /**
     * <p>
     * Determines whether or not the tooltip is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tooltipVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tooltipVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the tooltip is visible.
     * @see Visibility
     */
    public final Visibility tooltipVisibility() {
        return Visibility.fromValue(tooltipVisibility);
    }

    /**
     * <p>
     * Determines whether or not the tooltip is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tooltipVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tooltipVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the tooltip is visible.
     * @see Visibility
     */
    public final String tooltipVisibilityAsString() {
        return tooltipVisibility;
    }

    /**
     * <p>
     * The selected type for the tooltip. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BASIC</code>: A basic tooltip.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETAILED</code>: A detailed tooltip.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectedTooltipType} will return {@link SelectedTooltipType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #selectedTooltipTypeAsString}.
     * </p>
     * 
     * @return The selected type for the tooltip. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: A basic tooltip.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETAILED</code>: A detailed tooltip.
     *         </p>
     *         </li>
     * @see SelectedTooltipType
     */
    public final SelectedTooltipType selectedTooltipType() {
        return SelectedTooltipType.fromValue(selectedTooltipType);
    }

    /**
     * <p>
     * The selected type for the tooltip. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BASIC</code>: A basic tooltip.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETAILED</code>: A detailed tooltip.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectedTooltipType} will return {@link SelectedTooltipType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #selectedTooltipTypeAsString}.
     * </p>
     * 
     * @return The selected type for the tooltip. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: A basic tooltip.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETAILED</code>: A detailed tooltip.
     *         </p>
     *         </li>
     * @see SelectedTooltipType
     */
    public final String selectedTooltipTypeAsString() {
        return selectedTooltipType;
    }

    /**
     * <p>
     * The setup for the detailed tooltip. The tooltip setup is always saved. The display type is decided based on the
     * tooltip type.
     * </p>
     * 
     * @return The setup for the detailed tooltip. The tooltip setup is always saved. The display type is decided based
     *         on the tooltip type.
     */
    public final FieldBasedTooltip fieldBasedTooltip() {
        return fieldBasedTooltip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tooltipVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectedTooltipTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldBasedTooltip());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TooltipOptions)) {
            return false;
        }
        TooltipOptions other = (TooltipOptions) obj;
        return Objects.equals(tooltipVisibilityAsString(), other.tooltipVisibilityAsString())
                && Objects.equals(selectedTooltipTypeAsString(), other.selectedTooltipTypeAsString())
                && Objects.equals(fieldBasedTooltip(), other.fieldBasedTooltip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TooltipOptions").add("TooltipVisibility", tooltipVisibilityAsString())
                .add("SelectedTooltipType", selectedTooltipTypeAsString()).add("FieldBasedTooltip", fieldBasedTooltip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TooltipVisibility":
            return Optional.ofNullable(clazz.cast(tooltipVisibilityAsString()));
        case "SelectedTooltipType":
            return Optional.ofNullable(clazz.cast(selectedTooltipTypeAsString()));
        case "FieldBasedTooltip":
            return Optional.ofNullable(clazz.cast(fieldBasedTooltip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TooltipVisibility", TOOLTIP_VISIBILITY_FIELD);
        map.put("SelectedTooltipType", SELECTED_TOOLTIP_TYPE_FIELD);
        map.put("FieldBasedTooltip", FIELD_BASED_TOOLTIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TooltipOptions, T> g) {
        return obj -> g.apply((TooltipOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TooltipOptions> {
        /**
         * <p>
         * Determines whether or not the tooltip is visible.
         * </p>
         * 
         * @param tooltipVisibility
         *        Determines whether or not the tooltip is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder tooltipVisibility(String tooltipVisibility);

        /**
         * <p>
         * Determines whether or not the tooltip is visible.
         * </p>
         * 
         * @param tooltipVisibility
         *        Determines whether or not the tooltip is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder tooltipVisibility(Visibility tooltipVisibility);

        /**
         * <p>
         * The selected type for the tooltip. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BASIC</code>: A basic tooltip.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETAILED</code>: A detailed tooltip.
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectedTooltipType
         *        The selected type for the tooltip. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: A basic tooltip.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETAILED</code>: A detailed tooltip.
         *        </p>
         *        </li>
         * @see SelectedTooltipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectedTooltipType
         */
        Builder selectedTooltipType(String selectedTooltipType);

        /**
         * <p>
         * The selected type for the tooltip. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BASIC</code>: A basic tooltip.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETAILED</code>: A detailed tooltip.
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectedTooltipType
         *        The selected type for the tooltip. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: A basic tooltip.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETAILED</code>: A detailed tooltip.
         *        </p>
         *        </li>
         * @see SelectedTooltipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectedTooltipType
         */
        Builder selectedTooltipType(SelectedTooltipType selectedTooltipType);

        /**
         * <p>
         * The setup for the detailed tooltip. The tooltip setup is always saved. The display type is decided based on
         * the tooltip type.
         * </p>
         * 
         * @param fieldBasedTooltip
         *        The setup for the detailed tooltip. The tooltip setup is always saved. The display type is decided
         *        based on the tooltip type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldBasedTooltip(FieldBasedTooltip fieldBasedTooltip);

        /**
         * <p>
         * The setup for the detailed tooltip. The tooltip setup is always saved. The display type is decided based on
         * the tooltip type.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldBasedTooltip.Builder} avoiding the
         * need to create one manually via {@link FieldBasedTooltip#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldBasedTooltip.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldBasedTooltip(FieldBasedTooltip)}.
         * 
         * @param fieldBasedTooltip
         *        a consumer that will call methods on {@link FieldBasedTooltip.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldBasedTooltip(FieldBasedTooltip)
         */
        default Builder fieldBasedTooltip(Consumer<FieldBasedTooltip.Builder> fieldBasedTooltip) {
            return fieldBasedTooltip(FieldBasedTooltip.builder().applyMutation(fieldBasedTooltip).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tooltipVisibility;

        private String selectedTooltipType;

        private FieldBasedTooltip fieldBasedTooltip;

        private BuilderImpl() {
        }

        private BuilderImpl(TooltipOptions model) {
            tooltipVisibility(model.tooltipVisibility);
            selectedTooltipType(model.selectedTooltipType);
            fieldBasedTooltip(model.fieldBasedTooltip);
        }

        public final String getTooltipVisibility() {
            return tooltipVisibility;
        }

        public final void setTooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
        }

        @Override
        public final Builder tooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
            return this;
        }

        @Override
        public final Builder tooltipVisibility(Visibility tooltipVisibility) {
            this.tooltipVisibility(tooltipVisibility == null ? null : tooltipVisibility.toString());
            return this;
        }

        public final String getSelectedTooltipType() {
            return selectedTooltipType;
        }

        public final void setSelectedTooltipType(String selectedTooltipType) {
            this.selectedTooltipType = selectedTooltipType;
        }

        @Override
        public final Builder selectedTooltipType(String selectedTooltipType) {
            this.selectedTooltipType = selectedTooltipType;
            return this;
        }

        @Override
        public final Builder selectedTooltipType(SelectedTooltipType selectedTooltipType) {
            this.selectedTooltipType(selectedTooltipType == null ? null : selectedTooltipType.toString());
            return this;
        }

        public final FieldBasedTooltip.Builder getFieldBasedTooltip() {
            return fieldBasedTooltip != null ? fieldBasedTooltip.toBuilder() : null;
        }

        public final void setFieldBasedTooltip(FieldBasedTooltip.BuilderImpl fieldBasedTooltip) {
            this.fieldBasedTooltip = fieldBasedTooltip != null ? fieldBasedTooltip.build() : null;
        }

        @Override
        public final Builder fieldBasedTooltip(FieldBasedTooltip fieldBasedTooltip) {
            this.fieldBasedTooltip = fieldBasedTooltip;
            return this;
        }

        @Override
        public TooltipOptions build() {
            return new TooltipOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
