/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The theme configuration. This configuration contains all of the display properties for a theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThemeConfiguration.Builder, ThemeConfiguration> {
    private static final SdkField<DataColorPalette> DATA_COLOR_PALETTE_FIELD = SdkField
            .<DataColorPalette> builder(MarshallingType.SDK_POJO).memberName("DataColorPalette")
            .getter(getter(ThemeConfiguration::dataColorPalette)).setter(setter(Builder::dataColorPalette))
            .constructor(DataColorPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataColorPalette").build()).build();

    private static final SdkField<UIColorPalette> UI_COLOR_PALETTE_FIELD = SdkField
            .<UIColorPalette> builder(MarshallingType.SDK_POJO).memberName("UIColorPalette")
            .getter(getter(ThemeConfiguration::uiColorPalette)).setter(setter(Builder::uiColorPalette))
            .constructor(UIColorPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UIColorPalette").build()).build();

    private static final SdkField<SheetStyle> SHEET_FIELD = SdkField.<SheetStyle> builder(MarshallingType.SDK_POJO)
            .memberName("Sheet").getter(getter(ThemeConfiguration::sheet)).setter(setter(Builder::sheet))
            .constructor(SheetStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheet").build()).build();

    private static final SdkField<Typography> TYPOGRAPHY_FIELD = SdkField.<Typography> builder(MarshallingType.SDK_POJO)
            .memberName("Typography").getter(getter(ThemeConfiguration::typography)).setter(setter(Builder::typography))
            .constructor(Typography::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Typography").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_COLOR_PALETTE_FIELD,
            UI_COLOR_PALETTE_FIELD, SHEET_FIELD, TYPOGRAPHY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataColorPalette dataColorPalette;

    private final UIColorPalette uiColorPalette;

    private final SheetStyle sheet;

    private final Typography typography;

    private ThemeConfiguration(BuilderImpl builder) {
        this.dataColorPalette = builder.dataColorPalette;
        this.uiColorPalette = builder.uiColorPalette;
        this.sheet = builder.sheet;
        this.typography = builder.typography;
    }

    /**
     * <p>
     * Color properties that apply to chart data colors.
     * </p>
     * 
     * @return Color properties that apply to chart data colors.
     */
    public final DataColorPalette dataColorPalette() {
        return dataColorPalette;
    }

    /**
     * <p>
     * Color properties that apply to the UI and to charts, excluding the colors that apply to data.
     * </p>
     * 
     * @return Color properties that apply to the UI and to charts, excluding the colors that apply to data.
     */
    public final UIColorPalette uiColorPalette() {
        return uiColorPalette;
    }

    /**
     * <p>
     * Display options related to sheets.
     * </p>
     * 
     * @return Display options related to sheets.
     */
    public final SheetStyle sheet() {
        return sheet;
    }

    /**
     * Returns the value of the Typography property for this object.
     * 
     * @return The value of the Typography property for this object.
     */
    public final Typography typography() {
        return typography;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataColorPalette());
        hashCode = 31 * hashCode + Objects.hashCode(uiColorPalette());
        hashCode = 31 * hashCode + Objects.hashCode(sheet());
        hashCode = 31 * hashCode + Objects.hashCode(typography());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeConfiguration)) {
            return false;
        }
        ThemeConfiguration other = (ThemeConfiguration) obj;
        return Objects.equals(dataColorPalette(), other.dataColorPalette())
                && Objects.equals(uiColorPalette(), other.uiColorPalette()) && Objects.equals(sheet(), other.sheet())
                && Objects.equals(typography(), other.typography());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeConfiguration").add("DataColorPalette", dataColorPalette())
                .add("UIColorPalette", uiColorPalette()).add("Sheet", sheet()).add("Typography", typography()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataColorPalette":
            return Optional.ofNullable(clazz.cast(dataColorPalette()));
        case "UIColorPalette":
            return Optional.ofNullable(clazz.cast(uiColorPalette()));
        case "Sheet":
            return Optional.ofNullable(clazz.cast(sheet()));
        case "Typography":
            return Optional.ofNullable(clazz.cast(typography()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataColorPalette", DATA_COLOR_PALETTE_FIELD);
        map.put("UIColorPalette", UI_COLOR_PALETTE_FIELD);
        map.put("Sheet", SHEET_FIELD);
        map.put("Typography", TYPOGRAPHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThemeConfiguration, T> g) {
        return obj -> g.apply((ThemeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeConfiguration> {
        /**
         * <p>
         * Color properties that apply to chart data colors.
         * </p>
         * 
         * @param dataColorPalette
         *        Color properties that apply to chart data colors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataColorPalette(DataColorPalette dataColorPalette);

        /**
         * <p>
         * Color properties that apply to chart data colors.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataColorPalette.Builder} avoiding the
         * need to create one manually via {@link DataColorPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataColorPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #dataColorPalette(DataColorPalette)}.
         * 
         * @param dataColorPalette
         *        a consumer that will call methods on {@link DataColorPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataColorPalette(DataColorPalette)
         */
        default Builder dataColorPalette(Consumer<DataColorPalette.Builder> dataColorPalette) {
            return dataColorPalette(DataColorPalette.builder().applyMutation(dataColorPalette).build());
        }

        /**
         * <p>
         * Color properties that apply to the UI and to charts, excluding the colors that apply to data.
         * </p>
         * 
         * @param uiColorPalette
         *        Color properties that apply to the UI and to charts, excluding the colors that apply to data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiColorPalette(UIColorPalette uiColorPalette);

        /**
         * <p>
         * Color properties that apply to the UI and to charts, excluding the colors that apply to data.
         * </p>
         * This is a convenience method that creates an instance of the {@link UIColorPalette.Builder} avoiding the need
         * to create one manually via {@link UIColorPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UIColorPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #uiColorPalette(UIColorPalette)}.
         * 
         * @param uiColorPalette
         *        a consumer that will call methods on {@link UIColorPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiColorPalette(UIColorPalette)
         */
        default Builder uiColorPalette(Consumer<UIColorPalette.Builder> uiColorPalette) {
            return uiColorPalette(UIColorPalette.builder().applyMutation(uiColorPalette).build());
        }

        /**
         * <p>
         * Display options related to sheets.
         * </p>
         * 
         * @param sheet
         *        Display options related to sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheet(SheetStyle sheet);

        /**
         * <p>
         * Display options related to sheets.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetStyle.Builder} avoiding the need to
         * create one manually via {@link SheetStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #sheet(SheetStyle)}.
         * 
         * @param sheet
         *        a consumer that will call methods on {@link SheetStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheet(SheetStyle)
         */
        default Builder sheet(Consumer<SheetStyle.Builder> sheet) {
            return sheet(SheetStyle.builder().applyMutation(sheet).build());
        }

        /**
         * Sets the value of the Typography property for this object.
         *
         * @param typography
         *        The new value for the Typography property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typography(Typography typography);

        /**
         * Sets the value of the Typography property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Typography.Builder} avoiding the need to
         * create one manually via {@link Typography#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Typography.Builder#build()} is called immediately and its result
         * is passed to {@link #typography(Typography)}.
         * 
         * @param typography
         *        a consumer that will call methods on {@link Typography.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typography(Typography)
         */
        default Builder typography(Consumer<Typography.Builder> typography) {
            return typography(Typography.builder().applyMutation(typography).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataColorPalette dataColorPalette;

        private UIColorPalette uiColorPalette;

        private SheetStyle sheet;

        private Typography typography;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeConfiguration model) {
            dataColorPalette(model.dataColorPalette);
            uiColorPalette(model.uiColorPalette);
            sheet(model.sheet);
            typography(model.typography);
        }

        public final DataColorPalette.Builder getDataColorPalette() {
            return dataColorPalette != null ? dataColorPalette.toBuilder() : null;
        }

        public final void setDataColorPalette(DataColorPalette.BuilderImpl dataColorPalette) {
            this.dataColorPalette = dataColorPalette != null ? dataColorPalette.build() : null;
        }

        @Override
        public final Builder dataColorPalette(DataColorPalette dataColorPalette) {
            this.dataColorPalette = dataColorPalette;
            return this;
        }

        public final UIColorPalette.Builder getUiColorPalette() {
            return uiColorPalette != null ? uiColorPalette.toBuilder() : null;
        }

        public final void setUiColorPalette(UIColorPalette.BuilderImpl uiColorPalette) {
            this.uiColorPalette = uiColorPalette != null ? uiColorPalette.build() : null;
        }

        @Override
        public final Builder uiColorPalette(UIColorPalette uiColorPalette) {
            this.uiColorPalette = uiColorPalette;
            return this;
        }

        public final SheetStyle.Builder getSheet() {
            return sheet != null ? sheet.toBuilder() : null;
        }

        public final void setSheet(SheetStyle.BuilderImpl sheet) {
            this.sheet = sheet != null ? sheet.build() : null;
        }

        @Override
        public final Builder sheet(SheetStyle sheet) {
            this.sheet = sheet;
            return this;
        }

        public final Typography.Builder getTypography() {
            return typography != null ? typography.toBuilder() : null;
        }

        public final void setTypography(Typography.BuilderImpl typography) {
            this.typography = typography != null ? typography.build() : null;
        }

        @Override
        public final Builder typography(Typography typography) {
            this.typography = typography;
            return this;
        }

        @Override
        public ThemeConfiguration build() {
            return new ThemeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
