/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The side border options for a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableSideBorderOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TableSideBorderOptions.Builder, TableSideBorderOptions> {
    private static final SdkField<TableBorderOptions> INNER_VERTICAL_FIELD = SdkField
            .<TableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("InnerVertical")
            .getter(getter(TableSideBorderOptions::innerVertical)).setter(setter(Builder::innerVertical))
            .constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InnerVertical").build()).build();

    private static final SdkField<TableBorderOptions> INNER_HORIZONTAL_FIELD = SdkField
            .<TableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("InnerHorizontal")
            .getter(getter(TableSideBorderOptions::innerHorizontal)).setter(setter(Builder::innerHorizontal))
            .constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InnerHorizontal").build()).build();

    private static final SdkField<TableBorderOptions> LEFT_FIELD = SdkField
            .<TableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("Left")
            .getter(getter(TableSideBorderOptions::left)).setter(setter(Builder::left)).constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Left").build()).build();

    private static final SdkField<TableBorderOptions> RIGHT_FIELD = SdkField
            .<TableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("Right")
            .getter(getter(TableSideBorderOptions::right)).setter(setter(Builder::right))
            .constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Right").build()).build();

    private static final SdkField<TableBorderOptions> TOP_FIELD = SdkField.<TableBorderOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Top").getter(getter(TableSideBorderOptions::top)).setter(setter(Builder::top))
            .constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Top").build()).build();

    private static final SdkField<TableBorderOptions> BOTTOM_FIELD = SdkField
            .<TableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("Bottom")
            .getter(getter(TableSideBorderOptions::bottom)).setter(setter(Builder::bottom))
            .constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bottom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INNER_VERTICAL_FIELD,
            INNER_HORIZONTAL_FIELD, LEFT_FIELD, RIGHT_FIELD, TOP_FIELD, BOTTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableBorderOptions innerVertical;

    private final TableBorderOptions innerHorizontal;

    private final TableBorderOptions left;

    private final TableBorderOptions right;

    private final TableBorderOptions top;

    private final TableBorderOptions bottom;

    private TableSideBorderOptions(BuilderImpl builder) {
        this.innerVertical = builder.innerVertical;
        this.innerHorizontal = builder.innerHorizontal;
        this.left = builder.left;
        this.right = builder.right;
        this.top = builder.top;
        this.bottom = builder.bottom;
    }

    /**
     * <p>
     * The table border options of the inner vertical border.
     * </p>
     * 
     * @return The table border options of the inner vertical border.
     */
    public final TableBorderOptions innerVertical() {
        return innerVertical;
    }

    /**
     * <p>
     * The table border options of the inner horizontal border.
     * </p>
     * 
     * @return The table border options of the inner horizontal border.
     */
    public final TableBorderOptions innerHorizontal() {
        return innerHorizontal;
    }

    /**
     * <p>
     * The table border options of the left border.
     * </p>
     * 
     * @return The table border options of the left border.
     */
    public final TableBorderOptions left() {
        return left;
    }

    /**
     * <p>
     * The table border options of the right border.
     * </p>
     * 
     * @return The table border options of the right border.
     */
    public final TableBorderOptions right() {
        return right;
    }

    /**
     * <p>
     * The table border options of the top border.
     * </p>
     * 
     * @return The table border options of the top border.
     */
    public final TableBorderOptions top() {
        return top;
    }

    /**
     * <p>
     * The table border options of the bottom border.
     * </p>
     * 
     * @return The table border options of the bottom border.
     */
    public final TableBorderOptions bottom() {
        return bottom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(innerVertical());
        hashCode = 31 * hashCode + Objects.hashCode(innerHorizontal());
        hashCode = 31 * hashCode + Objects.hashCode(left());
        hashCode = 31 * hashCode + Objects.hashCode(right());
        hashCode = 31 * hashCode + Objects.hashCode(top());
        hashCode = 31 * hashCode + Objects.hashCode(bottom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableSideBorderOptions)) {
            return false;
        }
        TableSideBorderOptions other = (TableSideBorderOptions) obj;
        return Objects.equals(innerVertical(), other.innerVertical())
                && Objects.equals(innerHorizontal(), other.innerHorizontal()) && Objects.equals(left(), other.left())
                && Objects.equals(right(), other.right()) && Objects.equals(top(), other.top())
                && Objects.equals(bottom(), other.bottom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableSideBorderOptions").add("InnerVertical", innerVertical())
                .add("InnerHorizontal", innerHorizontal()).add("Left", left()).add("Right", right()).add("Top", top())
                .add("Bottom", bottom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InnerVertical":
            return Optional.ofNullable(clazz.cast(innerVertical()));
        case "InnerHorizontal":
            return Optional.ofNullable(clazz.cast(innerHorizontal()));
        case "Left":
            return Optional.ofNullable(clazz.cast(left()));
        case "Right":
            return Optional.ofNullable(clazz.cast(right()));
        case "Top":
            return Optional.ofNullable(clazz.cast(top()));
        case "Bottom":
            return Optional.ofNullable(clazz.cast(bottom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InnerVertical", INNER_VERTICAL_FIELD);
        map.put("InnerHorizontal", INNER_HORIZONTAL_FIELD);
        map.put("Left", LEFT_FIELD);
        map.put("Right", RIGHT_FIELD);
        map.put("Top", TOP_FIELD);
        map.put("Bottom", BOTTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableSideBorderOptions, T> g) {
        return obj -> g.apply((TableSideBorderOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableSideBorderOptions> {
        /**
         * <p>
         * The table border options of the inner vertical border.
         * </p>
         * 
         * @param innerVertical
         *        The table border options of the inner vertical border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder innerVertical(TableBorderOptions innerVertical);

        /**
         * <p>
         * The table border options of the inner vertical border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #innerVertical(TableBorderOptions)}.
         * 
         * @param innerVertical
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #innerVertical(TableBorderOptions)
         */
        default Builder innerVertical(Consumer<TableBorderOptions.Builder> innerVertical) {
            return innerVertical(TableBorderOptions.builder().applyMutation(innerVertical).build());
        }

        /**
         * <p>
         * The table border options of the inner horizontal border.
         * </p>
         * 
         * @param innerHorizontal
         *        The table border options of the inner horizontal border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder innerHorizontal(TableBorderOptions innerHorizontal);

        /**
         * <p>
         * The table border options of the inner horizontal border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #innerHorizontal(TableBorderOptions)}.
         * 
         * @param innerHorizontal
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #innerHorizontal(TableBorderOptions)
         */
        default Builder innerHorizontal(Consumer<TableBorderOptions.Builder> innerHorizontal) {
            return innerHorizontal(TableBorderOptions.builder().applyMutation(innerHorizontal).build());
        }

        /**
         * <p>
         * The table border options of the left border.
         * </p>
         * 
         * @param left
         *        The table border options of the left border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder left(TableBorderOptions left);

        /**
         * <p>
         * The table border options of the left border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #left(TableBorderOptions)}.
         * 
         * @param left
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #left(TableBorderOptions)
         */
        default Builder left(Consumer<TableBorderOptions.Builder> left) {
            return left(TableBorderOptions.builder().applyMutation(left).build());
        }

        /**
         * <p>
         * The table border options of the right border.
         * </p>
         * 
         * @param right
         *        The table border options of the right border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder right(TableBorderOptions right);

        /**
         * <p>
         * The table border options of the right border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #right(TableBorderOptions)}.
         * 
         * @param right
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #right(TableBorderOptions)
         */
        default Builder right(Consumer<TableBorderOptions.Builder> right) {
            return right(TableBorderOptions.builder().applyMutation(right).build());
        }

        /**
         * <p>
         * The table border options of the top border.
         * </p>
         * 
         * @param top
         *        The table border options of the top border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder top(TableBorderOptions top);

        /**
         * <p>
         * The table border options of the top border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #top(TableBorderOptions)}.
         * 
         * @param top
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #top(TableBorderOptions)
         */
        default Builder top(Consumer<TableBorderOptions.Builder> top) {
            return top(TableBorderOptions.builder().applyMutation(top).build());
        }

        /**
         * <p>
         * The table border options of the bottom border.
         * </p>
         * 
         * @param bottom
         *        The table border options of the bottom border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bottom(TableBorderOptions bottom);

        /**
         * <p>
         * The table border options of the bottom border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #bottom(TableBorderOptions)}.
         * 
         * @param bottom
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bottom(TableBorderOptions)
         */
        default Builder bottom(Consumer<TableBorderOptions.Builder> bottom) {
            return bottom(TableBorderOptions.builder().applyMutation(bottom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableBorderOptions innerVertical;

        private TableBorderOptions innerHorizontal;

        private TableBorderOptions left;

        private TableBorderOptions right;

        private TableBorderOptions top;

        private TableBorderOptions bottom;

        private BuilderImpl() {
        }

        private BuilderImpl(TableSideBorderOptions model) {
            innerVertical(model.innerVertical);
            innerHorizontal(model.innerHorizontal);
            left(model.left);
            right(model.right);
            top(model.top);
            bottom(model.bottom);
        }

        public final TableBorderOptions.Builder getInnerVertical() {
            return innerVertical != null ? innerVertical.toBuilder() : null;
        }

        public final void setInnerVertical(TableBorderOptions.BuilderImpl innerVertical) {
            this.innerVertical = innerVertical != null ? innerVertical.build() : null;
        }

        @Override
        public final Builder innerVertical(TableBorderOptions innerVertical) {
            this.innerVertical = innerVertical;
            return this;
        }

        public final TableBorderOptions.Builder getInnerHorizontal() {
            return innerHorizontal != null ? innerHorizontal.toBuilder() : null;
        }

        public final void setInnerHorizontal(TableBorderOptions.BuilderImpl innerHorizontal) {
            this.innerHorizontal = innerHorizontal != null ? innerHorizontal.build() : null;
        }

        @Override
        public final Builder innerHorizontal(TableBorderOptions innerHorizontal) {
            this.innerHorizontal = innerHorizontal;
            return this;
        }

        public final TableBorderOptions.Builder getLeft() {
            return left != null ? left.toBuilder() : null;
        }

        public final void setLeft(TableBorderOptions.BuilderImpl left) {
            this.left = left != null ? left.build() : null;
        }

        @Override
        public final Builder left(TableBorderOptions left) {
            this.left = left;
            return this;
        }

        public final TableBorderOptions.Builder getRight() {
            return right != null ? right.toBuilder() : null;
        }

        public final void setRight(TableBorderOptions.BuilderImpl right) {
            this.right = right != null ? right.build() : null;
        }

        @Override
        public final Builder right(TableBorderOptions right) {
            this.right = right;
            return this;
        }

        public final TableBorderOptions.Builder getTop() {
            return top != null ? top.toBuilder() : null;
        }

        public final void setTop(TableBorderOptions.BuilderImpl top) {
            this.top = top != null ? top.build() : null;
        }

        @Override
        public final Builder top(TableBorderOptions top) {
            this.top = top;
            return this;
        }

        public final TableBorderOptions.Builder getBottom() {
            return bottom != null ? bottom.toBuilder() : null;
        }

        public final void setBottom(TableBorderOptions.BuilderImpl bottom) {
            this.bottom = bottom != null ? bottom.build() : null;
        }

        @Override
        public final Builder bottom(TableBorderOptions bottom) {
            this.bottom = bottom;
            return this;
        }

        @Override
        public TableSideBorderOptions build() {
            return new TableSideBorderOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
