/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Conditional formatting options for a <code>PivotTableVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableConditionalFormattingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<TableConditionalFormattingOption.Builder, TableConditionalFormattingOption> {
    private static final SdkField<TableCellConditionalFormatting> CELL_FIELD = SdkField
            .<TableCellConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("Cell")
            .getter(getter(TableConditionalFormattingOption::cell)).setter(setter(Builder::cell))
            .constructor(TableCellConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cell").build()).build();

    private static final SdkField<TableRowConditionalFormatting> ROW_FIELD = SdkField
            .<TableRowConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("Row")
            .getter(getter(TableConditionalFormattingOption::row)).setter(setter(Builder::row))
            .constructor(TableRowConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Row").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_FIELD, ROW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableCellConditionalFormatting cell;

    private final TableRowConditionalFormatting row;

    private TableConditionalFormattingOption(BuilderImpl builder) {
        this.cell = builder.cell;
        this.row = builder.row;
    }

    /**
     * <p>
     * The cell conditional formatting option for a table.
     * </p>
     * 
     * @return The cell conditional formatting option for a table.
     */
    public final TableCellConditionalFormatting cell() {
        return cell;
    }

    /**
     * <p>
     * The row conditional formatting option for a table.
     * </p>
     * 
     * @return The row conditional formatting option for a table.
     */
    public final TableRowConditionalFormatting row() {
        return row;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cell());
        hashCode = 31 * hashCode + Objects.hashCode(row());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableConditionalFormattingOption)) {
            return false;
        }
        TableConditionalFormattingOption other = (TableConditionalFormattingOption) obj;
        return Objects.equals(cell(), other.cell()) && Objects.equals(row(), other.row());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableConditionalFormattingOption").add("Cell", cell()).add("Row", row()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cell":
            return Optional.ofNullable(clazz.cast(cell()));
        case "Row":
            return Optional.ofNullable(clazz.cast(row()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cell", CELL_FIELD);
        map.put("Row", ROW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableConditionalFormattingOption, T> g) {
        return obj -> g.apply((TableConditionalFormattingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableConditionalFormattingOption> {
        /**
         * <p>
         * The cell conditional formatting option for a table.
         * </p>
         * 
         * @param cell
         *        The cell conditional formatting option for a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cell(TableCellConditionalFormatting cell);

        /**
         * <p>
         * The cell conditional formatting option for a table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellConditionalFormatting.Builder}
         * avoiding the need to create one manually via {@link TableCellConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #cell(TableCellConditionalFormatting)}.
         * 
         * @param cell
         *        a consumer that will call methods on {@link TableCellConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cell(TableCellConditionalFormatting)
         */
        default Builder cell(Consumer<TableCellConditionalFormatting.Builder> cell) {
            return cell(TableCellConditionalFormatting.builder().applyMutation(cell).build());
        }

        /**
         * <p>
         * The row conditional formatting option for a table.
         * </p>
         * 
         * @param row
         *        The row conditional formatting option for a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder row(TableRowConditionalFormatting row);

        /**
         * <p>
         * The row conditional formatting option for a table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableRowConditionalFormatting.Builder}
         * avoiding the need to create one manually via {@link TableRowConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableRowConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #row(TableRowConditionalFormatting)}.
         * 
         * @param row
         *        a consumer that will call methods on {@link TableRowConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #row(TableRowConditionalFormatting)
         */
        default Builder row(Consumer<TableRowConditionalFormatting.Builder> row) {
            return row(TableRowConditionalFormatting.builder().applyMutation(row).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableCellConditionalFormatting cell;

        private TableRowConditionalFormatting row;

        private BuilderImpl() {
        }

        private BuilderImpl(TableConditionalFormattingOption model) {
            cell(model.cell);
            row(model.row);
        }

        public final TableCellConditionalFormatting.Builder getCell() {
            return cell != null ? cell.toBuilder() : null;
        }

        public final void setCell(TableCellConditionalFormatting.BuilderImpl cell) {
            this.cell = cell != null ? cell.build() : null;
        }

        @Override
        public final Builder cell(TableCellConditionalFormatting cell) {
            this.cell = cell;
            return this;
        }

        public final TableRowConditionalFormatting.Builder getRow() {
            return row != null ? row.toBuilder() : null;
        }

        public final void setRow(TableRowConditionalFormatting.BuilderImpl row) {
            this.row = row != null ? row.build() : null;
        }

        @Override
        public final Builder row(TableRowConditionalFormatting row) {
            this.row = row;
            return this;
        }

        @Override
        public TableConditionalFormattingOption build() {
            return new TableConditionalFormattingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
