/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of the dashboard snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotConfiguration.Builder, SnapshotConfiguration> {
    private static final SdkField<List<SnapshotFileGroup>> FILE_GROUPS_FIELD = SdkField
            .<List<SnapshotFileGroup>> builder(MarshallingType.LIST)
            .memberName("FileGroups")
            .getter(getter(SnapshotConfiguration::fileGroups))
            .setter(setter(Builder::fileGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotFileGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotFileGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SnapshotDestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<SnapshotDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("DestinationConfiguration")
            .getter(getter(SnapshotConfiguration::destinationConfiguration)).setter(setter(Builder::destinationConfiguration))
            .constructor(SnapshotDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfiguration").build())
            .build();

    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.<Parameters> builder(MarshallingType.SDK_POJO)
            .memberName("Parameters").getter(getter(SnapshotConfiguration::parameters)).setter(setter(Builder::parameters))
            .constructor(Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_GROUPS_FIELD,
            DESTINATION_CONFIGURATION_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SnapshotFileGroup> fileGroups;

    private final SnapshotDestinationConfiguration destinationConfiguration;

    private final Parameters parameters;

    private SnapshotConfiguration(BuilderImpl builder) {
        this.fileGroups = builder.fileGroups;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.parameters = builder.parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFileGroups() {
        return fileGroups != null && !(fileGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot that is
     * generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileGroups} method.
     * </p>
     * 
     * @return A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot
     *         that is generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
     */
    public final List<SnapshotFileGroup> fileGroups() {
        return fileGroups;
    }

    /**
     * <p>
     * A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.
     * </p>
     * 
     * @return A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.
     */
    public final SnapshotDestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * Returns the value of the Parameters property for this object.
     * 
     * @return The value of the Parameters property for this object.
     */
    public final Parameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFileGroups() ? fileGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotConfiguration)) {
            return false;
        }
        SnapshotConfiguration other = (SnapshotConfiguration) obj;
        return hasFileGroups() == other.hasFileGroups() && Objects.equals(fileGroups(), other.fileGroups())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotConfiguration").add("FileGroups", hasFileGroups() ? fileGroups() : null)
                .add("DestinationConfiguration", destinationConfiguration()).add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileGroups":
            return Optional.ofNullable(clazz.cast(fileGroups()));
        case "DestinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileGroups", FILE_GROUPS_FIELD);
        map.put("DestinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotConfiguration, T> g) {
        return obj -> g.apply((SnapshotConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotConfiguration> {
        /**
         * <p>
         * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot that is
         * generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
         * </p>
         * 
         * @param fileGroups
         *        A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot
         *        that is generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileGroups(Collection<SnapshotFileGroup> fileGroups);

        /**
         * <p>
         * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot that is
         * generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
         * </p>
         * 
         * @param fileGroups
         *        A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot
         *        that is generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileGroups(SnapshotFileGroup... fileGroups);

        /**
         * <p>
         * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot that is
         * generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileGroup.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #fileGroups(List<SnapshotFileGroup>)}.
         * 
         * @param fileGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileGroups(java.util.Collection<SnapshotFileGroup>)
         */
        Builder fileGroups(Consumer<SnapshotFileGroup.Builder>... fileGroups);

        /**
         * <p>
         * A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.
         * </p>
         * 
         * @param destinationConfiguration
         *        A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(SnapshotDestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnapshotDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationConfiguration(SnapshotDestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link SnapshotDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(SnapshotDestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<SnapshotDestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(SnapshotDestinationConfiguration.builder().applyMutation(destinationConfiguration)
                    .build());
        }

        /**
         * Sets the value of the Parameters property for this object.
         *
         * @param parameters
         *        The new value for the Parameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameters parameters);

        /**
         * Sets the value of the Parameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Parameters.Builder} avoiding the need to
         * create one manually via {@link Parameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Parameters.Builder#build()} is called immediately and its result
         * is passed to {@link #parameters(Parameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(Parameters)
         */
        default Builder parameters(Consumer<Parameters.Builder> parameters) {
            return parameters(Parameters.builder().applyMutation(parameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotFileGroup> fileGroups = DefaultSdkAutoConstructList.getInstance();

        private SnapshotDestinationConfiguration destinationConfiguration;

        private Parameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotConfiguration model) {
            fileGroups(model.fileGroups);
            destinationConfiguration(model.destinationConfiguration);
            parameters(model.parameters);
        }

        public final List<SnapshotFileGroup.Builder> getFileGroups() {
            List<SnapshotFileGroup.Builder> result = SnapshotFileGroupListCopier.copyToBuilder(this.fileGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileGroups(Collection<SnapshotFileGroup.BuilderImpl> fileGroups) {
            this.fileGroups = SnapshotFileGroupListCopier.copyFromBuilder(fileGroups);
        }

        @Override
        public final Builder fileGroups(Collection<SnapshotFileGroup> fileGroups) {
            this.fileGroups = SnapshotFileGroupListCopier.copy(fileGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileGroups(SnapshotFileGroup... fileGroups) {
            fileGroups(Arrays.asList(fileGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileGroups(Consumer<SnapshotFileGroup.Builder>... fileGroups) {
            fileGroups(Stream.of(fileGroups).map(c -> SnapshotFileGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SnapshotDestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(SnapshotDestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(SnapshotDestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public SnapshotConfiguration build() {
            return new SnapshotConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
