/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rendering rules of a sheet that uses a free-form layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetElementRenderingRule implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetElementRenderingRule.Builder, SheetElementRenderingRule> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(SheetElementRenderingRule::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<SheetElementConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField
            .<SheetElementConfigurationOverrides> builder(MarshallingType.SDK_POJO).memberName("ConfigurationOverrides")
            .getter(getter(SheetElementRenderingRule::configurationOverrides)).setter(setter(Builder::configurationOverrides))
            .constructor(SheetElementConfigurationOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationOverrides").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            CONFIGURATION_OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final SheetElementConfigurationOverrides configurationOverrides;

    private SheetElementRenderingRule(BuilderImpl builder) {
        this.expression = builder.expression;
        this.configurationOverrides = builder.configurationOverrides;
    }

    /**
     * <p>
     * The expression of the rendering rules of a sheet.
     * </p>
     * 
     * @return The expression of the rendering rules of a sheet.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The override configuration of the rendering rules of a sheet.
     * </p>
     * 
     * @return The override configuration of the rendering rules of a sheet.
     */
    public final SheetElementConfigurationOverrides configurationOverrides() {
        return configurationOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(configurationOverrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetElementRenderingRule)) {
            return false;
        }
        SheetElementRenderingRule other = (SheetElementRenderingRule) obj;
        return Objects.equals(expression(), other.expression())
                && Objects.equals(configurationOverrides(), other.configurationOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetElementRenderingRule")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConfigurationOverrides", configurationOverrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "ConfigurationOverrides":
            return Optional.ofNullable(clazz.cast(configurationOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("ConfigurationOverrides", CONFIGURATION_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetElementRenderingRule, T> g) {
        return obj -> g.apply((SheetElementRenderingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetElementRenderingRule> {
        /**
         * <p>
         * The expression of the rendering rules of a sheet.
         * </p>
         * 
         * @param expression
         *        The expression of the rendering rules of a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The override configuration of the rendering rules of a sheet.
         * </p>
         * 
         * @param configurationOverrides
         *        The override configuration of the rendering rules of a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationOverrides(SheetElementConfigurationOverrides configurationOverrides);

        /**
         * <p>
         * The override configuration of the rendering rules of a sheet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SheetElementConfigurationOverrides.Builder} avoiding the need to create one manually via
         * {@link SheetElementConfigurationOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetElementConfigurationOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationOverrides(SheetElementConfigurationOverrides)}.
         * 
         * @param configurationOverrides
         *        a consumer that will call methods on {@link SheetElementConfigurationOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationOverrides(SheetElementConfigurationOverrides)
         */
        default Builder configurationOverrides(Consumer<SheetElementConfigurationOverrides.Builder> configurationOverrides) {
            return configurationOverrides(SheetElementConfigurationOverrides.builder().applyMutation(configurationOverrides)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private SheetElementConfigurationOverrides configurationOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetElementRenderingRule model) {
            expression(model.expression);
            configurationOverrides(model.configurationOverrides);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final SheetElementConfigurationOverrides.Builder getConfigurationOverrides() {
            return configurationOverrides != null ? configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(SheetElementConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(SheetElementConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        @Override
        public SheetElementRenderingRule build() {
            return new SheetElementRenderingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
