/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A query limits configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginVisualItemsLimitConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PluginVisualItemsLimitConfiguration.Builder, PluginVisualItemsLimitConfiguration> {
    private static final SdkField<Long> ITEMS_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ItemsLimit").getter(getter(PluginVisualItemsLimitConfiguration::itemsLimit))
            .setter(setter(Builder::itemsLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long itemsLimit;

    private PluginVisualItemsLimitConfiguration(BuilderImpl builder) {
        this.itemsLimit = builder.itemsLimit;
    }

    /**
     * <p>
     * Determines how many values are be fetched at once.
     * </p>
     * 
     * @return Determines how many values are be fetched at once.
     */
    public final Long itemsLimit() {
        return itemsLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemsLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualItemsLimitConfiguration)) {
            return false;
        }
        PluginVisualItemsLimitConfiguration other = (PluginVisualItemsLimitConfiguration) obj;
        return Objects.equals(itemsLimit(), other.itemsLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginVisualItemsLimitConfiguration").add("ItemsLimit", itemsLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ItemsLimit":
            return Optional.ofNullable(clazz.cast(itemsLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ItemsLimit", ITEMS_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualItemsLimitConfiguration, T> g) {
        return obj -> g.apply((PluginVisualItemsLimitConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginVisualItemsLimitConfiguration> {
        /**
         * <p>
         * Determines how many values are be fetched at once.
         * </p>
         * 
         * @param itemsLimit
         *        Determines how many values are be fetched at once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemsLimit(Long itemsLimit);
    }

    static final class BuilderImpl implements Builder {
        private Long itemsLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualItemsLimitConfiguration model) {
            itemsLimit(model.itemsLimit);
        }

        public final Long getItemsLimit() {
            return itemsLimit;
        }

        public final void setItemsLimit(Long itemsLimit) {
            this.itemsLimit = itemsLimit;
        }

        @Override
        public final Builder itemsLimit(Long itemsLimit) {
            this.itemsLimit = itemsLimit;
            return this;
        }

        @Override
        public PluginVisualItemsLimitConfiguration build() {
            return new PluginVisualItemsLimitConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
