/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optional configuration of totals cells in a <code>PivotTableVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTotalOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTotalOptions.Builder, PivotTotalOptions> {
    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalsVisibility").getter(getter(PivotTotalOptions::totalsVisibilityAsString))
            .setter(setter(Builder::totalsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()).build();

    private static final SdkField<String> PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Placement").getter(getter(PivotTotalOptions::placementAsString)).setter(setter(Builder::placement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()).build();

    private static final SdkField<String> SCROLL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScrollStatus").getter(getter(PivotTotalOptions::scrollStatusAsString))
            .setter(setter(Builder::scrollStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScrollStatus").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(PivotTotalOptions::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final SdkField<TableCellStyle> TOTAL_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("TotalCellStyle")
            .getter(getter(PivotTotalOptions::totalCellStyle)).setter(setter(Builder::totalCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCellStyle").build()).build();

    private static final SdkField<TableCellStyle> VALUE_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("ValueCellStyle")
            .getter(getter(PivotTotalOptions::valueCellStyle)).setter(setter(Builder::valueCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueCellStyle").build()).build();

    private static final SdkField<TableCellStyle> METRIC_HEADER_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("MetricHeaderCellStyle")
            .getter(getter(PivotTotalOptions::metricHeaderCellStyle)).setter(setter(Builder::metricHeaderCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricHeaderCellStyle").build())
            .build();

    private static final SdkField<List<TotalAggregationOption>> TOTAL_AGGREGATION_OPTIONS_FIELD = SdkField
            .<List<TotalAggregationOption>> builder(MarshallingType.LIST)
            .memberName("TotalAggregationOptions")
            .getter(getter(PivotTotalOptions::totalAggregationOptions))
            .setter(setter(Builder::totalAggregationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAggregationOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TotalAggregationOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(TotalAggregationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTALS_VISIBILITY_FIELD,
            PLACEMENT_FIELD, SCROLL_STATUS_FIELD, CUSTOM_LABEL_FIELD, TOTAL_CELL_STYLE_FIELD, VALUE_CELL_STYLE_FIELD,
            METRIC_HEADER_CELL_STYLE_FIELD, TOTAL_AGGREGATION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String totalsVisibility;

    private final String placement;

    private final String scrollStatus;

    private final String customLabel;

    private final TableCellStyle totalCellStyle;

    private final TableCellStyle valueCellStyle;

    private final TableCellStyle metricHeaderCellStyle;

    private final List<TotalAggregationOption> totalAggregationOptions;

    private PivotTotalOptions(BuilderImpl builder) {
        this.totalsVisibility = builder.totalsVisibility;
        this.placement = builder.placement;
        this.scrollStatus = builder.scrollStatus;
        this.customLabel = builder.customLabel;
        this.totalCellStyle = builder.totalCellStyle;
        this.valueCellStyle = builder.valueCellStyle;
        this.metricHeaderCellStyle = builder.metricHeaderCellStyle;
        this.totalAggregationOptions = builder.totalAggregationOptions;
    }

    /**
     * <p>
     * The visibility configuration for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration for the total cells.
     * @see Visibility
     */
    public final Visibility totalsVisibility() {
        return Visibility.fromValue(totalsVisibility);
    }

    /**
     * <p>
     * The visibility configuration for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration for the total cells.
     * @see Visibility
     */
    public final String totalsVisibilityAsString() {
        return totalsVisibility;
    }

    /**
     * <p>
     * The placement (start, end) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placement} will
     * return {@link TableTotalsPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #placementAsString}.
     * </p>
     * 
     * @return The placement (start, end) for the total cells.
     * @see TableTotalsPlacement
     */
    public final TableTotalsPlacement placement() {
        return TableTotalsPlacement.fromValue(placement);
    }

    /**
     * <p>
     * The placement (start, end) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placement} will
     * return {@link TableTotalsPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #placementAsString}.
     * </p>
     * 
     * @return The placement (start, end) for the total cells.
     * @see TableTotalsPlacement
     */
    public final String placementAsString() {
        return placement;
    }

    /**
     * <p>
     * The scroll status (pinned, scrolled) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scrollStatus} will
     * return {@link TableTotalsScrollStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scrollStatusAsString}.
     * </p>
     * 
     * @return The scroll status (pinned, scrolled) for the total cells.
     * @see TableTotalsScrollStatus
     */
    public final TableTotalsScrollStatus scrollStatus() {
        return TableTotalsScrollStatus.fromValue(scrollStatus);
    }

    /**
     * <p>
     * The scroll status (pinned, scrolled) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scrollStatus} will
     * return {@link TableTotalsScrollStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scrollStatusAsString}.
     * </p>
     * 
     * @return The scroll status (pinned, scrolled) for the total cells.
     * @see TableTotalsScrollStatus
     */
    public final String scrollStatusAsString() {
        return scrollStatus;
    }

    /**
     * <p>
     * The custom label string for the total cells.
     * </p>
     * 
     * @return The custom label string for the total cells.
     */
    public final String customLabel() {
        return customLabel;
    }

    /**
     * <p>
     * The cell styling options for the total cells.
     * </p>
     * 
     * @return The cell styling options for the total cells.
     */
    public final TableCellStyle totalCellStyle() {
        return totalCellStyle;
    }

    /**
     * <p>
     * The cell styling options for the totals of value cells.
     * </p>
     * 
     * @return The cell styling options for the totals of value cells.
     */
    public final TableCellStyle valueCellStyle() {
        return valueCellStyle;
    }

    /**
     * <p>
     * The cell styling options for the total of header cells.
     * </p>
     * 
     * @return The cell styling options for the total of header cells.
     */
    public final TableCellStyle metricHeaderCellStyle() {
        return metricHeaderCellStyle;
    }

    /**
     * For responses, this returns true if the service returned a value for the TotalAggregationOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTotalAggregationOptions() {
        return totalAggregationOptions != null && !(totalAggregationOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The total aggregation options for each value field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTotalAggregationOptions} method.
     * </p>
     * 
     * @return The total aggregation options for each value field.
     */
    public final List<TotalAggregationOption> totalAggregationOptions() {
        return totalAggregationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(placementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scrollStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(totalCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(valueCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(metricHeaderCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(hasTotalAggregationOptions() ? totalAggregationOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTotalOptions)) {
            return false;
        }
        PivotTotalOptions other = (PivotTotalOptions) obj;
        return Objects.equals(totalsVisibilityAsString(), other.totalsVisibilityAsString())
                && Objects.equals(placementAsString(), other.placementAsString())
                && Objects.equals(scrollStatusAsString(), other.scrollStatusAsString())
                && Objects.equals(customLabel(), other.customLabel()) && Objects.equals(totalCellStyle(), other.totalCellStyle())
                && Objects.equals(valueCellStyle(), other.valueCellStyle())
                && Objects.equals(metricHeaderCellStyle(), other.metricHeaderCellStyle())
                && hasTotalAggregationOptions() == other.hasTotalAggregationOptions()
                && Objects.equals(totalAggregationOptions(), other.totalAggregationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTotalOptions").add("TotalsVisibility", totalsVisibilityAsString())
                .add("Placement", placementAsString()).add("ScrollStatus", scrollStatusAsString())
                .add("CustomLabel", customLabel()).add("TotalCellStyle", totalCellStyle())
                .add("ValueCellStyle", valueCellStyle()).add("MetricHeaderCellStyle", metricHeaderCellStyle())
                .add("TotalAggregationOptions", hasTotalAggregationOptions() ? totalAggregationOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalsVisibility":
            return Optional.ofNullable(clazz.cast(totalsVisibilityAsString()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placementAsString()));
        case "ScrollStatus":
            return Optional.ofNullable(clazz.cast(scrollStatusAsString()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        case "TotalCellStyle":
            return Optional.ofNullable(clazz.cast(totalCellStyle()));
        case "ValueCellStyle":
            return Optional.ofNullable(clazz.cast(valueCellStyle()));
        case "MetricHeaderCellStyle":
            return Optional.ofNullable(clazz.cast(metricHeaderCellStyle()));
        case "TotalAggregationOptions":
            return Optional.ofNullable(clazz.cast(totalAggregationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalsVisibility", TOTALS_VISIBILITY_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("ScrollStatus", SCROLL_STATUS_FIELD);
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        map.put("TotalCellStyle", TOTAL_CELL_STYLE_FIELD);
        map.put("ValueCellStyle", VALUE_CELL_STYLE_FIELD);
        map.put("MetricHeaderCellStyle", METRIC_HEADER_CELL_STYLE_FIELD);
        map.put("TotalAggregationOptions", TOTAL_AGGREGATION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTotalOptions, T> g) {
        return obj -> g.apply((PivotTotalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTotalOptions> {
        /**
         * <p>
         * The visibility configuration for the total cells.
         * </p>
         * 
         * @param totalsVisibility
         *        The visibility configuration for the total cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(String totalsVisibility);

        /**
         * <p>
         * The visibility configuration for the total cells.
         * </p>
         * 
         * @param totalsVisibility
         *        The visibility configuration for the total cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(Visibility totalsVisibility);

        /**
         * <p>
         * The placement (start, end) for the total cells.
         * </p>
         * 
         * @param placement
         *        The placement (start, end) for the total cells.
         * @see TableTotalsPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsPlacement
         */
        Builder placement(String placement);

        /**
         * <p>
         * The placement (start, end) for the total cells.
         * </p>
         * 
         * @param placement
         *        The placement (start, end) for the total cells.
         * @see TableTotalsPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsPlacement
         */
        Builder placement(TableTotalsPlacement placement);

        /**
         * <p>
         * The scroll status (pinned, scrolled) for the total cells.
         * </p>
         * 
         * @param scrollStatus
         *        The scroll status (pinned, scrolled) for the total cells.
         * @see TableTotalsScrollStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsScrollStatus
         */
        Builder scrollStatus(String scrollStatus);

        /**
         * <p>
         * The scroll status (pinned, scrolled) for the total cells.
         * </p>
         * 
         * @param scrollStatus
         *        The scroll status (pinned, scrolled) for the total cells.
         * @see TableTotalsScrollStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsScrollStatus
         */
        Builder scrollStatus(TableTotalsScrollStatus scrollStatus);

        /**
         * <p>
         * The custom label string for the total cells.
         * </p>
         * 
         * @param customLabel
         *        The custom label string for the total cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);

        /**
         * <p>
         * The cell styling options for the total cells.
         * </p>
         * 
         * @param totalCellStyle
         *        The cell styling options for the total cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCellStyle(TableCellStyle totalCellStyle);

        /**
         * <p>
         * The cell styling options for the total cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #totalCellStyle(TableCellStyle)}.
         * 
         * @param totalCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalCellStyle(TableCellStyle)
         */
        default Builder totalCellStyle(Consumer<TableCellStyle.Builder> totalCellStyle) {
            return totalCellStyle(TableCellStyle.builder().applyMutation(totalCellStyle).build());
        }

        /**
         * <p>
         * The cell styling options for the totals of value cells.
         * </p>
         * 
         * @param valueCellStyle
         *        The cell styling options for the totals of value cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueCellStyle(TableCellStyle valueCellStyle);

        /**
         * <p>
         * The cell styling options for the totals of value cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #valueCellStyle(TableCellStyle)}.
         * 
         * @param valueCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueCellStyle(TableCellStyle)
         */
        default Builder valueCellStyle(Consumer<TableCellStyle.Builder> valueCellStyle) {
            return valueCellStyle(TableCellStyle.builder().applyMutation(valueCellStyle).build());
        }

        /**
         * <p>
         * The cell styling options for the total of header cells.
         * </p>
         * 
         * @param metricHeaderCellStyle
         *        The cell styling options for the total of header cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricHeaderCellStyle(TableCellStyle metricHeaderCellStyle);

        /**
         * <p>
         * The cell styling options for the total of header cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #metricHeaderCellStyle(TableCellStyle)}.
         * 
         * @param metricHeaderCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricHeaderCellStyle(TableCellStyle)
         */
        default Builder metricHeaderCellStyle(Consumer<TableCellStyle.Builder> metricHeaderCellStyle) {
            return metricHeaderCellStyle(TableCellStyle.builder().applyMutation(metricHeaderCellStyle).build());
        }

        /**
         * <p>
         * The total aggregation options for each value field.
         * </p>
         * 
         * @param totalAggregationOptions
         *        The total aggregation options for each value field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAggregationOptions(Collection<TotalAggregationOption> totalAggregationOptions);

        /**
         * <p>
         * The total aggregation options for each value field.
         * </p>
         * 
         * @param totalAggregationOptions
         *        The total aggregation options for each value field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAggregationOptions(TotalAggregationOption... totalAggregationOptions);

        /**
         * <p>
         * The total aggregation options for each value field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TotalAggregationOption.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.TotalAggregationOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TotalAggregationOption.Builder#build()} is called
         * immediately and its result is passed to {@link #totalAggregationOptions(List<TotalAggregationOption>)}.
         * 
         * @param totalAggregationOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TotalAggregationOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalAggregationOptions(java.util.Collection<TotalAggregationOption>)
         */
        Builder totalAggregationOptions(Consumer<TotalAggregationOption.Builder>... totalAggregationOptions);
    }

    static final class BuilderImpl implements Builder {
        private String totalsVisibility;

        private String placement;

        private String scrollStatus;

        private String customLabel;

        private TableCellStyle totalCellStyle;

        private TableCellStyle valueCellStyle;

        private TableCellStyle metricHeaderCellStyle;

        private List<TotalAggregationOption> totalAggregationOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTotalOptions model) {
            totalsVisibility(model.totalsVisibility);
            placement(model.placement);
            scrollStatus(model.scrollStatus);
            customLabel(model.customLabel);
            totalCellStyle(model.totalCellStyle);
            valueCellStyle(model.valueCellStyle);
            metricHeaderCellStyle(model.metricHeaderCellStyle);
            totalAggregationOptions(model.totalAggregationOptions);
        }

        public final String getTotalsVisibility() {
            return totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        public final String getPlacement() {
            return placement;
        }

        public final void setPlacement(String placement) {
            this.placement = placement;
        }

        @Override
        public final Builder placement(String placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public final Builder placement(TableTotalsPlacement placement) {
            this.placement(placement == null ? null : placement.toString());
            return this;
        }

        public final String getScrollStatus() {
            return scrollStatus;
        }

        public final void setScrollStatus(String scrollStatus) {
            this.scrollStatus = scrollStatus;
        }

        @Override
        public final Builder scrollStatus(String scrollStatus) {
            this.scrollStatus = scrollStatus;
            return this;
        }

        @Override
        public final Builder scrollStatus(TableTotalsScrollStatus scrollStatus) {
            this.scrollStatus(scrollStatus == null ? null : scrollStatus.toString());
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final TableCellStyle.Builder getTotalCellStyle() {
            return totalCellStyle != null ? totalCellStyle.toBuilder() : null;
        }

        public final void setTotalCellStyle(TableCellStyle.BuilderImpl totalCellStyle) {
            this.totalCellStyle = totalCellStyle != null ? totalCellStyle.build() : null;
        }

        @Override
        public final Builder totalCellStyle(TableCellStyle totalCellStyle) {
            this.totalCellStyle = totalCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getValueCellStyle() {
            return valueCellStyle != null ? valueCellStyle.toBuilder() : null;
        }

        public final void setValueCellStyle(TableCellStyle.BuilderImpl valueCellStyle) {
            this.valueCellStyle = valueCellStyle != null ? valueCellStyle.build() : null;
        }

        @Override
        public final Builder valueCellStyle(TableCellStyle valueCellStyle) {
            this.valueCellStyle = valueCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getMetricHeaderCellStyle() {
            return metricHeaderCellStyle != null ? metricHeaderCellStyle.toBuilder() : null;
        }

        public final void setMetricHeaderCellStyle(TableCellStyle.BuilderImpl metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle != null ? metricHeaderCellStyle.build() : null;
        }

        @Override
        public final Builder metricHeaderCellStyle(TableCellStyle metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle;
            return this;
        }

        public final List<TotalAggregationOption.Builder> getTotalAggregationOptions() {
            List<TotalAggregationOption.Builder> result = TotalAggregationOptionListCopier
                    .copyToBuilder(this.totalAggregationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTotalAggregationOptions(Collection<TotalAggregationOption.BuilderImpl> totalAggregationOptions) {
            this.totalAggregationOptions = TotalAggregationOptionListCopier.copyFromBuilder(totalAggregationOptions);
        }

        @Override
        public final Builder totalAggregationOptions(Collection<TotalAggregationOption> totalAggregationOptions) {
            this.totalAggregationOptions = TotalAggregationOptionListCopier.copy(totalAggregationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalAggregationOptions(TotalAggregationOption... totalAggregationOptions) {
            totalAggregationOptions(Arrays.asList(totalAggregationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalAggregationOptions(Consumer<TotalAggregationOption.Builder>... totalAggregationOptions) {
            totalAggregationOptions(Stream.of(totalAggregationOptions)
                    .map(c -> TotalAggregationOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PivotTotalOptions build() {
            return new PivotTotalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
