/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells for a pivot table visual.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableFieldWells.Builder, PivotTableFieldWells> {
    private static final SdkField<PivotTableAggregatedFieldWells> PIVOT_TABLE_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<PivotTableAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("PivotTableAggregatedFieldWells")
            .getter(getter(PivotTableFieldWells::pivotTableAggregatedFieldWells))
            .setter(setter(Builder::pivotTableAggregatedFieldWells))
            .constructor(PivotTableAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotTableAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIVOT_TABLE_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PivotTableAggregatedFieldWells pivotTableAggregatedFieldWells;

    private PivotTableFieldWells(BuilderImpl builder) {
        this.pivotTableAggregatedFieldWells = builder.pivotTableAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field well for the pivot table.
     * </p>
     * 
     * @return The aggregated field well for the pivot table.
     */
    public final PivotTableAggregatedFieldWells pivotTableAggregatedFieldWells() {
        return pivotTableAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pivotTableAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableFieldWells)) {
            return false;
        }
        PivotTableFieldWells other = (PivotTableFieldWells) obj;
        return Objects.equals(pivotTableAggregatedFieldWells(), other.pivotTableAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableFieldWells").add("PivotTableAggregatedFieldWells", pivotTableAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PivotTableAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(pivotTableAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PivotTableAggregatedFieldWells", PIVOT_TABLE_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableFieldWells, T> g) {
        return obj -> g.apply((PivotTableFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableFieldWells> {
        /**
         * <p>
         * The aggregated field well for the pivot table.
         * </p>
         * 
         * @param pivotTableAggregatedFieldWells
         *        The aggregated field well for the pivot table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pivotTableAggregatedFieldWells(PivotTableAggregatedFieldWells pivotTableAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field well for the pivot table.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link PivotTableAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pivotTableAggregatedFieldWells(PivotTableAggregatedFieldWells)}.
         * 
         * @param pivotTableAggregatedFieldWells
         *        a consumer that will call methods on {@link PivotTableAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pivotTableAggregatedFieldWells(PivotTableAggregatedFieldWells)
         */
        default Builder pivotTableAggregatedFieldWells(
                Consumer<PivotTableAggregatedFieldWells.Builder> pivotTableAggregatedFieldWells) {
            return pivotTableAggregatedFieldWells(PivotTableAggregatedFieldWells.builder()
                    .applyMutation(pivotTableAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PivotTableAggregatedFieldWells pivotTableAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableFieldWells model) {
            pivotTableAggregatedFieldWells(model.pivotTableAggregatedFieldWells);
        }

        public final PivotTableAggregatedFieldWells.Builder getPivotTableAggregatedFieldWells() {
            return pivotTableAggregatedFieldWells != null ? pivotTableAggregatedFieldWells.toBuilder() : null;
        }

        public final void setPivotTableAggregatedFieldWells(
                PivotTableAggregatedFieldWells.BuilderImpl pivotTableAggregatedFieldWells) {
            this.pivotTableAggregatedFieldWells = pivotTableAggregatedFieldWells != null ? pivotTableAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder pivotTableAggregatedFieldWells(PivotTableAggregatedFieldWells pivotTableAggregatedFieldWells) {
            this.pivotTableAggregatedFieldWells = pivotTableAggregatedFieldWells;
            return this;
        }

        @Override
        public PivotTableFieldWells build() {
            return new PivotTableFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
