/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target of a pivot table field collapse state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableFieldCollapseStateTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableFieldCollapseStateTarget.Builder, PivotTableFieldCollapseStateTarget> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(PivotTableFieldCollapseStateTarget::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<List<DataPathValue>> FIELD_DATA_PATH_VALUES_FIELD = SdkField
            .<List<DataPathValue>> builder(MarshallingType.LIST)
            .memberName("FieldDataPathValues")
            .getter(getter(PivotTableFieldCollapseStateTarget::fieldDataPathValues))
            .setter(setter(Builder::fieldDataPathValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldDataPathValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataPathValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataPathValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            FIELD_DATA_PATH_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final List<DataPathValue> fieldDataPathValues;

    private PivotTableFieldCollapseStateTarget(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.fieldDataPathValues = builder.fieldDataPathValues;
    }

    /**
     * <p>
     * The field ID of the pivot table that the collapse state needs to be set to.
     * </p>
     * 
     * @return The field ID of the pivot table that the collapse state needs to be set to.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldDataPathValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldDataPathValues() {
        return fieldDataPathValues != null && !(fieldDataPathValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data path of the pivot table's header. Used to set the collapse state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldDataPathValues} method.
     * </p>
     * 
     * @return The data path of the pivot table's header. Used to set the collapse state.
     */
    public final List<DataPathValue> fieldDataPathValues() {
        return fieldDataPathValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldDataPathValues() ? fieldDataPathValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableFieldCollapseStateTarget)) {
            return false;
        }
        PivotTableFieldCollapseStateTarget other = (PivotTableFieldCollapseStateTarget) obj;
        return Objects.equals(fieldId(), other.fieldId()) && hasFieldDataPathValues() == other.hasFieldDataPathValues()
                && Objects.equals(fieldDataPathValues(), other.fieldDataPathValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableFieldCollapseStateTarget").add("FieldId", fieldId())
                .add("FieldDataPathValues", hasFieldDataPathValues() ? fieldDataPathValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "FieldDataPathValues":
            return Optional.ofNullable(clazz.cast(fieldDataPathValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("FieldDataPathValues", FIELD_DATA_PATH_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableFieldCollapseStateTarget, T> g) {
        return obj -> g.apply((PivotTableFieldCollapseStateTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableFieldCollapseStateTarget> {
        /**
         * <p>
         * The field ID of the pivot table that the collapse state needs to be set to.
         * </p>
         * 
         * @param fieldId
         *        The field ID of the pivot table that the collapse state needs to be set to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The data path of the pivot table's header. Used to set the collapse state.
         * </p>
         * 
         * @param fieldDataPathValues
         *        The data path of the pivot table's header. Used to set the collapse state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDataPathValues(Collection<DataPathValue> fieldDataPathValues);

        /**
         * <p>
         * The data path of the pivot table's header. Used to set the collapse state.
         * </p>
         * 
         * @param fieldDataPathValues
         *        The data path of the pivot table's header. Used to set the collapse state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDataPathValues(DataPathValue... fieldDataPathValues);

        /**
         * <p>
         * The data path of the pivot table's header. Used to set the collapse state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DataPathValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldDataPathValues(List<DataPathValue>)}.
         * 
         * @param fieldDataPathValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldDataPathValues(java.util.Collection<DataPathValue>)
         */
        Builder fieldDataPathValues(Consumer<DataPathValue.Builder>... fieldDataPathValues);
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private List<DataPathValue> fieldDataPathValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableFieldCollapseStateTarget model) {
            fieldId(model.fieldId);
            fieldDataPathValues(model.fieldDataPathValues);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final List<DataPathValue.Builder> getFieldDataPathValues() {
            List<DataPathValue.Builder> result = DataPathValueListCopier.copyToBuilder(this.fieldDataPathValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldDataPathValues(Collection<DataPathValue.BuilderImpl> fieldDataPathValues) {
            this.fieldDataPathValues = DataPathValueListCopier.copyFromBuilder(fieldDataPathValues);
        }

        @Override
        public final Builder fieldDataPathValues(Collection<DataPathValue> fieldDataPathValues) {
            this.fieldDataPathValues = DataPathValueListCopier.copy(fieldDataPathValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDataPathValues(DataPathValue... fieldDataPathValues) {
            fieldDataPathValues(Arrays.asList(fieldDataPathValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDataPathValues(Consumer<DataPathValue.Builder>... fieldDataPathValues) {
            fieldDataPathValues(Stream.of(fieldDataPathValues).map(c -> DataPathValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PivotTableFieldCollapseStateTarget build() {
            return new PivotTableFieldCollapseStateTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
