/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Conditional formatting options for a <code>PivotTableVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableConditionalFormattingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableConditionalFormattingOption.Builder, PivotTableConditionalFormattingOption> {
    private static final SdkField<PivotTableCellConditionalFormatting> CELL_FIELD = SdkField
            .<PivotTableCellConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("Cell")
            .getter(getter(PivotTableConditionalFormattingOption::cell)).setter(setter(Builder::cell))
            .constructor(PivotTableCellConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cell").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PivotTableCellConditionalFormatting cell;

    private PivotTableConditionalFormattingOption(BuilderImpl builder) {
        this.cell = builder.cell;
    }

    /**
     * <p>
     * The cell conditional formatting option for a pivot table.
     * </p>
     * 
     * @return The cell conditional formatting option for a pivot table.
     */
    public final PivotTableCellConditionalFormatting cell() {
        return cell;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cell());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableConditionalFormattingOption)) {
            return false;
        }
        PivotTableConditionalFormattingOption other = (PivotTableConditionalFormattingOption) obj;
        return Objects.equals(cell(), other.cell());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableConditionalFormattingOption").add("Cell", cell()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cell":
            return Optional.ofNullable(clazz.cast(cell()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cell", CELL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableConditionalFormattingOption, T> g) {
        return obj -> g.apply((PivotTableConditionalFormattingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableConditionalFormattingOption> {
        /**
         * <p>
         * The cell conditional formatting option for a pivot table.
         * </p>
         * 
         * @param cell
         *        The cell conditional formatting option for a pivot table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cell(PivotTableCellConditionalFormatting cell);

        /**
         * <p>
         * The cell conditional formatting option for a pivot table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PivotTableCellConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link PivotTableCellConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableCellConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #cell(PivotTableCellConditionalFormatting)}.
         * 
         * @param cell
         *        a consumer that will call methods on {@link PivotTableCellConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cell(PivotTableCellConditionalFormatting)
         */
        default Builder cell(Consumer<PivotTableCellConditionalFormatting.Builder> cell) {
            return cell(PivotTableCellConditionalFormatting.builder().applyMutation(cell).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PivotTableCellConditionalFormatting cell;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableConditionalFormattingOption model) {
            cell(model.cell);
        }

        public final PivotTableCellConditionalFormatting.Builder getCell() {
            return cell != null ? cell.toBuilder() : null;
        }

        public final void setCell(PivotTableCellConditionalFormatting.BuilderImpl cell) {
            this.cell = cell != null ? cell.build() : null;
        }

        @Override
        public final Builder cell(PivotTableCellConditionalFormatting cell) {
            this.cell = cell;
            return this;
        }

        @Override
        public PivotTableConditionalFormattingOption build() {
            return new PivotTableConditionalFormattingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
