/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a pie chart.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PieChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<PieChartFieldWells.Builder, PieChartFieldWells> {
    private static final SdkField<PieChartAggregatedFieldWells> PIE_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<PieChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("PieChartAggregatedFieldWells")
            .getter(getter(PieChartFieldWells::pieChartAggregatedFieldWells))
            .setter(setter(Builder::pieChartAggregatedFieldWells))
            .constructor(PieChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PieChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIE_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PieChartAggregatedFieldWells pieChartAggregatedFieldWells;

    private PieChartFieldWells(BuilderImpl builder) {
        this.pieChartAggregatedFieldWells = builder.pieChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The field well configuration of a pie chart.
     * </p>
     * 
     * @return The field well configuration of a pie chart.
     */
    public final PieChartAggregatedFieldWells pieChartAggregatedFieldWells() {
        return pieChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pieChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PieChartFieldWells)) {
            return false;
        }
        PieChartFieldWells other = (PieChartFieldWells) obj;
        return Objects.equals(pieChartAggregatedFieldWells(), other.pieChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PieChartFieldWells").add("PieChartAggregatedFieldWells", pieChartAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PieChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(pieChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PieChartAggregatedFieldWells", PIE_CHART_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PieChartFieldWells, T> g) {
        return obj -> g.apply((PieChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PieChartFieldWells> {
        /**
         * <p>
         * The field well configuration of a pie chart.
         * </p>
         * 
         * @param pieChartAggregatedFieldWells
         *        The field well configuration of a pie chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pieChartAggregatedFieldWells(PieChartAggregatedFieldWells pieChartAggregatedFieldWells);

        /**
         * <p>
         * The field well configuration of a pie chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link PieChartAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link PieChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PieChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #pieChartAggregatedFieldWells(PieChartAggregatedFieldWells)}.
         * 
         * @param pieChartAggregatedFieldWells
         *        a consumer that will call methods on {@link PieChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pieChartAggregatedFieldWells(PieChartAggregatedFieldWells)
         */
        default Builder pieChartAggregatedFieldWells(Consumer<PieChartAggregatedFieldWells.Builder> pieChartAggregatedFieldWells) {
            return pieChartAggregatedFieldWells(PieChartAggregatedFieldWells.builder()
                    .applyMutation(pieChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PieChartAggregatedFieldWells pieChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(PieChartFieldWells model) {
            pieChartAggregatedFieldWells(model.pieChartAggregatedFieldWells);
        }

        public final PieChartAggregatedFieldWells.Builder getPieChartAggregatedFieldWells() {
            return pieChartAggregatedFieldWells != null ? pieChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setPieChartAggregatedFieldWells(PieChartAggregatedFieldWells.BuilderImpl pieChartAggregatedFieldWells) {
            this.pieChartAggregatedFieldWells = pieChartAggregatedFieldWells != null ? pieChartAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder pieChartAggregatedFieldWells(PieChartAggregatedFieldWells pieChartAggregatedFieldWells) {
            this.pieChartAggregatedFieldWells = pieChartAggregatedFieldWells;
            return this;
        }

        @Override
        public PieChartFieldWells build() {
            return new PieChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
