/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>NumericRangeFilter</code> filters values that are within the value range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericRangeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericRangeFilter.Builder, NumericRangeFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(NumericRangeFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(NumericRangeFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Boolean> INCLUDE_MINIMUM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeMinimum").getter(getter(NumericRangeFilter::includeMinimum))
            .setter(setter(Builder::includeMinimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMinimum").build()).build();

    private static final SdkField<Boolean> INCLUDE_MAXIMUM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeMaximum").getter(getter(NumericRangeFilter::includeMaximum))
            .setter(setter(Builder::includeMaximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMaximum").build()).build();

    private static final SdkField<NumericRangeFilterValue> RANGE_MINIMUM_FIELD = SdkField
            .<NumericRangeFilterValue> builder(MarshallingType.SDK_POJO).memberName("RangeMinimum")
            .getter(getter(NumericRangeFilter::rangeMinimum)).setter(setter(Builder::rangeMinimum))
            .constructor(NumericRangeFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimum").build()).build();

    private static final SdkField<NumericRangeFilterValue> RANGE_MAXIMUM_FIELD = SdkField
            .<NumericRangeFilterValue> builder(MarshallingType.SDK_POJO).memberName("RangeMaximum")
            .getter(getter(NumericRangeFilter::rangeMaximum)).setter(setter(Builder::rangeMaximum))
            .constructor(NumericRangeFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximum").build()).build();

    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectAllOptions").getter(getter(NumericRangeFilter::selectAllOptionsAsString))
            .setter(setter(Builder::selectAllOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()).build();

    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<AggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(NumericRangeFilter::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(AggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOption").getter(getter(NumericRangeFilter::nullOptionAsString)).setter(setter(Builder::nullOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()).build();

    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField
            .<DefaultFilterControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultFilterControlConfiguration")
            .getter(getter(NumericRangeFilter::defaultFilterControlConfiguration))
            .setter(setter(Builder::defaultFilterControlConfiguration))
            .constructor(DefaultFilterControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            INCLUDE_MINIMUM_FIELD, INCLUDE_MAXIMUM_FIELD, RANGE_MINIMUM_FIELD, RANGE_MAXIMUM_FIELD, SELECT_ALL_OPTIONS_FIELD,
            AGGREGATION_FUNCTION_FIELD, NULL_OPTION_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final Boolean includeMinimum;

    private final Boolean includeMaximum;

    private final NumericRangeFilterValue rangeMinimum;

    private final NumericRangeFilterValue rangeMaximum;

    private final String selectAllOptions;

    private final AggregationFunction aggregationFunction;

    private final String nullOption;

    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private NumericRangeFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.includeMinimum = builder.includeMinimum;
        this.includeMaximum = builder.includeMaximum;
        this.rangeMinimum = builder.rangeMinimum;
        this.rangeMaximum = builder.rangeMaximum;
        this.selectAllOptions = builder.selectAllOptions;
        this.aggregationFunction = builder.aggregationFunction;
        this.nullOption = builder.nullOption;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * Determines whether the minimum value in the filter value range should be included in the filtered results.
     * </p>
     * 
     * @return Determines whether the minimum value in the filter value range should be included in the filtered
     *         results.
     */
    public final Boolean includeMinimum() {
        return includeMinimum;
    }

    /**
     * <p>
     * Determines whether the maximum value in the filter value range should be included in the filtered results.
     * </p>
     * 
     * @return Determines whether the maximum value in the filter value range should be included in the filtered
     *         results.
     */
    public final Boolean includeMaximum() {
        return includeMaximum;
    }

    /**
     * <p>
     * The minimum value for the filter value range.
     * </p>
     * 
     * @return The minimum value for the filter value range.
     */
    public final NumericRangeFilterValue rangeMinimum() {
        return rangeMinimum;
    }

    /**
     * <p>
     * The maximum value for the filter value range.
     * </p>
     * 
     * @return The maximum value for the filter value range.
     */
    public final NumericRangeFilterValue rangeMaximum() {
        return rangeMaximum;
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link NumericFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see NumericFilterSelectAllOptions
     */
    public final NumericFilterSelectAllOptions selectAllOptions() {
        return NumericFilterSelectAllOptions.fromValue(selectAllOptions);
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link NumericFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see NumericFilterSelectAllOptions
     */
    public final String selectAllOptionsAsString() {
        return selectAllOptions;
    }

    /**
     * <p>
     * The aggregation function of the filter.
     * </p>
     * 
     * @return The aggregation function of the filter.
     */
    public final AggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(nullOption);
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final String nullOptionAsString() {
        return nullOption;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @return The default configurations for the associated controls. This applies only for filters that are scoped to
     *         multiple sheets.
     */
    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return defaultFilterControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(includeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(includeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultFilterControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericRangeFilter)) {
            return false;
        }
        NumericRangeFilter other = (NumericRangeFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(includeMinimum(), other.includeMinimum())
                && Objects.equals(includeMaximum(), other.includeMaximum())
                && Objects.equals(rangeMinimum(), other.rangeMinimum()) && Objects.equals(rangeMaximum(), other.rangeMaximum())
                && Objects.equals(selectAllOptionsAsString(), other.selectAllOptionsAsString())
                && Objects.equals(aggregationFunction(), other.aggregationFunction())
                && Objects.equals(nullOptionAsString(), other.nullOptionAsString())
                && Objects.equals(defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericRangeFilter").add("FilterId", filterId()).add("Column", column())
                .add("IncludeMinimum", includeMinimum()).add("IncludeMaximum", includeMaximum())
                .add("RangeMinimum", rangeMinimum()).add("RangeMaximum", rangeMaximum())
                .add("SelectAllOptions", selectAllOptionsAsString()).add("AggregationFunction", aggregationFunction())
                .add("NullOption", nullOptionAsString())
                .add("DefaultFilterControlConfiguration", defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "IncludeMinimum":
            return Optional.ofNullable(clazz.cast(includeMinimum()));
        case "IncludeMaximum":
            return Optional.ofNullable(clazz.cast(includeMaximum()));
        case "RangeMinimum":
            return Optional.ofNullable(clazz.cast(rangeMinimum()));
        case "RangeMaximum":
            return Optional.ofNullable(clazz.cast(rangeMaximum()));
        case "SelectAllOptions":
            return Optional.ofNullable(clazz.cast(selectAllOptionsAsString()));
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        case "NullOption":
            return Optional.ofNullable(clazz.cast(nullOptionAsString()));
        case "DefaultFilterControlConfiguration":
            return Optional.ofNullable(clazz.cast(defaultFilterControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterId", FILTER_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("IncludeMinimum", INCLUDE_MINIMUM_FIELD);
        map.put("IncludeMaximum", INCLUDE_MAXIMUM_FIELD);
        map.put("RangeMinimum", RANGE_MINIMUM_FIELD);
        map.put("RangeMaximum", RANGE_MAXIMUM_FIELD);
        map.put("SelectAllOptions", SELECT_ALL_OPTIONS_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        map.put("NullOption", NULL_OPTION_FIELD);
        map.put("DefaultFilterControlConfiguration", DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumericRangeFilter, T> g) {
        return obj -> g.apply((NumericRangeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericRangeFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * Determines whether the minimum value in the filter value range should be included in the filtered results.
         * </p>
         * 
         * @param includeMinimum
         *        Determines whether the minimum value in the filter value range should be included in the filtered
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMinimum(Boolean includeMinimum);

        /**
         * <p>
         * Determines whether the maximum value in the filter value range should be included in the filtered results.
         * </p>
         * 
         * @param includeMaximum
         *        Determines whether the maximum value in the filter value range should be included in the filtered
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMaximum(Boolean includeMaximum);

        /**
         * <p>
         * The minimum value for the filter value range.
         * </p>
         * 
         * @param rangeMinimum
         *        The minimum value for the filter value range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMinimum(NumericRangeFilterValue rangeMinimum);

        /**
         * <p>
         * The minimum value for the filter value range.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericRangeFilterValue.Builder} avoiding
         * the need to create one manually via {@link NumericRangeFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericRangeFilterValue.Builder#build()} is called immediately
         * and its result is passed to {@link #rangeMinimum(NumericRangeFilterValue)}.
         * 
         * @param rangeMinimum
         *        a consumer that will call methods on {@link NumericRangeFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeMinimum(NumericRangeFilterValue)
         */
        default Builder rangeMinimum(Consumer<NumericRangeFilterValue.Builder> rangeMinimum) {
            return rangeMinimum(NumericRangeFilterValue.builder().applyMutation(rangeMinimum).build());
        }

        /**
         * <p>
         * The maximum value for the filter value range.
         * </p>
         * 
         * @param rangeMaximum
         *        The maximum value for the filter value range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMaximum(NumericRangeFilterValue rangeMaximum);

        /**
         * <p>
         * The maximum value for the filter value range.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericRangeFilterValue.Builder} avoiding
         * the need to create one manually via {@link NumericRangeFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericRangeFilterValue.Builder#build()} is called immediately
         * and its result is passed to {@link #rangeMaximum(NumericRangeFilterValue)}.
         * 
         * @param rangeMaximum
         *        a consumer that will call methods on {@link NumericRangeFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeMaximum(NumericRangeFilterValue)
         */
        default Builder rangeMaximum(Consumer<NumericRangeFilterValue.Builder> rangeMaximum) {
            return rangeMaximum(NumericRangeFilterValue.builder().applyMutation(rangeMaximum).build());
        }

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see NumericFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericFilterSelectAllOptions
         */
        Builder selectAllOptions(String selectAllOptions);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see NumericFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericFilterSelectAllOptions
         */
        Builder selectAllOptions(NumericFilterSelectAllOptions selectAllOptions);

        /**
         * <p>
         * The aggregation function of the filter.
         * </p>
         * 
         * @param aggregationFunction
         *        The aggregation function of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(AggregationFunction aggregationFunction);

        /**
         * <p>
         * The aggregation function of the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationFunction.Builder} avoiding the
         * need to create one manually via {@link AggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregationFunction(AggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link AggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(AggregationFunction)
         */
        default Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(AggregationFunction.builder().applyMutation(aggregationFunction).build());
        }

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(String nullOption);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(FilterNullOption nullOption);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * 
         * @param defaultFilterControlConfiguration
         *        The default configurations for the associated controls. This applies only for filters that are scoped
         *        to multiple sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFilterControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultFilterControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)}.
         * 
         * @param defaultFilterControlConfiguration
         *        a consumer that will call methods on {@link DefaultFilterControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)
         */
        default Builder defaultFilterControlConfiguration(
                Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return defaultFilterControlConfiguration(DefaultFilterControlConfiguration.builder()
                    .applyMutation(defaultFilterControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private Boolean includeMinimum;

        private Boolean includeMaximum;

        private NumericRangeFilterValue rangeMinimum;

        private NumericRangeFilterValue rangeMaximum;

        private String selectAllOptions;

        private AggregationFunction aggregationFunction;

        private String nullOption;

        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericRangeFilter model) {
            filterId(model.filterId);
            column(model.column);
            includeMinimum(model.includeMinimum);
            includeMaximum(model.includeMaximum);
            rangeMinimum(model.rangeMinimum);
            rangeMaximum(model.rangeMaximum);
            selectAllOptions(model.selectAllOptions);
            aggregationFunction(model.aggregationFunction);
            nullOption(model.nullOption);
            defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Boolean getIncludeMinimum() {
            return includeMinimum;
        }

        public final void setIncludeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
        }

        @Override
        public final Builder includeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
            return this;
        }

        public final Boolean getIncludeMaximum() {
            return includeMaximum;
        }

        public final void setIncludeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
        }

        @Override
        public final Builder includeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
            return this;
        }

        public final NumericRangeFilterValue.Builder getRangeMinimum() {
            return rangeMinimum != null ? rangeMinimum.toBuilder() : null;
        }

        public final void setRangeMinimum(NumericRangeFilterValue.BuilderImpl rangeMinimum) {
            this.rangeMinimum = rangeMinimum != null ? rangeMinimum.build() : null;
        }

        @Override
        public final Builder rangeMinimum(NumericRangeFilterValue rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
            return this;
        }

        public final NumericRangeFilterValue.Builder getRangeMaximum() {
            return rangeMaximum != null ? rangeMaximum.toBuilder() : null;
        }

        public final void setRangeMaximum(NumericRangeFilterValue.BuilderImpl rangeMaximum) {
            this.rangeMaximum = rangeMaximum != null ? rangeMaximum.build() : null;
        }

        @Override
        public final Builder rangeMaximum(NumericRangeFilterValue rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
            return this;
        }

        public final String getSelectAllOptions() {
            return selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(NumericFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final String getNullOption() {
            return nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(
                DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        @Override
        public NumericRangeFilter build() {
            return new NumericRangeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
