/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that overrides the existing default values for a dataset parameter that is inherited from another
 * dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewDefaultValues implements SdkPojo, Serializable,
        ToCopyableBuilder<NewDefaultValues.Builder, NewDefaultValues> {
    private static final SdkField<List<String>> STRING_STATIC_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringStaticValues")
            .getter(getter(NewDefaultValues::stringStaticValues))
            .setter(setter(Builder::stringStaticValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringStaticValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> DECIMAL_STATIC_VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("DecimalStaticValues")
            .getter(getter(NewDefaultValues::decimalStaticValues))
            .setter(setter(Builder::decimalStaticValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalStaticValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Instant>> DATE_TIME_STATIC_VALUES_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("DateTimeStaticValues")
            .getter(getter(NewDefaultValues::dateTimeStaticValues))
            .setter(setter(Builder::dateTimeStaticValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeStaticValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Long>> INTEGER_STATIC_VALUES_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("IntegerStaticValues")
            .getter(getter(NewDefaultValues::integerStaticValues))
            .setter(setter(Builder::integerStaticValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerStaticValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_STATIC_VALUES_FIELD,
            DECIMAL_STATIC_VALUES_FIELD, DATE_TIME_STATIC_VALUES_FIELD, INTEGER_STATIC_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> stringStaticValues;

    private final List<Double> decimalStaticValues;

    private final List<Instant> dateTimeStaticValues;

    private final List<Long> integerStaticValues;

    private NewDefaultValues(BuilderImpl builder) {
        this.stringStaticValues = builder.stringStaticValues;
        this.decimalStaticValues = builder.decimalStaticValues;
        this.dateTimeStaticValues = builder.dateTimeStaticValues;
        this.integerStaticValues = builder.integerStaticValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringStaticValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringStaticValues() {
        return stringStaticValues != null && !(stringStaticValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of static default values for a given string parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringStaticValues} method.
     * </p>
     * 
     * @return A list of static default values for a given string parameter.
     */
    public final List<String> stringStaticValues() {
        return stringStaticValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the DecimalStaticValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDecimalStaticValues() {
        return decimalStaticValues != null && !(decimalStaticValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of static default values for a given decimal parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDecimalStaticValues} method.
     * </p>
     * 
     * @return A list of static default values for a given decimal parameter.
     */
    public final List<Double> decimalStaticValues() {
        return decimalStaticValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the DateTimeStaticValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDateTimeStaticValues() {
        return dateTimeStaticValues != null && !(dateTimeStaticValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of static default values for a given date time parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDateTimeStaticValues} method.
     * </p>
     * 
     * @return A list of static default values for a given date time parameter.
     */
    public final List<Instant> dateTimeStaticValues() {
        return dateTimeStaticValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerStaticValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegerStaticValues() {
        return integerStaticValues != null && !(integerStaticValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of static default values for a given integer parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerStaticValues} method.
     * </p>
     * 
     * @return A list of static default values for a given integer parameter.
     */
    public final List<Long> integerStaticValues() {
        return integerStaticValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringStaticValues() ? stringStaticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDecimalStaticValues() ? decimalStaticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDateTimeStaticValues() ? dateTimeStaticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerStaticValues() ? integerStaticValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewDefaultValues)) {
            return false;
        }
        NewDefaultValues other = (NewDefaultValues) obj;
        return hasStringStaticValues() == other.hasStringStaticValues()
                && Objects.equals(stringStaticValues(), other.stringStaticValues())
                && hasDecimalStaticValues() == other.hasDecimalStaticValues()
                && Objects.equals(decimalStaticValues(), other.decimalStaticValues())
                && hasDateTimeStaticValues() == other.hasDateTimeStaticValues()
                && Objects.equals(dateTimeStaticValues(), other.dateTimeStaticValues())
                && hasIntegerStaticValues() == other.hasIntegerStaticValues()
                && Objects.equals(integerStaticValues(), other.integerStaticValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewDefaultValues")
                .add("StringStaticValues", hasStringStaticValues() ? stringStaticValues() : null)
                .add("DecimalStaticValues", hasDecimalStaticValues() ? decimalStaticValues() : null)
                .add("DateTimeStaticValues", hasDateTimeStaticValues() ? dateTimeStaticValues() : null)
                .add("IntegerStaticValues", hasIntegerStaticValues() ? integerStaticValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringStaticValues":
            return Optional.ofNullable(clazz.cast(stringStaticValues()));
        case "DecimalStaticValues":
            return Optional.ofNullable(clazz.cast(decimalStaticValues()));
        case "DateTimeStaticValues":
            return Optional.ofNullable(clazz.cast(dateTimeStaticValues()));
        case "IntegerStaticValues":
            return Optional.ofNullable(clazz.cast(integerStaticValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringStaticValues", STRING_STATIC_VALUES_FIELD);
        map.put("DecimalStaticValues", DECIMAL_STATIC_VALUES_FIELD);
        map.put("DateTimeStaticValues", DATE_TIME_STATIC_VALUES_FIELD);
        map.put("IntegerStaticValues", INTEGER_STATIC_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NewDefaultValues, T> g) {
        return obj -> g.apply((NewDefaultValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewDefaultValues> {
        /**
         * <p>
         * A list of static default values for a given string parameter.
         * </p>
         * 
         * @param stringStaticValues
         *        A list of static default values for a given string parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringStaticValues(Collection<String> stringStaticValues);

        /**
         * <p>
         * A list of static default values for a given string parameter.
         * </p>
         * 
         * @param stringStaticValues
         *        A list of static default values for a given string parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringStaticValues(String... stringStaticValues);

        /**
         * <p>
         * A list of static default values for a given decimal parameter.
         * </p>
         * 
         * @param decimalStaticValues
         *        A list of static default values for a given decimal parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalStaticValues(Collection<Double> decimalStaticValues);

        /**
         * <p>
         * A list of static default values for a given decimal parameter.
         * </p>
         * 
         * @param decimalStaticValues
         *        A list of static default values for a given decimal parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalStaticValues(Double... decimalStaticValues);

        /**
         * <p>
         * A list of static default values for a given date time parameter.
         * </p>
         * 
         * @param dateTimeStaticValues
         *        A list of static default values for a given date time parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeStaticValues(Collection<Instant> dateTimeStaticValues);

        /**
         * <p>
         * A list of static default values for a given date time parameter.
         * </p>
         * 
         * @param dateTimeStaticValues
         *        A list of static default values for a given date time parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeStaticValues(Instant... dateTimeStaticValues);

        /**
         * <p>
         * A list of static default values for a given integer parameter.
         * </p>
         * 
         * @param integerStaticValues
         *        A list of static default values for a given integer parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerStaticValues(Collection<Long> integerStaticValues);

        /**
         * <p>
         * A list of static default values for a given integer parameter.
         * </p>
         * 
         * @param integerStaticValues
         *        A list of static default values for a given integer parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerStaticValues(Long... integerStaticValues);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stringStaticValues = DefaultSdkAutoConstructList.getInstance();

        private List<Double> decimalStaticValues = DefaultSdkAutoConstructList.getInstance();

        private List<Instant> dateTimeStaticValues = DefaultSdkAutoConstructList.getInstance();

        private List<Long> integerStaticValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NewDefaultValues model) {
            stringStaticValues(model.stringStaticValues);
            decimalStaticValues(model.decimalStaticValues);
            dateTimeStaticValues(model.dateTimeStaticValues);
            integerStaticValues(model.integerStaticValues);
        }

        public final Collection<String> getStringStaticValues() {
            if (stringStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringStaticValues;
        }

        public final void setStringStaticValues(Collection<String> stringStaticValues) {
            this.stringStaticValues = StringDatasetParameterValueListCopier.copy(stringStaticValues);
        }

        @Override
        public final Builder stringStaticValues(Collection<String> stringStaticValues) {
            this.stringStaticValues = StringDatasetParameterValueListCopier.copy(stringStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringStaticValues(String... stringStaticValues) {
            stringStaticValues(Arrays.asList(stringStaticValues));
            return this;
        }

        public final Collection<Double> getDecimalStaticValues() {
            if (decimalStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return decimalStaticValues;
        }

        public final void setDecimalStaticValues(Collection<Double> decimalStaticValues) {
            this.decimalStaticValues = DecimalDatasetParameterValueListCopier.copy(decimalStaticValues);
        }

        @Override
        public final Builder decimalStaticValues(Collection<Double> decimalStaticValues) {
            this.decimalStaticValues = DecimalDatasetParameterValueListCopier.copy(decimalStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalStaticValues(Double... decimalStaticValues) {
            decimalStaticValues(Arrays.asList(decimalStaticValues));
            return this;
        }

        public final Collection<Instant> getDateTimeStaticValues() {
            if (dateTimeStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return dateTimeStaticValues;
        }

        public final void setDateTimeStaticValues(Collection<Instant> dateTimeStaticValues) {
            this.dateTimeStaticValues = DateTimeDatasetParameterValueListCopier.copy(dateTimeStaticValues);
        }

        @Override
        public final Builder dateTimeStaticValues(Collection<Instant> dateTimeStaticValues) {
            this.dateTimeStaticValues = DateTimeDatasetParameterValueListCopier.copy(dateTimeStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeStaticValues(Instant... dateTimeStaticValues) {
            dateTimeStaticValues(Arrays.asList(dateTimeStaticValues));
            return this;
        }

        public final Collection<Long> getIntegerStaticValues() {
            if (integerStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return integerStaticValues;
        }

        public final void setIntegerStaticValues(Collection<Long> integerStaticValues) {
            this.integerStaticValues = IntegerDatasetParameterValueListCopier.copy(integerStaticValues);
        }

        @Override
        public final Builder integerStaticValues(Collection<Long> integerStaticValues) {
            this.integerStaticValues = IntegerDatasetParameterValueListCopier.copy(integerStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerStaticValues(Long... integerStaticValues) {
            integerStaticValues(Arrays.asList(integerStaticValues));
            return this;
        }

        @Override
        public NewDefaultValues build() {
            return new NewDefaultValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
