/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logo set configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogoSetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogoSetConfiguration.Builder, LogoSetConfiguration> {
    private static final SdkField<ImageSetConfiguration> PRIMARY_FIELD = SdkField
            .<ImageSetConfiguration> builder(MarshallingType.SDK_POJO).memberName("Primary")
            .getter(getter(LogoSetConfiguration::primary)).setter(setter(Builder::primary))
            .constructor(ImageSetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<ImageSetConfiguration> FAVICON_FIELD = SdkField
            .<ImageSetConfiguration> builder(MarshallingType.SDK_POJO).memberName("Favicon")
            .getter(getter(LogoSetConfiguration::favicon)).setter(setter(Builder::favicon))
            .constructor(ImageSetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Favicon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_FIELD, FAVICON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageSetConfiguration primary;

    private final ImageSetConfiguration favicon;

    private LogoSetConfiguration(BuilderImpl builder) {
        this.primary = builder.primary;
        this.favicon = builder.favicon;
    }

    /**
     * <p>
     * The primary logo.
     * </p>
     * 
     * @return The primary logo.
     */
    public final ImageSetConfiguration primary() {
        return primary;
    }

    /**
     * <p>
     * The favicon logo.
     * </p>
     * 
     * @return The favicon logo.
     */
    public final ImageSetConfiguration favicon() {
        return favicon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(favicon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogoSetConfiguration)) {
            return false;
        }
        LogoSetConfiguration other = (LogoSetConfiguration) obj;
        return Objects.equals(primary(), other.primary()) && Objects.equals(favicon(), other.favicon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogoSetConfiguration").add("Primary", primary()).add("Favicon", favicon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Favicon":
            return Optional.ofNullable(clazz.cast(favicon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Primary", PRIMARY_FIELD);
        map.put("Favicon", FAVICON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogoSetConfiguration, T> g) {
        return obj -> g.apply((LogoSetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogoSetConfiguration> {
        /**
         * <p>
         * The primary logo.
         * </p>
         * 
         * @param primary
         *        The primary logo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(ImageSetConfiguration primary);

        /**
         * <p>
         * The primary logo.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSetConfiguration.Builder} avoiding
         * the need to create one manually via {@link ImageSetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #primary(ImageSetConfiguration)}.
         * 
         * @param primary
         *        a consumer that will call methods on {@link ImageSetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primary(ImageSetConfiguration)
         */
        default Builder primary(Consumer<ImageSetConfiguration.Builder> primary) {
            return primary(ImageSetConfiguration.builder().applyMutation(primary).build());
        }

        /**
         * <p>
         * The favicon logo.
         * </p>
         * 
         * @param favicon
         *        The favicon logo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder favicon(ImageSetConfiguration favicon);

        /**
         * <p>
         * The favicon logo.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSetConfiguration.Builder} avoiding
         * the need to create one manually via {@link ImageSetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #favicon(ImageSetConfiguration)}.
         * 
         * @param favicon
         *        a consumer that will call methods on {@link ImageSetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #favicon(ImageSetConfiguration)
         */
        default Builder favicon(Consumer<ImageSetConfiguration.Builder> favicon) {
            return favicon(ImageSetConfiguration.builder().applyMutation(favicon).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageSetConfiguration primary;

        private ImageSetConfiguration favicon;

        private BuilderImpl() {
        }

        private BuilderImpl(LogoSetConfiguration model) {
            primary(model.primary);
            favicon(model.favicon);
        }

        public final ImageSetConfiguration.Builder getPrimary() {
            return primary != null ? primary.toBuilder() : null;
        }

        public final void setPrimary(ImageSetConfiguration.BuilderImpl primary) {
            this.primary = primary != null ? primary.build() : null;
        }

        @Override
        public final Builder primary(ImageSetConfiguration primary) {
            this.primary = primary;
            return this;
        }

        public final ImageSetConfiguration.Builder getFavicon() {
            return favicon != null ? favicon.toBuilder() : null;
        }

        public final void setFavicon(ImageSetConfiguration.BuilderImpl favicon) {
            this.favicon = favicon != null ? favicon.build() : null;
        }

        @Override
        public final Builder favicon(ImageSetConfiguration favicon) {
            this.favicon = favicon;
            return this;
        }

        @Override
        public LogoSetConfiguration build() {
            return new LogoSetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
