/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFoldersResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListFoldersResponse.Builder, ListFoldersResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListFoldersResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<List<FolderSummary>> FOLDER_SUMMARY_LIST_FIELD = SdkField
            .<List<FolderSummary>> builder(MarshallingType.LIST)
            .memberName("FolderSummaryList")
            .getter(getter(ListFoldersResponse::folderSummaryList))
            .setter(setter(Builder::folderSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FolderSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FolderSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFoldersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListFoldersResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FOLDER_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer status;

    private final List<FolderSummary> folderSummaryList;

    private final String nextToken;

    private final String requestId;

    private ListFoldersResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.folderSummaryList = builder.folderSummaryList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the FolderSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFolderSummaryList() {
        return folderSummaryList != null && !(folderSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic
     * information about the folders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolderSummaryList} method.
     * </p>
     * 
     * @return A structure that contains all of the folders in the Amazon Web Services account. This structure provides
     *         basic information about the folders.
     */
    public final List<FolderSummary> folderSummaryList() {
        return folderSummaryList;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasFolderSummaryList() ? folderSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoldersResponse)) {
            return false;
        }
        ListFoldersResponse other = (ListFoldersResponse) obj;
        return Objects.equals(status(), other.status()) && hasFolderSummaryList() == other.hasFolderSummaryList()
                && Objects.equals(folderSummaryList(), other.folderSummaryList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFoldersResponse").add("Status", status())
                .add("FolderSummaryList", hasFolderSummaryList() ? folderSummaryList() : null).add("NextToken", nextToken())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FolderSummaryList":
            return Optional.ofNullable(clazz.cast(folderSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("FolderSummaryList", FOLDER_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFoldersResponse, T> g) {
        return obj -> g.apply((ListFoldersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFoldersResponse> {
        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * A structure that contains all of the folders in the Amazon Web Services account. This structure provides
         * basic information about the folders.
         * </p>
         * 
         * @param folderSummaryList
         *        A structure that contains all of the folders in the Amazon Web Services account. This structure
         *        provides basic information about the folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderSummaryList(Collection<FolderSummary> folderSummaryList);

        /**
         * <p>
         * A structure that contains all of the folders in the Amazon Web Services account. This structure provides
         * basic information about the folders.
         * </p>
         * 
         * @param folderSummaryList
         *        A structure that contains all of the folders in the Amazon Web Services account. This structure
         *        provides basic information about the folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderSummaryList(FolderSummary... folderSummaryList);

        /**
         * <p>
         * A structure that contains all of the folders in the Amazon Web Services account. This structure provides
         * basic information about the folders.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FolderSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FolderSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FolderSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #folderSummaryList(List<FolderSummary>)}.
         * 
         * @param folderSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FolderSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folderSummaryList(java.util.Collection<FolderSummary>)
         */
        Builder folderSummaryList(Consumer<FolderSummary.Builder>... folderSummaryList);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Integer status;

        private List<FolderSummary> folderSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoldersResponse model) {
            super(model);
            status(model.status);
            folderSummaryList(model.folderSummaryList);
            nextToken(model.nextToken);
            requestId(model.requestId);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final List<FolderSummary.Builder> getFolderSummaryList() {
            List<FolderSummary.Builder> result = FolderSummaryListCopier.copyToBuilder(this.folderSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolderSummaryList(Collection<FolderSummary.BuilderImpl> folderSummaryList) {
            this.folderSummaryList = FolderSummaryListCopier.copyFromBuilder(folderSummaryList);
        }

        @Override
        public final Builder folderSummaryList(Collection<FolderSummary> folderSummaryList) {
            this.folderSummaryList = FolderSummaryListCopier.copy(folderSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderSummaryList(FolderSummary... folderSummaryList) {
            folderSummaryList(Arrays.asList(folderSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderSummaryList(Consumer<FolderSummary.Builder>... folderSummaryList) {
            folderSummaryList(Stream.of(folderSummaryList).map(c -> FolderSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListFoldersResponse build() {
            return new ListFoldersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
